/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.impl;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.module.impl.ClassLoaderProxy;
import com.sun.enterprise.module.impl.ModuleImpl;
import com.sun.enterprise.module.impl.ModulesRegistryImpl;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

final class ModuleClassLoader
extends ClassLoaderProxy {
    private final ReentrantLock lock = new ReentrantLock();
    private final ModuleImpl module;
    private volatile boolean initialized = false;
    private StackTraceElement[] initializerThread;
    private String initializerClassName;
    private static final String META_INF_SERVICES = "META-INF/services/";

    public ModuleClassLoader(ModuleImpl owner, URL[] shared, ClassLoader parent) {
        super(shared, parent);
        this.module = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.lock.lock();
        try {
            this.initialize(name);
            Class<?> clazz = super.loadClass(name, resolve);
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            ModuleImpl m = this.module.getRegistry().getProvidingModule(name);
            if (m != null) {
                return m.getPrivateClassLoader().loadClass(name);
            }
            throw e;
        }
    }

    @Override
    public URL getResource(String name) {
        this.initialize(name);
        if (name.startsWith(META_INF_SERVICES)) {
            String serviceName = name.substring(META_INF_SERVICES.length());
            ModulesRegistryImpl reg = this.module.getRegistry();
            for (HK2Module m : reg.getModules()) {
                List<URL> list = m.getMetadata().getDescriptors(serviceName);
                if (list.isEmpty()) continue;
                return list.get(0);
            }
            return super.getResource(name);
        }
        URL url = super.getResource(name);
        if (url != null) {
            return url;
        }
        if (name.endsWith(".class")) {
            String className = name.replace('/', '.').substring(0, name.length() - 6);
            ModuleImpl m = this.module.getRegistry().getProvidingModule(className);
            if (m != null) {
                return m.getPrivateClassLoader().getResource(name);
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        this.initialize(name);
        if (name.startsWith(META_INF_SERVICES)) {
            String serviceName = name.substring(META_INF_SERVICES.length());
            Vector<URL> urls = new Vector<URL>();
            ModulesRegistryImpl reg = this.module.getRegistry();
            for (HK2Module m : reg.getModules()) {
                urls.addAll(m.getMetadata().getDescriptors(serviceName));
            }
            return urls.elements();
        }
        return super.getResources(name);
    }

    private void initialize(String name) {
        if (this.initialized) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.initialized) {
                if (this.module.getState().equals((Object)ModuleState.PREPARING)) {
                    return;
                }
                this.initialized = true;
                this.module.start();
                this.initializerThread = Thread.currentThread().getStackTrace();
                this.initializerClassName = name;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void dumpState(PrintStream writer) {
        writer.println("Class-Path:");
        for (URL uRL : this.getURLs()) {
            writer.println("  " + uRL);
        }
        if (this.initializerThread != null) {
            writer.println("Initialized when " + this.initializerClassName + " was requested by :");
            for (Serializable serializable : this.initializerThread) {
                writer.println("  " + ((StackTraceElement)serializable).toString());
            }
        }
    }

    @Override
    public void stop() {
        if (!this.module.isSticky()) {
            LogHelper.getDefaultLogger().info("ModuleClassLoader stopped " + this.module.getModuleDefinition().getName());
            super.stop();
            this.module.stop();
        }
    }

    public ModuleImpl getOwner() {
        return this.module;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("ModuleClassLoader(name=").append(this.module.getName());
        s.append(", parent=").append(super.toString());
        s.append(",init=").append(this.initialized);
        s.append(",URls[]=");
        for (URL url : this.getURLs()) {
            s.append(url).append(",");
        }
        s.append(")");
        for (ClassLoader surrogate : super.getDelegates()) {
            s.append("\n ref : ").append(surrogate.toString());
        }
        return s.toString();
    }
}

