/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.spi.FaceletConfigResourceProvider;
import com.sun.faces.spi.FacesConfigResourceProvider;
import com.sun.faces.spi.ServiceFactoryUtils;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationResourceProviderFactory {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    public static ConfigurationResourceProvider[] createProviders(ProviderType providerType) {
        String[] serviceEntries = ServiceFactoryUtils.getServiceEntries(providerType.servicesKey);
        ArrayList<ConfigurationResourceProvider> providers = new ArrayList<ConfigurationResourceProvider>();
        if (serviceEntries.length > 0) {
            for (String serviceEntry : serviceEntries) {
                try {
                    ConfigurationResourceProvider provider = (ConfigurationResourceProvider)ServiceFactoryUtils.getProviderFromEntry(serviceEntry, null, null);
                    if (provider == null) continue;
                    if (ProviderType.FacesConfig == providerType) {
                        if (!(provider instanceof FacesConfigResourceProvider)) {
                            throw new IllegalStateException("Expected ConfigurationResourceProvider type to be an instance of FacesConfigResourceProvider");
                        }
                    } else if (!(provider instanceof FaceletConfigResourceProvider)) {
                        throw new IllegalStateException("Expected ConfigurationResourceProvider type to be an instance of FaceletConfigResourceProvider");
                    }
                    providers.add(provider);
                }
                catch (ClassCastException provider) {
                }
                catch (FacesException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, e.toString(), e);
                }
            }
        } else {
            Iterator<Object> iterator = (switch (providerType) {
                case ProviderType.FacesConfig -> ServiceLoader.load(FacesConfigResourceProvider.class);
                case ProviderType.FaceletConfig -> ServiceLoader.load(FaceletConfigResourceProvider.class);
                default -> throw new UnsupportedOperationException(providerType.servicesKey + " cannot be loaded via ServiceLoader API.");
            }).iterator();
            while (iterator.hasNext()) {
                providers.add((ConfigurationResourceProvider)iterator.next());
            }
        }
        return providers.toArray(new ConfigurationResourceProvider[providers.size()]);
    }

    public static enum ProviderType {
        FacesConfig("com.sun.faces.spi.FacesConfigResourceProvider"),
        FaceletConfig("com.sun.faces.spi.FaceletConfigResourceProvider");

        String servicesKey;

        private ProviderType(String servicesKey) {
            this.servicesKey = servicesKey;
        }
    }
}

