/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ResolversRegistry;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.util.Cache;
import com.sun.faces.util.LRUCache;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ELUtils {
    private static final int compositeComponentEvaluationCacheMaxSize = 1000;
    private static final Pattern COMPOSITE_COMPONENT_EXPRESSION = Pattern.compile(".(?:[ ]+|[\\[{,(])cc[.].+[}]");
    private static final Matcher COMPOSITE_COMPONENT_EXPRESSION_MATCHER = COMPOSITE_COMPONENT_EXPRESSION.matcher("");
    private static final Cache.Factory<String, Boolean> isCompositeExpressionInit = new Cache.Factory<String, Boolean>(){

        @Override
        public Boolean newInstance(String expression) {
            return expression == null ? Boolean.FALSE.booleanValue() : COMPOSITE_COMPONENT_EXPRESSION_MATCHER.reset(expression).find();
        }
    };
    private static final LRUCache<String, Boolean> compositeComponentEvaluationCache = new LRUCache<String, Boolean>(isCompositeExpressionInit, 1000);
    private static final Pattern COMPOSITE_COMPONENT_LOOKUP_WITH_ARGS = Pattern.compile("(?:[ ]+|[\\[{,(])cc[.]attrs[.]\\w+[(].+[)]");
    private static final Pattern METHOD_EXPRESSION_LOOKUP = Pattern.compile(".[{]cc[.]attrs[.]\\w+[}]");

    private ELUtils() {
        throw new IllegalStateException();
    }

    public static boolean isCompositeComponentExpr(String expression) {
        return compositeComponentEvaluationCache.get(expression);
    }

    public static boolean isCompositeComponentMethodExprLookup(String expression) {
        return METHOD_EXPRESSION_LOOKUP.matcher(expression).matches();
    }

    public static boolean isCompositeComponentLookupWithArgs(String expression) {
        return COMPOSITE_COMPONENT_LOOKUP_WITH_ARGS.matcher(expression).find();
    }

    public static void buildFacesResolver(FacesCompositeELResolver composite, ApplicationAssociate associate) {
        ELUtils.checkNotNull(composite, associate);
        ELUtils.addCDIELResolver(composite);
        ResolversRegistry elRegistry = associate.getGlobalResolversRegistry();
        composite.add(elRegistry.FLASH_RESOLVER);
        composite.addPropertyELResolver(elRegistry.COMPOSITE_COMPONENT_ATTRIBUTES_EL_RESOLVER);
        ELUtils.addELResolvers(composite, associate.getELResolversFromFacesConfig());
        composite.add((ELResolver)associate.getApplicationELResolvers());
        if (WebConfiguration.getInstance().isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.InterpretEmptyStringSubmittedValuesAsNull)) {
            composite.addPropertyELResolver(elRegistry.EMPTY_STRING_TO_NULL_RESOLVER);
        }
        composite.addPropertyELResolver(elRegistry.RESOURCE_RESOLVER);
        composite.addPropertyELResolver((ELResolver)elRegistry.BUNDLE_RESOLVER);
        composite.addRootELResolver(elRegistry.FACES_BUNDLE_RESOLVER);
        ELResolver streamELResolver = associate.getExpressionFactory().getStreamELResolver();
        if (streamELResolver != null) {
            composite.addRootELResolver(streamELResolver);
        }
        composite.addRootELResolver((ELResolver)elRegistry.STATIC_FIELD_RESOLVER);
        composite.addPropertyELResolver((ELResolver)elRegistry.MAP_RESOLVER);
        composite.addPropertyELResolver((ELResolver)elRegistry.LIST_RESOLVER);
        composite.addPropertyELResolver((ELResolver)elRegistry.ARRAY_RESOLVER);
        composite.addPropertyELResolver((ELResolver)elRegistry.OPTIONAL_RESOLVER);
        composite.addPropertyELResolver((ELResolver)elRegistry.RECORD_RESOLVER);
        composite.addPropertyELResolver((ELResolver)elRegistry.BEAN_RESOLVER);
        composite.addRootELResolver(elRegistry.SCOPED_RESOLVER);
    }

    public static Object evaluateValueExpression(ValueExpression expression, ELContext elContext) {
        if (expression.isLiteralText()) {
            return expression.getExpressionString();
        }
        return expression.getValue(elContext);
    }

    public static ValueExpression createValueExpression(String expression) {
        return ELUtils.createValueExpression(expression, Object.class);
    }

    public static ValueExpression createValueExpression(String expression, Class<?> expectedType) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), expression, expectedType);
    }

    public static Object coerce(Object value, Class<?> toType) {
        return FacesContext.getCurrentInstance().getApplication().getExpressionFactory().coerceToType(value, toType);
    }

    private static void addELResolvers(CompositeELResolver target, List<ELResolver> resolvers) {
        if (!Util.isEmpty(resolvers)) {
            for (ELResolver resolver : resolvers) {
                target.add(resolver);
            }
        }
    }

    private static void addCDIELResolver(FacesCompositeELResolver composite) {
        composite.add(Util.getCdiBeanManager(FacesContext.getCurrentInstance()).getELResolver());
    }

    private static void checkNotNull(FacesCompositeELResolver composite, ApplicationAssociate associate) {
        if (associate == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "associate"));
        }
        if (composite == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "composite"));
        }
    }

    public static ExpressionFactory getDefaultExpressionFactory(FacesContext facesContext) {
        if (facesContext == null) {
            return null;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext == null) {
            return null;
        }
        return ELUtils.getDefaultExpressionFactory(ApplicationAssociate.getInstance(externalContext), facesContext);
    }

    public static ExpressionFactory getDefaultExpressionFactory(ApplicationAssociate associate, FacesContext facesContext) {
        if (associate == null) {
            return null;
        }
        return associate.getExpressionFactory();
    }
}

