/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

public final class JMod {
    public static final int ABSTRACT = 1;
    public static final int FINAL = 2;
    public static final int NATIVE = 4;
    public static final int PRIVATE = 8;
    public static final int PROTECTED = 16;
    public static final int PUBLIC = 32;
    public static final int STATIC = 64;
    public static final int STRICTFP = 128;
    public static final int SYNCHRONIZED = 256;
    public static final int TRANSIENT = 512;
    public static final int VOLATILE = 1024;
    public static final int DEFAULT = 2048;
    static final int PRIVATE_BITS = -4096;
    static final int INNER = 0x40000000;
    static final int VARARGS = Integer.MIN_VALUE;

    public static boolean oneIsSet(int set, int test) {
        return Integer.bitCount(set & test) == 1;
    }

    public static boolean allAreSet(int set, int test) {
        return (set & test) == test;
    }

    public static boolean allAreClear(int set, int test) {
        return (set & test) == 0;
    }

    public static boolean anyAreSet(int set, int test) {
        return (set & test) != 0;
    }

    public static boolean anyAreClear(int set, int test) {
        return (set & test) != test;
    }

    public static int of(Element element) {
        int result = 0;
        for (Modifier modifier : element.getModifiers()) {
            switch (modifier.name()) {
                case "ABSTRACT": {
                    result |= 1;
                    break;
                }
                case "FINAL": {
                    result |= 2;
                    break;
                }
                case "NATIVE": {
                    result |= 4;
                    break;
                }
                case "PRIVATE": {
                    result |= 8;
                    break;
                }
                case "PROTECTED": {
                    result |= 0x10;
                    break;
                }
                case "PUBLIC": {
                    result |= 0x20;
                    break;
                }
                case "STATIC": {
                    result |= 0x40;
                    break;
                }
                case "STRICTFP": {
                    result |= 0x80;
                    break;
                }
                case "SYNCHRONIZED": {
                    result |= 0x100;
                    break;
                }
                case "TRANSIENT": {
                    result |= 0x200;
                    break;
                }
                case "VOLATILE": {
                    result |= 0x400;
                    break;
                }
                case "DEFAULT": {
                    result |= 0x800;
                }
            }
        }
        if (element instanceof ExecutableElement && ((ExecutableElement)element).isVarArgs()) {
            result |= Integer.MIN_VALUE;
        }
        return result;
    }

    static void write(SourceFileWriter writer, int mods) throws IOException {
        if (JMod.allAreSet(mods, 32)) {
            writer.write(Tokens$.KW.PUBLIC);
        }
        if (JMod.allAreSet(mods, 16)) {
            writer.write(Tokens$.KW.PROTECTED);
        }
        if (JMod.allAreSet(mods, 8)) {
            writer.write(Tokens$.KW.PRIVATE);
        }
        if (JMod.allAreSet(mods, 1)) {
            writer.write(Tokens$.KW.ABSTRACT);
        }
        if (JMod.allAreSet(mods, 64)) {
            writer.write(Tokens$.KW.STATIC);
        }
        if (JMod.allAreSet(mods, 2)) {
            writer.write(Tokens$.KW.FINAL);
        }
        if (JMod.allAreSet(mods, 512)) {
            writer.write(Tokens$.KW.TRANSIENT);
        }
        if (JMod.allAreSet(mods, 1024)) {
            writer.write(Tokens$.KW.VOLATILE);
        }
        if (JMod.allAreSet(mods, 256)) {
            writer.write(Tokens$.KW.SYNCHRONIZED);
        }
        if (JMod.allAreSet(mods, 4)) {
            writer.write(Tokens$.KW.NATIVE);
        }
        if (JMod.allAreSet(mods, 128)) {
            writer.write(Tokens$.KW.STRICTFP);
        }
        if (JMod.allAreSet(mods, 2048)) {
            writer.write(Tokens$.KW.DEFAULT);
        }
    }
}

