/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.heartbeat;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.spi.Heartbeat;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.spi.HeartbeatCallback;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.MQThreadGroup;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class HeartbeatImpl
implements Heartbeat {
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 2;
    public static final int DEFAULT_TIMEOUT_THRESHOLD = 3;
    private int heartbeatInterval = 2;
    private int timeoutThreshold = 3 * this.heartbeatInterval;
    private HeartbeatCallback cb = null;
    private InetSocketAddress bindEndpoint = null;
    private MQThreadGroup threadGroup = null;
    private Sender sender = null;
    private Receiver receiver = null;
    private boolean started = false;
    private Map endpoints = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getProtocol() {
        return "udp";
    }

    @Override
    public void init(InetSocketAddress endpoint, HeartbeatCallback cb) throws IOException {
        this.threadGroup = new MQThreadGroup("Heartbeat", this.logger, this.br.getKString("B2258"));
        this.bindEndpoint = endpoint;
        this.cb = cb;
        this.receiver = new Receiver();
        this.sender = new Sender();
        this.started = false;
    }

    @Override
    public synchronized void stop() throws IOException {
        this.sender.close();
        this.receiver.close();
    }

    @Override
    public synchronized void addEndpoint(Object key, InetSocketAddress endpoint, int dataLength) throws IOException {
        this.endpoints.put(key, endpoint);
        try {
            this.sender.add(endpoint);
        }
        catch (SocketException e) {
            this.endpoints.remove(endpoint);
            throw e;
        }
        this.receiver.add(endpoint, dataLength);
        if (!this.started) {
            this.receiver.start();
            this.sender.start();
            this.started = true;
        }
    }

    @Override
    public synchronized boolean removeEndpoint(Object key, InetSocketAddress endpoint) throws IOException {
        this.endpoints.remove(key);
        if (!this.endpoints.containsValue(endpoint)) {
            this.sender.remove(endpoint);
            return true;
        }
        return false;
    }

    @Override
    public InetSocketAddress getBindEndpoint() {
        return this.bindEndpoint;
    }

    @Override
    public void setHeartbeatInterval(int interval) {
        this.heartbeatInterval = interval;
    }

    @Override
    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    public void setTimeoutThreshold(int threshold) {
        this.timeoutThreshold = threshold;
    }

    @Override
    public int getTimeoutThreshold() {
        return this.timeoutThreshold;
    }

    class Sender
    extends Thread {
        Map dss;
        DatagramPacket dp;
        boolean closed;

        Sender() throws IOException {
            super((ThreadGroup)HeartbeatImpl.this.threadGroup, "Heartbeat Sender");
            this.dss = Collections.synchronizedMap(new LinkedHashMap());
            this.dp = null;
            this.closed = false;
            this.setPriority(10);
            this.setDaemon(true);
            byte[] buf = new byte[1];
            this.dp = new DatagramPacket(buf, buf.length);
        }

        void add(InetSocketAddress endpoint) throws SocketException {
            if (this.closed) {
                HeartbeatImpl.this.logger.log(4, "Heartbeat.Sender.addEnpoint: closed, ignore");
                return;
            }
            DatagramSocket ds = new DatagramSocket(0, HeartbeatImpl.this.bindEndpoint.getAddress());
            ds.connect(endpoint.getAddress(), endpoint.getPort());
            this.dss.put(endpoint, ds);
        }

        void remove(InetSocketAddress endpoint) {
            DatagramSocket ds = (DatagramSocket)this.dss.remove(endpoint);
            if (ds != null) {
                ds.disconnect();
                ds.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            BrokerResources cfr_ignored_0 = HeartbeatImpl.this.br;
            String exitmsg = HeartbeatImpl.this.br.getKString("B0074", super.getName());
            try {
                while (!this.closed) {
                    try {
                        Object[] keys = null;
                        Map map = HeartbeatImpl.this.endpoints;
                        synchronized (map) {
                            Set ks = HeartbeatImpl.this.endpoints.keySet();
                            keys = ks.toArray(new Object[ks.size()]);
                        }
                        for (int i = 0; i < keys.length && !this.closed; ++i) {
                            try {
                                InetSocketAddress endpoint = (InetSocketAddress)HeartbeatImpl.this.endpoints.get(keys[i]);
                                byte[] data = HeartbeatImpl.this.cb.getBytesToSend(keys[i], endpoint);
                                if (data == null) {
                                    HeartbeatImpl.this.logger.log(16, "Heartbeat.Sender: no data send to " + String.valueOf(endpoint) + " for " + String.valueOf(keys[i]));
                                    continue;
                                }
                                this.dp.setSocketAddress(endpoint);
                                this.dp.setData(data);
                                DatagramSocket ds = (DatagramSocket)this.dss.get(endpoint);
                                if (ds == null) {
                                    HeartbeatImpl.this.logger.log(4, "Heartbeat.Sender: Endpoint " + String.valueOf(endpoint) + " for " + String.valueOf(keys[i]) + " removed. no send");
                                    continue;
                                }
                                if (ds.isClosed() && !this.closed) {
                                    HeartbeatImpl.this.logger.log(4, "Heartbeat.Sender: Endoint " + String.valueOf(endpoint) + " for " + String.valueOf(keys[i]) + " removed. no send");
                                    ds = new DatagramSocket(0, HeartbeatImpl.this.bindEndpoint.getAddress());
                                    ds.connect(endpoint);
                                }
                                if (!ds.isConnected() && !this.closed) {
                                    ds.connect(endpoint);
                                }
                                if (this.closed) continue;
                                try {
                                    ds.send(this.dp);
                                }
                                catch (IOException e) {
                                    HeartbeatImpl.this.cb.heartbeatIOException(keys[i], endpoint, e);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                HeartbeatImpl.this.logger.logStack(16, e.getMessage(), e);
                            }
                        }
                        if (this.closed) continue;
                        try {
                            Thread.sleep((long)HeartbeatImpl.this.heartbeatInterval * 1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Throwable t) {
                        Logger cfr_ignored_1 = HeartbeatImpl.this.logger;
                        HeartbeatImpl.this.logger.logStack(16, super.getName() + ": " + t.getMessage(), t);
                    }
                }
                return;
            }
            finally {
                if (!this.closed) {
                    Logger cfr_ignored_2 = HeartbeatImpl.this.logger;
                    HeartbeatImpl.this.logger.log(16, exitmsg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            this.closed = true;
            this.interrupt();
            Set ks = null;
            InetSocketAddress[] iaddrs = null;
            Map map = this.dss;
            synchronized (map) {
                ks = this.dss.keySet();
                iaddrs = ks.toArray(new InetSocketAddress[ks.size()]);
            }
            for (int i = 0; i < iaddrs.length; ++i) {
                this.remove(iaddrs[i]);
            }
        }
    }

    class Receiver
    extends Thread {
        DatagramSocket ds;
        DatagramPacket dp;
        boolean refreshSize;
        boolean closed;
        int bufSize;
        Vector senderAddrs;

        Receiver() throws IOException {
            super((ThreadGroup)HeartbeatImpl.this.threadGroup, "Heartbeat Receiver");
            this.ds = null;
            this.dp = null;
            this.refreshSize = false;
            this.closed = false;
            this.bufSize = 0;
            this.senderAddrs = new Vector();
            this.setPriority(10);
            this.setDaemon(true);
            this.ds = new DatagramSocket(HeartbeatImpl.this.bindEndpoint);
            BrokerResources cfr_ignored_0 = HeartbeatImpl.this.br;
            HeartbeatImpl.this.logger.log(8, HeartbeatImpl.this.br.getKString("B1187", String.valueOf(HeartbeatImpl.this.bindEndpoint.getAddress()) + ":" + HeartbeatImpl.this.bindEndpoint.getPort()));
        }

        void add(InetSocketAddress endpoint, int dataLength) {
            if (dataLength > this.bufSize) {
                this.bufSize = dataLength;
                this.refreshSize = true;
            }
            this.senderAddrs.add(endpoint.getAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            BrokerResources cfr_ignored_0 = HeartbeatImpl.this.br;
            String exitmsg = HeartbeatImpl.this.br.getKString("B0074", super.getName());
            try {
                while (!this.closed) {
                    try {
                        if ((this.ds == null || this.ds.isClosed()) && !this.closed) {
                            this.ds = new DatagramSocket(HeartbeatImpl.this.bindEndpoint);
                        }
                        if (this.closed) {
                            this.ds.close();
                            continue;
                        }
                        if (this.dp == null || this.refreshSize) {
                            byte[] buf = new byte[this.bufSize];
                            if (this.dp == null) {
                                this.dp = new DatagramPacket(buf, buf.length);
                            }
                            this.dp.setData(buf);
                        }
                        Logger cfr_ignored_1 = HeartbeatImpl.this.logger;
                        HeartbeatImpl.this.logger.log(1, "Heartbeat receiving ..");
                        this.ds.receive(this.dp);
                        Logger cfr_ignored_2 = HeartbeatImpl.this.logger;
                        HeartbeatImpl.this.logger.log(1, "Heartbeat received heartbeat  from " + String.valueOf(this.dp.getSocketAddress()) + ":" + this.dp.getPort());
                        InetSocketAddress sender = (InetSocketAddress)this.dp.getSocketAddress();
                        if (!this.senderAddrs.contains(sender.getAddress())) {
                            Logger cfr_ignored_3 = HeartbeatImpl.this.logger;
                            BrokerResources cfr_ignored_4 = HeartbeatImpl.this.br;
                            HeartbeatImpl.this.logger.log(16, HeartbeatImpl.this.br.getKString("B2123", sender));
                            continue;
                        }
                        try {
                            HeartbeatImpl.this.cb.heartbeatReceived(sender, this.dp.getData());
                        }
                        catch (IOException e) {
                            if (!DEBUG) continue;
                            Logger cfr_ignored_5 = HeartbeatImpl.this.logger;
                            HeartbeatImpl.this.logger.log(8, e.getMessage() + " from " + String.valueOf(this.dp.getSocketAddress()) + ":" + this.dp.getPort() + ". Ignore");
                        }
                    }
                    catch (Throwable t) {
                        if (this.closed) continue;
                        Logger cfr_ignored_6 = HeartbeatImpl.this.logger;
                        HeartbeatImpl.this.logger.logStack(16, super.getName() + ": " + t.getMessage(), t);
                    }
                }
                return;
            }
            finally {
                if (this.ds != null) {
                    this.ds.close();
                }
                if (!this.closed) {
                    Logger cfr_ignored_7 = HeartbeatImpl.this.logger;
                    HeartbeatImpl.this.logger.log(16, exitmsg);
                }
            }
        }

        void close() {
            this.closed = true;
            this.interrupt();
            if (this.ds != null) {
                this.ds.close();
            }
        }
    }
}

