/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Hashtable;

public class CheckpointBrokerHandler
extends AdminCmdHandler {
    private static boolean DEBUG = CheckpointBrokerHandler.getDEBUG();

    public CheckpointBrokerHandler(AdminDataHandler parent) {
        super(parent);
    }

    public void checkpoint() throws BrokerException {
        DestinationList.doCheckpoint(null, true);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + String.valueOf(cmd_props));
        }
        int status = 200;
        String errMsg = null;
        this.logger.log(8, "B1324");
        try {
            this.checkpoint();
        }
        catch (Throwable e) {
            this.logger.log(32, this.getClass().getName() + ": " + String.valueOf(cmd_props), e);
            status = 500;
            errMsg = e.getMessage();
        }
        this.sendReply(con, cmd_msg, 93, status, errMsg);
        return true;
    }

    private void sendReply(IMQConnection con, Packet cmd_msg, int replyType, int status, String errMsg) {
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        CheckpointBrokerHandler.setProperties(reply, replyType, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
    }
}

