/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.naming;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.naming.AdministeredObjectFactory;
import com.sun.messaging.naming.CorruptedConfigurationPropertiesException;
import com.sun.messaging.naming.MissingVersionNumberException;
import com.sun.messaging.naming.UnsupportedVersionNumberException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;

public abstract class CFObjectFactory
extends AdministeredObjectFactory {
    private static final String REF_SECURITYPORT = "securityPort";
    private static final String REF_JMSXUSERID = "JMSXUserID";
    private static final String REF_JMSXAPPID = "JMSXAppID";
    private static final String REF_JMSXPRODUCERTXID = "JMSXProducerTXID";
    private static final String REF_JMSXCONSUMERTXID = "JMSXConsumerTXID";
    private static final String REF_JMSXRCVTIMESTAMP = "JMSXRcvTimestamp";
    private static final String REF_PARM = "parm";
    private static final String REF_HOST = "host";
    private static final String REF_SUBNET = "subnet";
    private static final String REF_ACKTIMEOUT = "ackTimeout";
    private static final String REF_PARM_CONTENT = "--";
    private static final String DEFAULT = "default";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (obj instanceof Reference) {
            ConnectionFactory cf;
            Reference ref = (Reference)obj;
            String refClassName = ref.getClassName();
            if (refClassName.equals(QueueConnectionFactory.class.getName())) {
                cf = new QueueConnectionFactory();
            } else if (refClassName.equals(TopicConnectionFactory.class.getName())) {
                cf = new TopicConnectionFactory();
            } else {
                throw new MissingVersionNumberException();
            }
            RefAddr versionAddr = ref.get("version");
            if (versionAddr == null) {
                throw new MissingVersionNumberException();
            }
            String version = null;
            version = (String)versionAddr.getContent();
            if (!"1.1".equals(version)) {
                throw new UnsupportedVersionNumberException(version);
            }
            cf.setStoredVersion(version);
            RefAddr securityPortAddr = ref.get(REF_SECURITYPORT);
            if (securityPortAddr == null) {
                throw new CorruptedConfigurationPropertiesException();
            }
            securityPortAddr.getContent();
            this.recreateConfigurationObject(cf, ref);
            this.setJMSXProperties(cf, ref);
            return cf;
        }
        return null;
    }

    private void recreateConfigurationObject(ConnectionFactory cf, Reference ref) throws Exception {
        String parm = null;
        String host = null;
        String subnet = null;
        String ackTimeout = null;
        try {
            parm = (String)ref.get(REF_PARM).getContent();
            host = (String)ref.get(REF_HOST).getContent();
            subnet = (String)ref.get(REF_SUBNET).getContent();
            ackTimeout = (String)ref.get(REF_ACKTIMEOUT).getContent();
        }
        catch (NullPointerException e) {
            throw new CorruptedConfigurationPropertiesException();
        }
        if (!REF_PARM_CONTENT.equals(parm)) {
            return;
        }
        int configSize = 1;
        if (!DEFAULT.equals(host)) {
            ++configSize;
        }
        if (!DEFAULT.equals(subnet)) {
            ++configSize;
        }
        if (!DEFAULT.equals(ackTimeout)) {
            ++configSize;
        }
        boolean hostSet = false;
        boolean subnetSet = false;
        boolean ackTimeoutSet = false;
        for (int i = 1; i < configSize; ++i) {
            if (!DEFAULT.equals(host) && !hostSet) {
                String hostString = host.substring(host.indexOf("-s", 0) + 2, host.length()).trim();
                cf.setProperty("imqBrokerHostName", hostString);
                hostSet = true;
                continue;
            }
            if (!DEFAULT.equals(subnet) && !subnetSet) {
                subnetSet = true;
                continue;
            }
            if (DEFAULT.equals(ackTimeout) || ackTimeoutSet) continue;
            String atoString = ackTimeout.substring(ackTimeout.indexOf("-t", 0) + 2, ackTimeout.length()).trim();
            cf.setProperty("imqAckTimeout", atoString);
            ackTimeoutSet = true;
        }
    }

    private void setJMSXProperties(ConnectionFactory cf, Reference ref) throws Exception {
        RefAddr addr = null;
        addr = ref.get(REF_JMSXUSERID);
        if (addr != null && "true".equals(addr.getContent())) {
            cf.setProperty("imqSetJMSXUserID", "true");
        }
        if ((addr = ref.get(REF_JMSXAPPID)) != null && "true".equals(addr.getContent())) {
            cf.setProperty("imqSetJMSXAppID", "true");
        }
        if ((addr = ref.get(REF_JMSXPRODUCERTXID)) != null && "true".equals(addr.getContent())) {
            cf.setProperty("imqSetJMSXProducerTXID", "true");
        }
        if ((addr = ref.get(REF_JMSXCONSUMERTXID)) != null && "true".equals(addr.getContent())) {
            cf.setProperty("imqSetJMSXConsumerTXID", "true");
        }
        if ((addr = ref.get(REF_JMSXRCVTIMESTAMP)) != null && "true".equals(addr.getContent())) {
            cf.setProperty("imqSetJMSXRcvTimestamp", "true");
        }
    }
}

