/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.jws.boot;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.glassfish.appclient.client.acc.UserError;

public class ErrorDisplayDialog {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static ResourceBundle rb;

    public static void showUserError(UserError ue, ResourceBundle rb) {
        ErrorDisplayDialog.showText(ue.messageForGUIDisplay(), rb);
    }

    public static void showErrors(Throwable t, ResourceBundle rb) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        t.printStackTrace(ps);
        ErrorDisplayDialog.showText(baos.toString(), rb);
    }

    private static void showText(String text, ResourceBundle rb) {
        ErrorDisplayDialog.rb = rb;
        JTextArea stackTraceArea = new JTextArea();
        stackTraceArea.setEditable(false);
        stackTraceArea.setRows(16);
        stackTraceArea.setText(text);
        JScrollPane sp = new JScrollPane(stackTraceArea);
        JCheckBox copyToClipboardCB = new JCheckBox(ErrorDisplayDialog.getString("jwsacc.errorDialog.copyToClipboardLabel"));
        boolean copyToClipboard = ErrorDisplayDialog.showDialog(ErrorDisplayDialog.getString("jwsacc.errorDialog.mainMessage.1") + LINE_SEP + ErrorDisplayDialog.getString("jwsacc.errorDialog.mainMessage.2"), sp, copyToClipboardCB);
        if (copyToClipboard) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection ss = new StringSelection(stackTraceArea.getText());
            try {
                cb.setContents(ss, null);
            }
            catch (Throwable e) {
                ErrorDisplayDialog.showDialog(ErrorDisplayDialog.getString("jwsacc.errorDialog.errorCopyingMessage.1") + LINE_SEP + ErrorDisplayDialog.getString("jwsacc.errorDialog.errorCopyingMessage.2"), sp, null);
            }
        }
    }

    private static boolean showDialog(String mainMessage, JScrollPane sp, JCheckBox copyToClipboardCB) {
        Object[] objectArray;
        String close = ErrorDisplayDialog.getString("jwsacc.errorDialog.closeLabel");
        if (copyToClipboardCB == null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = mainMessage;
            objectArray = objectArray2;
            objectArray2[1] = sp;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = mainMessage;
            objectArray3[1] = sp;
            objectArray = objectArray3;
            objectArray3[2] = copyToClipboardCB;
        }
        Object[] displayElements = objectArray;
        JOptionPane pane = new JOptionPane(displayElements, 0, -1, null, new String[]{close}, close);
        JDialog dialog = pane.createDialog(null, ErrorDisplayDialog.getString("jwsacc.errorDialog.title"));
        dialog.setResizable(true);
        dialog.setVisible(true);
        boolean result = copyToClipboardCB == null ? false : copyToClipboardCB.isSelected();
        dialog.dispose();
        return result;
    }

    private static String getString(String key) {
        return rb.getString(key);
    }
}

