/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.glassfish.main.jul.record.GlassFishLogRecord;

class LogRecordBuffer {
    private final BlockingQueue<GlassFishLogRecord> pendingRecords = new LinkedBlockingQueue<GlassFishLogRecord>();
    private final CapacitySemaphore availableCapacity = new CapacitySemaphore();
    private final ReentrantLock lock = new ReentrantLock();
    private volatile int capacity;
    private volatile int maxWait;

    LogRecordBuffer(int capacity) {
        this(capacity, 0);
    }

    LogRecordBuffer(int capacity, int maxWait) {
        this.capacity = capacity;
        this.maxWait = maxWait;
        this.availableCapacity.release(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(int newCapacity, int newMaxWait) {
        int permits;
        if (this.maxWait != newMaxWait) {
            this.maxWait = newMaxWait;
        }
        if ((permits = newCapacity - this.capacity) == 0) {
            return;
        }
        this.lock.lock();
        try {
            if (permits > 0) {
                this.availableCapacity.release(permits);
            } else {
                this.availableCapacity.reducePermits(Math.abs(permits));
            }
            this.capacity = newCapacity;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.pendingRecords.isEmpty();
    }

    public int getSize() {
        return this.pendingRecords.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public GlassFishLogRecord pollOrWait() {
        GlassFishLogRecord logRecord = null;
        try {
            logRecord = this.pendingRecords.take();
            this.availableCapacity.release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return logRecord;
    }

    public GlassFishLogRecord poll() {
        GlassFishLogRecord logRecord = (GlassFishLogRecord)this.pendingRecords.poll();
        if (logRecord != null) {
            this.availableCapacity.release();
        }
        return logRecord;
    }

    public void add(GlassFishLogRecord record) {
        if (this.maxWait > 0) {
            this.addWithTimeout(record);
        } else {
            this.addWithUnlimitedWaiting(record);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addWithTimeout(GlassFishLogRecord record) {
        try {
            if (this.availableCapacity.tryAcquire(this.maxWait, TimeUnit.SECONDS)) {
                this.pendingRecords.add(record);
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.lock.lock();
        try {
            if (this.availableCapacity.tryAcquire(0L, TimeUnit.SECONDS)) {
                this.pendingRecords.add(record);
                this.lock.unlock();
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        int currentCapacity = this.capacity;
        this.availableCapacity.reducePermits(currentCapacity);
        this.pendingRecords.clear();
        this.availableCapacity.drainPermits();
        this.pendingRecords.add(new GlassFishLogRecord(Level.SEVERE, String.valueOf(this) + ": The buffer was forcibly cleared after " + this.maxWait + " s timeout for adding another log record. Log records were lost. It might be caused by a recursive deadlock, you can increase the capacity or the timeout to avoid this.", false));
        this.availableCapacity.release(currentCapacity - 1);
    }

    private void addWithUnlimitedWaiting(GlassFishLogRecord record) {
        try {
            if (this.availableCapacity.tryAcquire(0L, TimeUnit.SECONDS)) {
                this.pendingRecords.add(record);
                return;
            }
            Thread.yield();
            this.availableCapacity.acquire();
            this.pendingRecords.add(record);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return super.toString() + "[usage=" + this.getSize() + "/" + this.getCapacity() + ", maxWaitTime=" + this.maxWait + " s]";
    }

    private static class CapacitySemaphore
    extends Semaphore {
        private static final long serialVersionUID = -4575150599241117311L;

        public CapacitySemaphore() {
            super(0, true);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

