/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.comm;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.TableSchema;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class CommBaseDAOImpl
implements BaseDAO {
    protected static boolean DEBUG = false;
    public Logger logger = Globals.getLogger();
    public BrokerResources br = Globals.getBrokerResources();
    protected BrokerConfig config = Globals.getConfig();

    protected abstract CommDBManager getDBManager() throws BrokerException;

    protected abstract void closeSQLObjects(ResultSet var1, Statement var2, Connection var3, Throwable var4) throws BrokerException;

    @Override
    public int getRowCount(Connection conn, String whereClause) throws BrokerException {
        int count;
        block13: {
            Exception myex;
            ResultSet rs;
            Statement stmt;
            block12: {
                count = -1;
                String sql = new StringBuilder(128).append("SELECT COUNT(*) FROM ").append(this.getTableName()).append((String)(whereClause != null && whereClause.length() > 0 ? " WHERE " + whereClause : "")).toString();
                boolean myConn = false;
                stmt = null;
                rs = null;
                myex = null;
                try {
                    CommDBManager dbMgr = this.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    stmt = conn.createStatement();
                    rs = CommDBManager.executeQueryStatement(stmt, sql);
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4166", sql), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(rs, stmt, conn, myex);
                        } else {
                            this.closeSQLObjects(rs, stmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(rs, stmt, conn, myex);
                break block13;
            }
            this.closeSQLObjects(rs, stmt, null, myex);
        }
        return count;
    }

    @Override
    public void createTable(Connection conn) throws BrokerException {
        String tableName = this.getTableName();
        this.logger.logToAll(8, this.br.getString("B1162", tableName));
        CommDBManager dbMgr = this.getDBManager();
        TableSchema tableSchema = dbMgr.getTableSchema(tableName);
        boolean myConn = false;
        Statement stmt = null;
        String sql = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = dbMgr.getConnection(true);
                myConn = true;
            }
            stmt = conn.createStatement();
            sql = tableSchema.tableSQL;
            CommDBManager.executeUpdateStatement(stmt, sql);
            if (stmt.getWarnings() != null) {
                String emsg = "[" + sql + "]: " + String.valueOf(stmt.getWarnings());
                if (this.config.getBooleanProperty(dbMgr.getJDBCPropPrefix() + ".exitOnCreateTableWarning", Globals.getHAEnabled() && dbMgr.isMysql())) {
                    this.logger.log(32, emsg);
                    try {
                        this.dropTable(conn);
                    }
                    catch (Exception e) {
                        this.logger.log(16, e.toString());
                    }
                    throw new BrokerException(emsg);
                }
                this.logger.log(16, emsg);
            }
            try {
                if (dbMgr.hasSupplementForCreateDrop(tableName)) {
                    dbMgr.dropTableSupplement(stmt, tableSchema, tableName, false);
                    dbMgr.createTableSupplement(stmt, tableSchema, tableName);
                }
            }
            catch (Throwable t) {
                try {
                    this.dropTable(conn);
                }
                catch (Throwable tt) {
                    this.logger.log(16, tt.toString());
                }
                if (t instanceof BrokerException) {
                    throw (BrokerException)t;
                }
                throw new BrokerException(t.getMessage(), t);
            }
            boolean createIndex = true;
            if (createIndex) {
                Iterator itr = tableSchema.indexIterator();
                while (itr.hasNext()) {
                    String indexName = (String)itr.next();
                    sql = tableSchema.getIndex(indexName);
                    this.logger.logToAll(8, this.br.getString("B1163", indexName));
                    CommDBManager.executeUpdateStatement(stmt, sql);
                }
            }
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", (Throwable)rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
            throw new BrokerException(this.br.getKString("B4236", tableName), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(null, stmt, conn, myex);
            } else {
                this.closeSQLObjects(null, stmt, null, myex);
            }
        }
    }

    @Override
    public void createStoredProc(Connection conn) throws BrokerException {
    }

    @Override
    public void dropStoredProc(Connection conn) throws BrokerException {
    }

    @Override
    public void dropTable(Connection conn) throws BrokerException {
        String tableName = this.getTableName();
        this.logger.logToAll(8, this.br.getString("B1164", tableName));
        CommDBManager dbMgr = this.getDBManager();
        TableSchema tableSchema = null;
        if (dbMgr.hasSupplementForCreateDrop(tableName)) {
            tableSchema = dbMgr.getTableSchema(tableName);
        }
        boolean myConn = false;
        String dropSQL = "DROP TABLE " + tableName;
        Statement stmt = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = dbMgr.getConnection(true);
                myConn = true;
            }
            stmt = conn.createStatement();
            CommDBManager.executeUpdateStatement(stmt, dropSQL);
            if (dbMgr.hasSupplementForCreateDrop(tableName)) {
                dbMgr.dropTableSupplement(stmt, tableSchema, tableName, true);
            }
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", (Throwable)rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? CommDBManager.wrapSQLException("[" + dropSQL + "]", (SQLException)e) : e;
            throw new BrokerException(this.br.getKString("B4237", tableName), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(null, stmt, conn, myex);
            } else {
                this.closeSQLObjects(null, stmt, null, myex);
            }
        }
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        this.deleteAll(conn, null);
    }

    protected void deleteAll(Connection conn, String whereClause, String timestampColumn, int chunkSize) throws BrokerException {
        if (chunkSize > 0) {
            this.deleteAllInChunk(conn, whereClause, timestampColumn, chunkSize);
        } else {
            this.deleteAll(conn, whereClause);
        }
    }

    private void deleteAll(Connection conn, String whereClause) throws BrokerException {
        CommDBManager dbMgr = this.getDBManager();
        String tableName = this.getTableName();
        String sql = null;
        sql = dbMgr.isOracle() && whereClause == null ? new StringBuilder(128).append("TRUNCATE TABLE ").append(tableName).toString() : new StringBuilder(128).append("DELETE FROM ").append(tableName).append((String)(whereClause != null && whereClause.length() > 0 ? " WHERE " + whereClause : "")).toString();
        boolean myConn = false;
        Statement stmt = null;
        SQLException myex = null;
        try {
            if (conn == null) {
                conn = dbMgr.getConnection(true);
                myConn = true;
            }
            stmt = conn.createStatement();
            CommDBManager.executeUpdateStatement(stmt, sql);
        }
        catch (SQLException e) {
            myex = e;
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", (Throwable)rbe);
            }
            SQLException ex = CommDBManager.wrapSQLException("[" + sql + "]", e);
            throw new BrokerException(this.br.getKString("B4174", tableName), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(null, stmt, conn, myex);
            } else {
                this.closeSQLObjects(null, stmt, null, myex);
            }
        }
    }

    private void deleteAllInChunk(Connection conn, String whereClause, String timestampColumn, int chunkSize) throws BrokerException {
        int txnIsolation;
        block37: {
            SQLException myex;
            PreparedStatement pstmt;
            block34: {
                ResultSet rs;
                String sql;
                boolean myConn;
                String tableName;
                block32: {
                    block36: {
                        block33: {
                            int rowCount;
                            block30: {
                                block35: {
                                    block31: {
                                        if (whereClause == null) {
                                            whereClause = "";
                                        }
                                        tableName = this.getTableName();
                                        myConn = false;
                                        pstmt = null;
                                        sql = null;
                                        txnIsolation = -1;
                                        myex = null;
                                        CommDBManager dbMgr = this.getDBManager();
                                        if (conn == null) {
                                            conn = dbMgr.getConnection(true);
                                            myConn = true;
                                        } else if (!conn.getAutoCommit()) {
                                            conn.setAutoCommit(true);
                                        }
                                        sql = new StringBuilder(128).append("SELECT COUNT(*)").append(" FROM ").append(tableName).append((String)(whereClause.length() > 0 ? " WHERE " + whereClause : "")).toString();
                                        pstmt = CommDBManager.createPreparedStatement(conn, sql);
                                        rs = pstmt.executeQuery();
                                        rowCount = 0;
                                        if (rs.next()) {
                                            rowCount = rs.getInt(1);
                                        }
                                        this.closeSQLObjects(rs, pstmt, null, null);
                                        if (rowCount != 0) break block30;
                                        if (!myConn) break block31;
                                        this.closeSQLObjects(null, pstmt, conn, myex);
                                        break block35;
                                    }
                                    this.closeSQLObjects(null, pstmt, null, myex);
                                }
                                if (txnIsolation != -1) {
                                    try {
                                        conn.setTransactionIsolation(txnIsolation);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return;
                            }
                            if (rowCount >= chunkSize) break block32;
                            this.deleteAll(conn, whereClause);
                            if (!myConn) break block33;
                            this.closeSQLObjects(null, pstmt, conn, myex);
                            break block36;
                        }
                        this.closeSQLObjects(null, pstmt, null, myex);
                    }
                    if (txnIsolation != -1) {
                        try {
                            conn.setTransactionIsolation(txnIsolation);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return;
                }
                try {
                    sql = new StringBuilder(128).append("SELECT ").append(timestampColumn).append(" FROM ").append(tableName).append((String)(whereClause.length() > 0 ? " WHERE " + whereClause : "")).append(" ORDER BY ").append(timestampColumn).toString();
                    pstmt = CommDBManager.createPreparedStatement(conn, sql);
                    rs = pstmt.executeQuery();
                    List chunkList = Util.getChunkDelimiters(rs, 1, chunkSize);
                    this.closeSQLObjects(rs, pstmt, null, null);
                    txnIsolation = conn.getTransactionIsolation();
                    if (txnIsolation != 2) {
                        conn.setTransactionIsolation(2);
                    }
                    sql = new StringBuilder(128).append("DELETE FROM ").append(tableName).append(" WHERE ").append(timestampColumn).append(" < ?").append((String)(whereClause.length() > 0 ? " AND " + whereClause : "")).toString();
                    pstmt = CommDBManager.createPreparedStatement(conn, sql);
                    Long[] a = chunkList.toArray(new Long[chunkList.size()]);
                    int len = a.length;
                    for (int i = 0; i < len; ++i) {
                        pstmt.setLong(1, a[i]);
                        pstmt.executeUpdate();
                    }
                    if (!myConn) break block34;
                }
                catch (SQLException e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        SQLException ex = CommDBManager.wrapSQLException("[" + sql + "]", e);
                        throw new BrokerException(this.br.getKString("B4174", tableName), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(null, pstmt, conn, myex);
                        } else {
                            this.closeSQLObjects(null, pstmt, null, myex);
                        }
                        if (txnIsolation != -1) {
                            try {
                                conn.setTransactionIsolation(txnIsolation);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(null, pstmt, conn, myex);
                break block37;
            }
            this.closeSQLObjects(null, pstmt, null, myex);
        }
        if (txnIsolation != -1) {
            try {
                conn.setTransactionIsolation(txnIsolation);
            }
            catch (Exception dbMgr) {}
        }
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        LinkedHashMap<CallSite, String> map = new LinkedHashMap<CallSite, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.logStack(32, e.getMessage(), (Throwable)e);
        }
        map.put((CallSite)((Object)("[" + this.getTableName() + "]RowCount")), String.valueOf(count));
        return map;
    }
}

