/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.file;

import com.sun.jndi.fscontext.FSContext;
import com.sun.jndi.fscontext.FSContextFactory;
import com.sun.jndi.fscontext.RefFSContextFactory;
import com.sun.jndi.url.file.fileURLContext;
import java.io.File;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;

public class fileURLContextFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object == null) {
            return new fileURLContext(hashtable);
        }
        if (object instanceof String) {
            return fileURLContextFactory.getUsingURL((String)object, hashtable);
        }
        if (object instanceof String[]) {
            return fileURLContextFactory.getUsingURLs((String[])object, hashtable);
        }
        throw new IllegalArgumentException("fileURLContextFactory.getObjectInstance: argument must be an file URL String or array of iiop URLs");
    }

    static Context getUsingURL(String string, Hashtable hashtable) throws NamingException {
        return RefFSContextFactory.createContext(string, hashtable);
    }

    static ResolveResult getUsingURLIgnoreRest(String string, Hashtable hashtable) throws NamingException {
        if (!string.startsWith("file:")) {
            throw new ConfigurationException("cannot handle url: " + string);
        }
        String string2 = FSContextFactory.getFileNameFromURLString(string);
        Context context = RefFSContextFactory.createContext("file:/", hashtable);
        if (string2.startsWith(File.separator)) {
            string2 = string2.substring(1);
        }
        return new ResolveResult((Object)context, FSContext.parser.parse(string2));
    }

    private static Context getUsingURLs(String[] stringArray, Hashtable hashtable) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            try {
                Context context = fileURLContextFactory.getUsingURL(string, hashtable);
                if (context != null) {
                    return context;
                }
            }
            catch (NamingException namingException) {}
            ++n;
        }
        return null;
    }
}

