/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

class ConsumerStateDAOImpl
extends BaseDAOImpl
implements ConsumerStateDAO {
    private static boolean DEBUG = false;
    private final String tableName;
    private final String insertSQL;
    private final String updateTransactionSQL;
    private final String updateTransactionNoCheckSQL;
    protected final String updateStateSQL;
    private final String updateState2SQL;
    private final String clearTxnSQL;
    private final String deleteByTxnSQL;
    private final String deleteByDstSQL;
    private final String deleteByDstBySessionSQL;
    private final String deleteByMsgSQL;
    private final String selectStateSQL;
    private final String selectStatesByMsgSQL;
    private final String selectTransactionSQL;
    private final String selectCountByMsgSQL;
    private final String selectConsumerIDsByMsgSQL;
    private final String selectTransactionAcksSQL;
    private final String selectAllTransactionAcksSQL;
    private static FaultInjection FI = FaultInjection.getInjection();
    int faultCount = 0;

    ConsumerStateDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        String brokerNotTakenOverClause = Globals.getHAEnabled() ? " AND NOT EXISTS (" + ((BrokerDAOImpl)dbMgr.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")" : "";
        this.tableName = dbMgr.getTableName("MQCONSTATE41");
        this.insertSQL = new StringBuilder(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ? )").toString();
        this.updateTransactionSQL = new StringBuilder(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("TRANSACTION_ID").append(" IS NULL").append(brokerNotTakenOverClause).toString();
        this.updateTransactionNoCheckSQL = new StringBuilder(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("TRANSACTION_ID").append(" <> ?").append(brokerNotTakenOverClause).toString();
        this.updateStateSQL = new StringBuilder(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.updateState2SQL = new StringBuilder(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").toString();
        this.clearTxnSQL = new StringBuilder(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = NULL").append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(brokerNotTakenOverClause).toString();
        this.deleteByTxnSQL = new StringBuilder(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.deleteByDstSQL = new StringBuilder(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" IN ").append("(SELECT msgTbl.").append("ID").append(" FROM ").append(dbMgr.getTableName("MQMSG41")).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND ").append("DESTINATION_ID").append(" = ?)").toString();
        this.deleteByDstBySessionSQL = new StringBuilder(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" IN ").append("(SELECT msgTbl.").append("ID").append(" FROM ").append(dbMgr.getTableName("MQMSG41")).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND sesTbl.").append("ID").append(" = ?").append(" AND ").append("DESTINATION_ID").append(" = ?)").toString();
        this.deleteByMsgSQL = new StringBuilder(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectStateSQL = new StringBuilder(128).append("SELECT ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectStatesByMsgSQL = new StringBuilder(128).append("SELECT ").append("CONSUMER_ID").append(", ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectTransactionSQL = new StringBuilder(128).append("SELECT ").append("TRANSACTION_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectCountByMsgSQL = new StringBuilder(128).append("SELECT COUNT(*) FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectConsumerIDsByMsgSQL = new StringBuilder(128).append("SELECT ").append("CONSUMER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ? ").append(" AND ").append("STATE").append(" <> ").append(2).toString();
        this.selectTransactionAcksSQL = new StringBuilder(128).append("SELECT ").append("CONSUMER_ID").append(", ").append("MESSAGE_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.selectAllTransactionAcksSQL = new StringBuilder(128).append("SELECT ").append("TRANSACTION_ID").append(", ").append("CONSUMER_ID").append(", ").append("MESSAGE_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" IS NOT NULL").toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQCONSTATE41";
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void insert(Connection conn, String dstID, SysMessageID sysMsgID, ConsumerUID[] conUIDs, int[] states, boolean checkMsgExist, boolean replaycheck) throws BrokerException {
        block33: {
            block31: {
                block29: {
                    block32: {
                        block30: {
                            msgID = sysMsgID.getUniqueName();
                            count = 0;
                            myConn = false;
                            pstmt = null;
                            myex = null;
                            dbMgr = DBManager.getDBManager();
                            if (conn == null) {
                                conn = dbMgr.getConnection(false);
                                myConn = true;
                            }
                            if (!checkMsgExist) ** GOTO lbl63
                            cnt = -1;
                            try {
                                cnt = this.getConsumerCount(conn, msgID);
                            }
                            catch (BrokerException e) {
                                e.setSQLRecoverable(true);
                                e.setSQLReplayCheck(replaycheck);
                                throw e;
                            }
                            if (cnt <= 0 || !replaycheck || conUIDs == null) break block29;
                            map = null;
                            try {
                                map = this.getStates(conn, sysMsgID);
                            }
                            catch (BrokerException e) {
                                e.setSQLRecoverable(true);
                                e.setSQLReplayCheck(replaycheck);
                                throw e;
                            }
                            cids = Arrays.asList(conUIDs);
                            itr = map.entrySet().iterator();
                            pair = null;
                            cid = null;
                            while (itr.hasNext()) {
                                pair = itr.next();
                                cid = (ConsumerUID)pair.getKey();
                                st = (Integer)pair.getValue();
                                for (i = 0; i < conUIDs.length; ++i) {
                                    if (!conUIDs[i].equals(cid) || states[i] != st) continue;
                                    cids.remove(conUIDs[i]);
                                }
                            }
                            if (cids.size() != 0) break block29;
                            this.logger.log(8, "B1430", (Object)(msgID + "[" + dstID + "]" + String.valueOf(cids)));
                            if (!myConn) break block30;
                            Util.close(null, pstmt, conn, myex);
                            break block32;
                        }
                        Util.close(null, pstmt, null, myex);
                    }
                    return;
                }
                try {
                    if (cnt > 0) {
                        throw new BrokerException(this.br.getKString("B3084", msgID));
                    }
                    try {
                        dbMgr.getDAOFactory().getMessageDAO().checkMessage(conn, dstID, msgID);
                    }
                    catch (BrokerException e) {
                        if (e.getStatusCode() != 404) {
                            e.setSQLRecoverable(true);
                        }
                        throw e;
                    }
lbl63:
                    // 2 sources

                    dobatch = dbMgr.supportsBatchUpdates();
                    pstmt = DBManager.createPreparedStatement(conn, this.insertSQL);
                    len = conUIDs.length;
                    while (count < len) {
                        pstmt.setString(1, msgID);
                        pstmt.setLong(2, conUIDs[count].longValue());
                        pstmt.setInt(3, states[count]);
                        pstmt.setLong(4, System.currentTimeMillis());
                        if (dobatch) {
                            pstmt.addBatch();
                        } else {
                            pstmt.executeUpdate();
                        }
                        ++count;
                    }
                    if (dobatch) {
                        pstmt.executeBatch();
                    }
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block31;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        if (ConsumerStateDAOImpl.DEBUG && count < conUIDs.length) {
                            this.logger.log(8, "Failed to persist interest: " + conUIDs[count].toString() + "(" + conUIDs[count].getUniqueName() + ")");
                        }
                        replayck = false;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            replayck = true;
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        ex = e instanceof IOException != false ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)e) : (e instanceof SQLException != false ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)e) : e);
                        be = new BrokerException(this.br.getKString("B4105", msgID), ex);
                        be.setSQLRecoverable(true);
                        if (replayck) {
                            be.setSQLReplayCheck(true);
                        }
                        throw be;
                    }
                    catch (Throwable var22_28) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw var22_28;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block33;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateState(Connection conn, DestinationUID dstUID, SysMessageID sysMsgID, ConsumerUID conUID, int state, boolean replaycheck) throws BrokerException {
        String brokerID;
        DBManager dbMgr;
        Exception myex;
        PreparedStatement pstmt;
        boolean myConn;
        String msgID;
        block22: {
            block23: {
                msgID = sysMsgID.getUniqueName();
                myConn = false;
                pstmt = null;
                myex = null;
                try {
                    dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    brokerID = null;
                    if (Globals.getHAEnabled()) {
                        try {
                            brokerID = dbMgr.getDAOFactory().getMessageDAO().getBroker(conn, dstUID, msgID);
                        }
                        catch (BrokerException e) {
                            if (e.getStatusCode() == 404) throw e;
                            e.setSQLRecoverable(true);
                            e.setSQLReplayCheck(replaycheck);
                            throw e;
                        }
                    } else {
                        brokerID = dbMgr.getBrokerID();
                    }
                    if (!replaycheck) break block22;
                    try {
                        int currstate = this.getState(conn, sysMsgID, conUID);
                        if (currstate != state) break block22;
                        this.logger.log(8, "B1430", (Object)(msgID + "[" + String.valueOf(dstUID) + "]" + String.valueOf(conUID) + ":" + state));
                        if (!myConn) break block23;
                    }
                    catch (BrokerException e) {
                        if (e.getStatusCode() == 404) throw e;
                        e.setSQLRecoverable(true);
                        e.setSQLReplayCheck(true);
                        throw e;
                    }
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        boolean replayck = false;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            replayck = true;
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateStateSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4015", conUID.toString(), sysMsgID.toString()), ex);
                        be.setSQLRecoverable(true);
                        if (!replayck) throw be;
                        be.setSQLReplayCheck(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                            throw throwable;
                        }
                        Util.close(null, pstmt, null, myex);
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                return;
            }
            Util.close(null, pstmt, null, myex);
            return;
        }
        if (Globals.getHAEnabled() && !dbMgr.getBrokerID().equals(brokerID)) {
            String emsg = this.br.getKString("B4015", conUID.toString(), sysMsgID.toString());
            StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223[" + emsg + "]"));
            try {
                BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
                HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, dbMgr.getBrokerID());
                this.logger.logStack(32, be.getMessage() + "[" + (String)(bkrInfo == null ? dbMgr.getBrokerID() : bkrInfo.toString()) + "]", (Throwable)be);
                throw be;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw be;
        }
        pstmt = DBManager.createPreparedStatement(conn, this.updateStateSQL);
        pstmt.setInt(1, state);
        pstmt.setString(2, msgID);
        pstmt.setLong(3, conUID.longValue());
        if (pstmt.executeUpdate() == 0) {
            throw new BrokerException(this.br.getKString("B3014", conUID.toString(), msgID), 404);
        }
        if (myConn) {
            Util.close(null, pstmt, conn, myex);
            return;
        }
        Util.close(null, pstmt, null, myex);
    }

    @Override
    public void updateState(Connection conn, DestinationUID dstUID, SysMessageID sysMsgID, ConsumerUID conUID, int newState, int expectedState) throws BrokerException {
        block14: {
            Exception myex;
            PreparedStatement pstmt;
            block13: {
                String msgID = sysMsgID.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.updateState2SQL);
                    pstmt.setInt(1, newState);
                    pstmt.setString(2, msgID);
                    pstmt.setLong(3, conUID.longValue());
                    pstmt.setInt(4, expectedState);
                    if (pstmt.executeUpdate() == 0) {
                        int currentState = this.getState(conn, sysMsgID, conUID);
                        if (currentState != expectedState) {
                            Object[] args = new String[]{conUID.toString(), sysMsgID.toString(), String.valueOf(expectedState), String.valueOf(currentState)};
                            throw new BrokerException(this.br.getKString("B3180", args), 412);
                        }
                        throw new BrokerException(this.br.getKString("B3014", conUID.toString(), msgID), 404);
                    }
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateState2SQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4015", conUID.toString(), sysMsgID.toString()), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block14;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void updateTransaction(Connection conn, SysMessageID sysMsgID, ConsumerUID conUID, TransactionUID txnUID) throws BrokerException {
        Exception myex;
        PreparedStatement pstmt;
        boolean myConn;
        block19: {
            String sql;
            String msgID;
            block20: {
                block22: {
                    block21: {
                        long existingTxnId;
                        msgID = sysMsgID.getUniqueName();
                        myConn = false;
                        pstmt = null;
                        myex = null;
                        sql = this.updateTransactionSQL;
                        DBManager dbMgr = DBManager.getDBManager();
                        if (conn == null) {
                            conn = dbMgr.getConnection(true);
                            myConn = true;
                        }
                        dbMgr.getDAOFactory().getTransactionDAO().checkTransaction(conn, txnUID.longValue());
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        pstmt.setLong(1, txnUID.longValue());
                        pstmt.setString(2, msgID);
                        pstmt.setLong(3, conUID.longValue());
                        if (Globals.getHAEnabled()) {
                            pstmt.setString(4, dbMgr.getBrokerID());
                        }
                        if (pstmt.executeUpdate() != 0) break block19;
                        if (Globals.getHAEnabled()) {
                            String brokerID = dbMgr.getBrokerID();
                            BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
                            if (dao.isBeingTakenOver(conn, brokerID)) {
                                StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, brokerID);
                                    this.logger.logStack(32, be.getMessage() + "[" + (String)(bkrInfo == null ? brokerID : bkrInfo.toString()) + "]", (Throwable)be);
                                }
                                catch (Throwable bkrInfo) {
                                    // empty catch block
                                }
                                throw be;
                            }
                        }
                        if ((existingTxnId = this.getTransaction(conn, sysMsgID, conUID)) <= 0L) break block20;
                        TransactionUID oldTxnUID = new TransactionUID(existingTxnId);
                        TransactionState ts = dbMgr.getDAOFactory().getTransactionDAO().getTransactionState(conn, oldTxnUID);
                        Object[] args = new String[]{"[" + String.valueOf(sysMsgID) + ", " + String.valueOf(conUID) + "]", String.valueOf(oldTxnUID) + "[" + String.valueOf(ts) + "]", txnUID.toString()};
                        this.logger.log(16, this.br.getKString("B2296", args));
                        this.updateTransactionNoCheck(conn, sysMsgID, conUID, txnUID);
                        if (!myConn) break block21;
                        Util.close(null, pstmt, conn, myex);
                        break block22;
                    }
                    Util.close(null, pstmt, null, myex);
                }
                return;
            }
            try {
                throw new BrokerException(this.br.getKString("B3014", conUID.toString(), msgID), 404);
            }
            catch (Exception e) {
                try {
                    myex = e;
                    try {
                        if (conn != null && !conn.getAutoCommit()) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException rbe) {
                        this.logger.log(32, "B4080[" + sql + "]", (Throwable)rbe);
                    }
                    if (e instanceof BrokerException) {
                        throw (BrokerException)e;
                    }
                    Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                    throw new BrokerException(this.br.getKString("B4015", conUID.toString(), sysMsgID.toString()), ex);
                }
                catch (Throwable throwable) {
                    if (myConn) {
                        Util.close(null, pstmt, conn, myex);
                    } else {
                        Util.close(null, pstmt, null, myex);
                    }
                    throw throwable;
                }
            }
        }
        if (myConn) {
            Util.close(null, pstmt, conn, myex);
        } else {
            Util.close(null, pstmt, null, myex);
        }
    }

    private void updateTransactionNoCheck(Connection conn, SysMessageID sysMsgID, ConsumerUID conUID, TransactionUID txnUID) throws BrokerException {
        block19: {
            Exception myex;
            PreparedStatement pstmt;
            block18: {
                String msgID = sysMsgID.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                String sql = this.updateTransactionNoCheckSQL;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    dbMgr.getDAOFactory().getTransactionDAO().checkTransaction(conn, txnUID.longValue());
                    pstmt = DBManager.createPreparedStatement(conn, sql);
                    pstmt.setLong(1, txnUID.longValue());
                    pstmt.setString(2, msgID);
                    pstmt.setLong(3, conUID.longValue());
                    pstmt.setLong(4, txnUID.longValue());
                    if (Globals.getHAEnabled()) {
                        pstmt.setString(5, dbMgr.getBrokerID());
                    }
                    if (pstmt.executeUpdate() == 0) {
                        long existingTxnId;
                        if (Globals.getHAEnabled()) {
                            String brokerID = dbMgr.getBrokerID();
                            BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
                            if (dao.isBeingTakenOver(conn, brokerID)) {
                                StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, brokerID);
                                    this.logger.logStack(32, be.getMessage() + "[" + (String)(bkrInfo == null ? brokerID : bkrInfo.toString()) + "]", (Throwable)be);
                                }
                                catch (Throwable bkrInfo) {
                                    // empty catch block
                                }
                                throw be;
                            }
                        }
                        if ((existingTxnId = this.getTransaction(conn, sysMsgID, conUID)) > 0L) {
                            TransactionUID oldTxnUID = new TransactionUID(existingTxnId);
                            TransactionState ts = dbMgr.getDAOFactory().getTransactionDAO().getTransactionState(conn, oldTxnUID);
                            Object[] args = new String[]{"[" + String.valueOf(sysMsgID) + ", " + String.valueOf(conUID) + "]TID=" + String.valueOf(oldTxnUID) + "(" + String.valueOf(ts) + ")", txnUID.toString()};
                            throw new BrokerException(this.br.getKString("B3062", args));
                        }
                        throw new BrokerException(this.br.getKString("B3014", conUID.toString(), msgID), 404);
                    }
                    if (!myConn) break block18;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + sql + "]", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4015", conUID.toString(), sysMsgID.toString()), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block19;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void clearTransaction(Connection conn, TransactionUID txnUID) throws BrokerException {
        block19: {
            Exception myex;
            PreparedStatement pstmt;
            block18: {
                long txnID = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    if (ConsumerStateDAOImpl.FI.FAULT_INJECTION) {
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("mqFaultCount", String.valueOf(this.faultCount));
                        if (FI.checkFault("txn.rollback.dbconstate.cleartid.exception", m)) {
                            ++this.faultCount;
                            throw new BrokerException("FAULT INJECTION:" + "txn.rollback.dbconstate.cleartid.exception");
                        }
                    }
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.clearTxnSQL);
                    pstmt.setLong(1, txnID);
                    if (Globals.getHAEnabled()) {
                        pstmt.setString(2, dbMgr.getBrokerID());
                    }
                    if (pstmt.executeUpdate() == 0 && Globals.getHAEnabled()) {
                        String brokerID = dbMgr.getBrokerID();
                        BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
                        if (dao.isBeingTakenOver(conn, brokerID)) {
                            StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                            try {
                                HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, brokerID);
                                this.logger.logStack(32, be.getMessage() + ": " + bkrInfo.toString(), (Throwable)be);
                                be.setStackLogged();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw be;
                        }
                    }
                    if (!myConn) break block18;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.clearTxnSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4225", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block19;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void deleteByMessageID(Connection conn, String msgID) throws BrokerException {
        block12: {
            Exception myex;
            PreparedStatement pstmt;
            block11: {
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.deleteByMsgSQL);
                    pstmt.setString(1, msgID);
                    pstmt.executeUpdate();
                    if (!myConn) break block11;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByMsgSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4037", msgID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block12;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void deleteByTransaction(Connection conn, TransactionUID txnUID) throws BrokerException {
        block12: {
            Exception myex;
            PreparedStatement pstmt;
            block11: {
                long txnID = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.deleteByTxnSQL);
                    pstmt.setLong(1, txnID);
                    pstmt.executeUpdate();
                    if (!myConn) break block11;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByTxnSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4240", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block12;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void deleteByDestinationBySession(Connection conn, DestinationUID dstUID, Long storeSession) throws BrokerException {
        block15: {
            Exception myex;
            PreparedStatement pstmt;
            block14: {
                String dstID = dstUID.toString();
                String sql = this.deleteByDstSQL;
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (storeSession != null) {
                        sql = this.deleteByDstBySessionSQL;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, sql);
                    pstmt.setString(1, dbMgr.getBrokerID());
                    if (storeSession != null) {
                        pstmt.setLong(2, storeSession);
                        pstmt.setString(3, dstID);
                    } else {
                        pstmt.setString(2, dstID);
                    }
                    pstmt.executeUpdate();
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + sql + "]", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4227", dstID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block15;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        String whereClause = null;
        if (Globals.getHAEnabled()) {
            DBManager dbMgr = DBManager.getDBManager();
            whereClause = new StringBuilder(128).append("MESSAGE_ID").append(" IN (SELECT msgTbl.").append("ID").append(" FROM ").append(dbMgr.getTableName("MQMSG41")).append(" msgTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = '").append(dbMgr.getBrokerID()).append("' AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(')').toString();
        }
        this.deleteAll(conn, whereClause, null, 0);
    }

    @Override
    public int getState(Connection conn, SysMessageID sysMsgID, ConsumerUID conUID) throws BrokerException {
        int state;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                state = -1;
                String id = sysMsgID.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectStateSQL);
                    pstmt.setString(1, id);
                    pstmt.setLong(2, conUID.longValue());
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3014", conUID.toString(), id), 404);
                    }
                    state = rs.getInt(1);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStateSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4036", conUID.toString(), id), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return state;
    }

    @Override
    public HashMap getStates(Connection conn, SysMessageID sysMsgID) throws BrokerException {
        HashMap<ConsumerUID, Integer> map;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                map = new HashMap<ConsumerUID, Integer>();
                String id = sysMsgID.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectStatesByMsgSQL);
                    pstmt.setString(1, id);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ConsumerUID cUID = new ConsumerUID(rs.getLong(1));
                        int state = rs.getInt(2);
                        map.put(cUID, state);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStatesByMsgSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4228", id), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return map;
    }

    @Override
    public long getTransaction(Connection conn, SysMessageID sysMsgID, ConsumerUID conUID) throws BrokerException {
        long txnID;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                txnID = -1L;
                String id = sysMsgID.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectTransactionSQL);
                    pstmt.setString(1, id);
                    pstmt.setLong(2, conUID.longValue());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        txnID = rs.getLong(1);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTransactionSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4013", conUID.toString()), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return txnID;
    }

    @Override
    public List getConsumerUIDs(Connection conn, SysMessageID sysMsgID) throws BrokerException {
        ArrayList<ConsumerUID> list;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                list = new ArrayList<ConsumerUID>();
                String id = sysMsgID.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectConsumerIDsByMsgSQL);
                    pstmt.setString(1, id);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ConsumerUID cUID = new ConsumerUID(rs.getLong(1));
                        list.add(cUID);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectConsumerIDsByMsgSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4228", id), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return list;
    }

    @Override
    public List getTransactionAcks(Connection conn, TransactionUID txnUID) throws BrokerException {
        ArrayList<TransactionAcknowledgement> data;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                data = new ArrayList<TransactionAcknowledgement>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectTransactionAcksSQL);
                    pstmt.setLong(1, txnUID.longValue());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ConsumerUID conID = new ConsumerUID(rs.getLong(1));
                        try {
                            SysMessageID msgID = SysMessageID.get((String)rs.getString(2));
                            data.add(new TransactionAcknowledgement(msgID, conID, conID));
                        }
                        catch (Exception e) {
                            this.logger.logStack(32, "B4129", (Object)txnUID, (Throwable)e);
                        }
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTransactionAcksSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4229", txnUID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block15;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return data;
    }

    @Override
    public HashMap getAllTransactionAcks(Connection conn) throws BrokerException {
        HashMap<TransactionUID, Object> data;
        block18: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block17: {
                data = new HashMap<TransactionUID, Object>(100);
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectAllTransactionAcksSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        TransactionUID txnUID = new TransactionUID(rs.getLong(1));
                        ConsumerUID conID = new ConsumerUID(rs.getLong(2));
                        try {
                            SysMessageID msgID = SysMessageID.get((String)rs.getString(3));
                            ArrayList<TransactionAcknowledgement> ackList = (ArrayList<TransactionAcknowledgement>)data.get(txnUID);
                            if (ackList == null) {
                                ackList = new ArrayList<TransactionAcknowledgement>(25);
                                data.put(txnUID, ackList);
                            }
                            ackList.add(new TransactionAcknowledgement(msgID, conID, conID));
                        }
                        catch (Exception e) {
                            this.logger.logStack(32, "B4129", (Object)txnUID, (Throwable)e);
                        }
                    }
                    if (!myConn) break block17;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllTransactionAcksSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4054"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block18;
            }
            Util.close(rs, pstmt, null, myex);
        }
        Set keySet = data.keySet();
        if (!keySet.isEmpty()) {
            for (TransactionUID txnUID : keySet) {
                List ackList = (List)data.get(txnUID);
                data.put(txnUID, ackList.toArray(new TransactionAcknowledgement[ackList.size()]));
            }
        }
        return data;
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put((CallSite)((Object)("Message/Consumer states(" + this.tableName + ")")), String.valueOf(count));
        return map;
    }

    public int getConsumerCount(Connection conn, String msgID) throws BrokerException {
        int count;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                count = -1;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectCountByMsgSQL);
                    pstmt.setString(1, msgID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectCountByMsgSQL + "]", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCountByMsgSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4228", msgID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return count;
    }
}

