/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.web.ContextFacade;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.PEWebContainerFeatureFactoryImpl;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.VirtualServerPipeline;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.logger.CatalinaLogger;
import com.sun.enterprise.web.logger.FileLoggerHandler;
import com.sun.enterprise.web.logger.FileLoggerHandlerFactory;
import com.sun.enterprise.web.logger.VirtualServerGlassFishLogger;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.web.security.RealmAdapter;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.web.ConfigException;
import org.glassfish.embeddable.web.Context;
import org.glassfish.embeddable.web.WebListener;
import org.glassfish.embeddable.web.config.VirtualServerConfig;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.config.GenericGrizzlyListener;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.main.jul.handler.GlassFishLogHandler;
import org.glassfish.web.LogFacade;
import org.glassfish.web.admin.monitor.RequestProbeProvider;
import org.glassfish.web.deployment.archivist.WebArchivist;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.glassfish.web.loader.WebappClassLoader;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualServer
extends StandardHost
implements org.glassfish.embeddable.web.VirtualServer {
    private static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    private static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    private static final String DISABLED = "disabled";
    private static final String ON = "on";
    private static final Logger DEFAULT_LOGGER = LogFacade.getLogger();
    protected static final ResourceBundle rb = DEFAULT_LOGGER.getResourceBundle();
    private final VirtualServerPipeline vsPipeline;
    private final Pipeline origPipeline;
    private String _id;
    protected Logger _logger = DEFAULT_LOGGER;
    private static final String _info = VirtualServer.class.getName() + "/1.0";
    private com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
    private MimeMap mimeMap;
    private boolean allowLinking;
    private String[] cacheControls;
    private ClassLoaderHierarchy classLoaderHierarchy;
    private Domain domain;
    private ServiceLocator services;
    private boolean isActive;
    private String authRealmName;
    private final PEAccessLogValve accessLogValve;
    private String ssoCookieSecure;
    private boolean ssoCookieHttpOnly;
    private String defaultContextPath;
    private ServerContext serverContext;
    private Config serverConfig;
    private GrizzlyService grizzlyService;
    private WebContainer webContainer;
    private boolean ssoFailoverEnabled;
    private volatile FileLoggerHandler fileLoggerHandler;
    private volatile FileLoggerHandlerFactory fileLoggerHandlerFactory;
    private Deployment deployment;
    private ArchiveFactory factory;
    private ActionReport report;
    private VirtualServerConfig config;
    private List<WebListener> listeners = new ArrayList<WebListener>();

    public VirtualServer() {
        this.origPipeline = this.pipeline;
        this.vsPipeline = new VirtualServerPipeline(this);
        this.accessLogValve = new PEAccessLogValve();
        this.accessLogValve.setContainer((Container)this);
    }

    public String getID() {
        return this._id;
    }

    public void setID(String id) {
        this._id = id;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        if (isActive) {
            this.vsPipeline.setIsDisabled(false);
            this.vsPipeline.setIsOff(false);
            if (this.pipeline == this.vsPipeline && !this.vsPipeline.hasRedirects()) {
                this.setPipeline(this.origPipeline);
            }
        }
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public com.sun.enterprise.config.serverbeans.VirtualServer getBean() {
        return this.vsBean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.vsBean = vsBean;
    }

    public MimeMap getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(MimeMap mimeMap) {
        this.mimeMap = mimeMap;
    }

    public String[] getCacheControls() {
        return this.cacheControls;
    }

    public void setCacheControls(String[] cacheControls) {
        this.cacheControls = cacheControls;
    }

    public void setServices(ServiceLocator services) {
        this.services = services;
    }

    public String getInfo() {
        return _info;
    }

    public void setDefaultContextPath(String defaultContextPath) {
        this.defaultContextPath = defaultContextPath;
    }

    public void setFileLoggerHandlerFactory(FileLoggerHandlerFactory factory) {
        this.fileLoggerHandlerFactory = factory;
    }

    public void setClassLoaderHierarchy(ClassLoaderHierarchy clh) {
        this.classLoaderHierarchy = clh;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Container findChild(String contextRoot) {
        if (this.defaultContextPath != null && "/".equals(contextRoot)) {
            return super.findChild(this.defaultContextPath);
        }
        return super.findChild(contextRoot);
    }

    public void configureSingleSignOnCookieSecure(Cookie ssoCookie, HttpServletRequest hreq) {
        super.configureSingleSignOnCookieSecure(ssoCookie, hreq);
        if (this.ssoCookieSecure != null && !this.ssoCookieSecure.equals("dynamic")) {
            ssoCookie.setSecure(Boolean.parseBoolean(this.ssoCookieSecure));
        }
    }

    public void configureSingleSignOnCookieHttpOnly(Cookie ssoCookie) {
        ssoCookie.setHttpOnly(this.ssoCookieHttpOnly);
    }

    public synchronized void addValve(GlassFishValve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    public synchronized void addValve(Valve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    public synchronized void removeValve(GlassFishValve valve) {
        super.removeValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.removeValve(valve);
        } else {
            this.vsPipeline.removeValve(valve);
        }
    }

    private ConfigBeansUtilities getConfigBeansUtilities() {
        if (this.services == null) {
            return null;
        }
        return (ConfigBeansUtilities)this.services.getService(ConfigBeansUtilities.class, new Annotation[0]);
    }

    protected String getDefaultContextPath(Domain domain, ApplicationRegistry appRegistry) {
        String contextRoot = null;
        String webModuleID = this.getDefaultWebModuleID();
        if (webModuleID != null) {
            Applications appsBean = domain.getApplications();
            WebModuleConfig wmInfo = this.findWebModuleInJ2eeApp(appsBean, webModuleID, appRegistry);
            if (wmInfo == null) {
                ConfigBeansUtilities cbu = this.getConfigBeansUtilities();
                if (cbu != null) {
                    contextRoot = cbu.getContextRoot(webModuleID);
                }
            } else {
                contextRoot = wmInfo.getContextPath();
            }
            if (contextRoot == null) {
                Object[] params = new Object[]{webModuleID, this.getID()};
                this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00136", params);
            }
        }
        return contextRoot;
    }

    protected WebModuleConfig getDefaultWebModule(Domain domain, WebArchivist webArchivist, ApplicationRegistry appRegistry) {
        WebModuleConfig webModuleConfig = null;
        String webModuleID = this.getDefaultWebModuleID();
        if (webModuleID != null) {
            Applications appsBean = domain.getApplications();
            webModuleConfig = this.findWebModuleInJ2eeApp(appsBean, webModuleID, appRegistry);
            if (webModuleConfig == null) {
                ConfigBeansUtilities cbu = this.getConfigBeansUtilities();
                String contextRoot = null;
                String location = null;
                if (cbu != null) {
                    contextRoot = cbu.getContextRoot(webModuleID);
                    location = cbu.getLocation(webModuleID);
                }
                if (contextRoot != null && location != null) {
                    File docroot = new File(location);
                    WebBundleDescriptorImpl webBundleDescriptor = webArchivist.getDefaultWebXmlBundleDescriptor();
                    webModuleConfig = new WebModuleConfig();
                    webBundleDescriptor.setName("__default-web-module");
                    webBundleDescriptor.setContextRoot(contextRoot);
                    webModuleConfig.setLocation(docroot);
                    webModuleConfig.setDescriptor(webBundleDescriptor);
                    webModuleConfig.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
                    PrivilegedAction<WebappClassLoader> action = () -> new WebappClassLoader(EmbeddedWebContainer.class.getClassLoader());
                    WebappClassLoader cloader = AccessController.doPrivileged(action);
                    webModuleConfig.setAppClassLoader((ClassLoader)cloader);
                }
            }
            if (webModuleConfig == null) {
                this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00136", new Object[]{webModuleID, this.getID()});
            }
        }
        return webModuleConfig;
    }

    public WebModuleConfig createSystemDefaultWebModuleIfNecessary(WebArchivist webArchivist) {
        WebModuleConfig webModuleConfig = null;
        String docroot = this.getAppBase();
        if (this.getDefaultWebModuleID() == null && this.findChild("") == null && docroot != null) {
            WebBundleDescriptorImpl webBundleDescriptor = webArchivist.getDefaultWebXmlBundleDescriptor();
            webModuleConfig = new WebModuleConfig();
            webBundleDescriptor.setModuleID("__default-web-module");
            webBundleDescriptor.setContextRoot("");
            webModuleConfig.setLocation(new File(docroot));
            webModuleConfig.setDescriptor(webBundleDescriptor);
            webModuleConfig.setParentLoader(this.serverContext.getCommonClassLoader());
            PrivilegedAction<WebappClassLoader> action = () -> new WebappClassLoader(this.serverContext.getCommonClassLoader());
            WebappClassLoader loader = AccessController.doPrivileged(action);
            loader.start();
            webModuleConfig.setAppClassLoader((ClassLoader)loader);
            if (webBundleDescriptor.getApplication() == null) {
                Application application = Application.createApplication();
                application.setVirtual(true);
                application.setName("__default-web-module");
                webBundleDescriptor.setApplication(application);
            }
        }
        return webModuleConfig;
    }

    protected String getDefaultWebModuleID() {
        String webModuleID = this.vsBean.getDefaultWebModule();
        if ("".equals(webModuleID)) {
            webModuleID = null;
        }
        if (webModuleID != null && this._logger.isLoggable(Level.FINE)) {
            Object[] params = new Object[]{webModuleID, this._id};
            this._logger.log(Level.FINE, "AS-WEB-GLUE-00135", params);
        }
        return webModuleID;
    }

    protected WebModuleConfig findWebModuleInJ2eeApp(Applications appsBean, String id, ApplicationRegistry appRegistry) {
        WebModuleConfig webModuleConfig = null;
        int separatorIndex = id.indexOf(":");
        if (separatorIndex == -1) {
            separatorIndex = id.indexOf(35);
        }
        if (separatorIndex != -1) {
            String appID = id.substring(0, separatorIndex);
            String moduleID = id.substring(separatorIndex + 1);
            com.sun.enterprise.config.serverbeans.Application appBean = (com.sun.enterprise.config.serverbeans.Application)appsBean.getModule(com.sun.enterprise.config.serverbeans.Application.class, appID);
            if (appBean != null && Boolean.valueOf(appBean.getEnabled()).booleanValue()) {
                String location = appBean.getLocation();
                String moduleDir = DeploymentUtils.getRelativeEmbeddedModulePath((String)location, (String)moduleID);
                ApplicationInfo appInfo = appRegistry.get(appID);
                Application app = null;
                if (appInfo == null) {
                    Object[] params = new Object[]{id, this.getID()};
                    this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00137", params);
                    return webModuleConfig;
                }
                app = (Application)appInfo.getMetaData(Application.class);
                WebBundleDescriptorImpl webBundleDescriptor = (WebBundleDescriptorImpl)app.getModuleByTypeAndUri(WebBundleDescriptorImpl.class, moduleID);
                String webUri = webBundleDescriptor.getModuleDescriptor().getArchiveUri();
                String contextRoot = webBundleDescriptor.getModuleDescriptor().getContextRoot();
                if (moduleID.equals(webUri)) {
                    StringBuilder dir = new StringBuilder(location);
                    dir.append(File.separator);
                    dir.append(moduleDir);
                    File docroot = new File(dir.toString());
                    webModuleConfig = new WebModuleConfig();
                    webBundleDescriptor.setName(moduleID);
                    webBundleDescriptor.setContextRoot(contextRoot);
                    webModuleConfig.setDescriptor(webBundleDescriptor);
                    webModuleConfig.setLocation(docroot);
                    webModuleConfig.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
                    PrivilegedAction<WebappClassLoader> action = () -> new WebappClassLoader(EmbeddedWebContainer.class.getClassLoader());
                    WebappClassLoader cloader = AccessController.doPrivileged(action);
                    webModuleConfig.setAppClassLoader((ClassLoader)cloader);
                }
            } else {
                Object[] params = new Object[]{id, this.getID()};
                this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00137", params);
            }
        }
        return webModuleConfig;
    }

    public void clearAliases() {
        this.aliases = new String[0];
    }

    private void setIsDisabled(boolean isDisabled) {
        this.vsPipeline.setIsDisabled(isDisabled);
        this.vsPipeline.setIsOff(false);
        if (isDisabled && this.pipeline != this.vsPipeline) {
            this.setPipeline((Pipeline)this.vsPipeline);
        }
    }

    private void setIsOff(boolean isOff) {
        this.vsPipeline.setIsOff(isOff);
        this.vsPipeline.setIsDisabled(false);
        if (isOff && this.pipeline != this.vsPipeline) {
            this.setPipeline((Pipeline)this.vsPipeline);
        }
    }

    private void close(FileLoggerHandler handler) {
        if (handler != null && !handler.isAssociated()) {
            if (this.fileLoggerHandlerFactory != null) {
                this.fileLoggerHandlerFactory.removeHandler(handler.getLogFile());
            }
            handler.flush();
            handler.close();
        }
    }

    private void setLogger(Logger newLogger, String logLevel) {
        this._logger = newLogger;
        CatalinaLogger catalinaLogger = new CatalinaLogger(newLogger);
        this.setLogger(catalinaLogger);
    }

    List<Property> getProperties() {
        return this.vsBean.getProperty();
    }

    public void configure(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String vsDocroot, String vsLogFile, MimeMap vsMimeMap, String logServiceFile, String logLevel) {
        this.setDebug(this.debug);
        this.setAppBase(vsDocroot);
        this.setName(vsID);
        this.setID(vsID);
        this.setBean(vsBean);
        this.setMimeMap(vsMimeMap);
        String defaultContextXmlLocation = "config/context.xml";
        String defaultWebXmlLocation = "config/default-web.xml";
        Property prop = vsBean.getProperty("default-web-xml");
        if (prop != null) {
            defaultWebXmlLocation = prop.getValue();
        }
        boolean allowLinking = false;
        prop = vsBean.getProperty("allowLinking");
        if (prop != null) {
            allowLinking = Boolean.parseBoolean(prop.getValue());
        }
        this.setAllowLinking(allowLinking);
        prop = vsBean.getProperty("contextXmlDefault");
        if (prop != null) {
            defaultContextXmlLocation = prop.getValue();
        }
        this.setDefaultWebXmlLocation(defaultWebXmlLocation);
        this.setDefaultContextXmlLocation(defaultContextXmlLocation);
        String state = vsBean.getState();
        if (state == null) {
            state = ON;
        }
        if (DISABLED.equalsIgnoreCase(state)) {
            this.setIsActive(false);
        } else {
            this.setIsActive(Boolean.parseBoolean(state));
        }
        this.setLogFile(vsLogFile, logLevel, logServiceFile);
    }

    protected void configureCatalinaProperties() {
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                this._logger.log(Level.WARNING, "AS-WEB-GLUE-00141", this.getName());
            }
            if (propName == null) continue;
            if (propName.startsWith("valve_")) {
                this.addValve(propValue);
                continue;
            }
            if (propName.startsWith("listener_")) {
                this.addListener(propValue);
                continue;
            }
            if (!propName.equals("securePagesWithPragma")) continue;
            this.setSecurePagesWithPragma(Boolean.parseBoolean(propValue));
        }
    }

    synchronized void setLogFile(String logFile, String logLevel, String logServiceFile) {
        Handler[] rootHandlers;
        Object newLogger;
        String lname;
        LogManager logManager;
        boolean logFileChanged;
        this._logger.log(Level.CONFIG, "setLogFile(logFile={0}, logServiceFile={1})", new Object[]{logFile, logServiceFile});
        boolean customLog = logFile != null && logServiceFile != null && !new File(logFile).equals(new File(logServiceFile));
        boolean bl = logFileChanged = logFile != null && (this.fileLoggerHandler != null && !logFile.equals(this.fileLoggerHandler.getLogFile()) || this.fileLoggerHandler == null);
        if (!logFileChanged) {
            return;
        }
        if (this.fileLoggerHandler != null) {
            this._logger.removeHandler(this.fileLoggerHandler);
            this.close(this.fileLoggerHandler);
            this.fileLoggerHandler = null;
        }
        if ((logManager = LogManager.getLogManager()).getLogger(lname = DEFAULT_LOGGER.getName() + ".vs." + this.getID()) == null) {
            newLogger = new VirtualServerGlassFishLogger(lname, rb);
            logManager.addLogger((Logger)newLogger);
        }
        newLogger = Objects.requireNonNull(logManager.getLogger(lname), "Failed to get or create a logger " + lname);
        if (!customLog) {
            for (Handler h : this._logger.getHandlers()) {
                ((Logger)newLogger).removeHandler(h);
            }
            ((Logger)newLogger).setUseParentHandlers(true);
            this.setLogger((Logger)newLogger);
            return;
        }
        Handler[] originalLoggerHandlers = ((Logger)newLogger).getHandlers();
        if (originalLoggerHandlers != null) {
            for (Handler h : originalLoggerHandlers) {
                ((Logger)newLogger).removeHandler(h);
            }
        }
        Logger rootLogger = logManager.getLogger("");
        this._logger.finest(() -> "rootLogger=" + String.valueOf(rootLogger));
        if (rootLogger != null && (rootHandlers = rootLogger.getHandlers()) != null) {
            for (Handler h : rootHandlers) {
                if (h instanceof GlassFishLogHandler) continue;
                ((Logger)newLogger).addHandler(h);
            }
        }
        this.fileLoggerHandler = this.fileLoggerHandlerFactory.getHandler(logFile);
        ((Logger)newLogger).addHandler(this.fileLoggerHandler);
        ((Logger)newLogger).setUseParentHandlers(false);
        this.setLogger((Logger)newLogger);
    }

    private void setLogger(Logger newLogger) {
        this._logger = newLogger;
        CatalinaLogger catalinaLogger = new CatalinaLogger(newLogger);
        this.setLogger(catalinaLogger);
    }

    void configureAliases() {
        List hosts = StringUtils.parseStringList((String)this.vsBean.getHosts(), (String)",");
        for (String host : hosts) {
            if (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(host);
        }
    }

    void configureAliases(String ... hosts) {
        for (String host : hosts) {
            if (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(host);
        }
    }

    void configureAuthRealm(SecurityService securityService) {
        List properties = this.vsBean.getProperty();
        if (properties != null && !properties.isEmpty()) {
            for (Property p : properties) {
                if (p == null || !"authRealm".equals(p.getName())) continue;
                this.authRealmName = p.getValue();
                if (this.authRealmName == null) break;
                AuthRealm realm = null;
                List rs = securityService.getAuthRealm();
                if (rs != null && rs.size() > 0) {
                    for (AuthRealm r : rs) {
                        if (r == null || !r.getName().equals(this.authRealmName)) continue;
                        realm = r;
                        break;
                    }
                }
                if (realm != null) break;
                this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00138", new Object[]{this.getID(), this.authRealmName});
                break;
            }
        }
    }

    String getAuthRealmName() {
        return this.authRealmName;
    }

    protected void addValve(String valveName) {
        Object valve = this.safeLoadInstance(valveName);
        if (valve instanceof Valve) {
            this.addValve((Valve)valve);
        } else if (valve instanceof GlassFishValve) {
            this.addValve((GlassFishValve)valve);
        } else {
            this._logger.log(Level.WARNING, "AS-WEB-GLUE-00150", valveName);
        }
    }

    protected void addListener(String listenerName) {
        Object listener = this.safeLoadInstance(listenerName);
        if (listener == null) {
            return;
        }
        if (listener instanceof ContainerListener) {
            this.addContainerListener((ContainerListener)listener);
        } else if (listener instanceof LifecycleListener) {
            this.addLifecycleListener((LifecycleListener)listener);
        } else {
            this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00148", new Object[]{listenerName, this.getID()});
        }
    }

    protected Object loadInstance(String className) throws Exception {
        return this.serverContext.getCommonClassLoader().loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private Object safeLoadInstance(String className) {
        try {
            return this.loadInstance(className);
        }
        catch (Throwable ex) {
            this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00149", ex);
            return null;
        }
    }

    void configureErrorPage() {
        ErrorPage errorPage = null;
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String[] errorParams;
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                this._logger.log(Level.WARNING, "AS-WEB-GLUE-00141", this.getID());
                continue;
            }
            if (!propName.startsWith("send-error_")) continue;
            String path = null;
            String reason = null;
            String status = null;
            for (String errorParam : errorParams = propValue.split(" ")) {
                if (errorParam.startsWith("path=")) {
                    if (path != null) {
                        this._logger.log(Level.WARNING, "AS-WEB-GLUE-00146", new Object[]{propValue, this.getID(), "path"});
                    }
                    path = errorParam.substring("path=".length());
                }
                if (errorParam.startsWith("reason=")) {
                    if (reason != null) {
                        this._logger.log(Level.WARNING, "AS-WEB-GLUE-00146", new Object[]{propValue, this.getID(), "reason"});
                    }
                    reason = errorParam.substring("reason=".length());
                }
                if (!errorParam.startsWith("code=")) continue;
                if (status != null) {
                    this._logger.log(Level.WARNING, "AS-WEB-GLUE-00146", new Object[]{propValue, this.getID(), "code"});
                }
                status = errorParam.substring("code=".length());
            }
            if (path == null || path.length() == 0) {
                this._logger.log(Level.WARNING, "AS-WEB-GLUE-00147", new Object[]{propValue, this.getID()});
            }
            errorPage = new ErrorPage();
            errorPage.setLocation(path);
            errorPage.setErrorCode(status);
            errorPage.setReason(reason);
            this.addErrorPage(errorPage);
        }
    }

    void configureRedirect() {
        this.vsPipeline.clearRedirects();
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String[] redirectParams;
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                this._logger.log(Level.WARNING, "AS-WEB-GLUE-00141", this.getID());
                continue;
            }
            if (!propName.startsWith("redirect_")) continue;
            String from = null;
            String url = null;
            String urlPrefix = null;
            String escape = null;
            for (String redirectParam : redirectParams = propValue.split(" ")) {
                if (redirectParam.startsWith("from=")) {
                    if (from != null) {
                        this._logger.log(Level.WARNING, "AS-WEB-GLUE-00142", new Object[]{propValue, this.getID(), "from"});
                    }
                    from = redirectParam.substring("from=".length());
                }
                if (redirectParam.startsWith("url=")) {
                    if (url != null) {
                        this._logger.log(Level.WARNING, "AS-WEB-GLUE-00142", new Object[]{propValue, this.getID(), "url"});
                    }
                    url = redirectParam.substring("url=".length());
                }
                if (redirectParam.startsWith("url-prefix=")) {
                    if (urlPrefix != null) {
                        this._logger.log(Level.WARNING, "AS-WEB-GLUE-00142", new Object[]{propValue, this.getID(), "url-prefix"});
                    }
                    urlPrefix = redirectParam.substring("url-prefix=".length());
                }
                if (!redirectParam.startsWith("escape=")) continue;
                if (escape != null) {
                    this._logger.log(Level.WARNING, "AS-WEB-GLUE-00142", new Object[]{propValue, this.getID(), "escape"});
                }
                escape = redirectParam.substring("escape=".length());
            }
            if (from == null || from.length() == 0) {
                this._logger.log(Level.WARNING, "AS-WEB-GLUE-00142", new Object[]{propValue, this.getID()});
            }
            if (!(url != null && url.length() != 0 || urlPrefix != null && urlPrefix.length() != 0)) {
                this._logger.log(Level.WARNING, "AS-WEB-GLUE-00143", new Object[]{propValue, this.getID()});
            }
            if (url != null && url.length() > 0 && urlPrefix != null && urlPrefix.length() > 0) {
                this._logger.log(Level.WARNING, "AS-WEB-GLUE-00144", new Object[]{propValue, this.getID()});
            }
            boolean escapeURI = true;
            if (escape != null) {
                if ("yes".equalsIgnoreCase(escape)) {
                    escapeURI = true;
                } else if ("no".equalsIgnoreCase(escape)) {
                    escapeURI = false;
                } else {
                    this._logger.log(Level.WARNING, "AS-WEB-GLUE-00145", new Object[]{propValue, this.getID()});
                }
            }
            this.vsPipeline.addRedirect(from, url, urlPrefix, escapeURI);
        }
        if (this.vsPipeline.hasRedirects()) {
            if (this.pipeline != this.vsPipeline) {
                this.setPipeline((Pipeline)this.vsPipeline);
            }
        } else if (this.isActive && this.pipeline != this.origPipeline) {
            this.setPipeline(this.origPipeline);
        }
    }

    void configureSingleSignOn(boolean globalSSOEnabled, WebContainerFeatureFactory webContainerFeatureFactory, boolean ssoFailoverEnabled) {
        if (!this.isSSOEnabled(globalSSOEnabled)) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "AS-WEB-GLUE-00153", this.getID());
            }
            boolean hasExistingSSO = false;
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                hasExistingSSO = true;
                break;
            }
            this.ssoFailoverEnabled = ssoFailoverEnabled;
            if (hasExistingSSO) {
                this.setSingleSignOnForChildren(null);
            }
        } else {
            Property expireTime;
            Property idle;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "AS-WEB-GLUE-00154", this.getID());
            }
            GlassFishSingleSignOn sso = null;
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof GlassFishSingleSignOn)) continue;
                sso = (GlassFishSingleSignOn)valves[i];
                break;
            }
            if (sso != null && this.ssoFailoverEnabled != ssoFailoverEnabled) {
                this.removeValve((GlassFishValve)sso);
                sso = null;
            }
            if (sso == null) {
                SSOFactory ssoFactory = webContainerFeatureFactory.getSSOFactory();
                sso = ssoFactory.createSingleSignOnValve(this.getName());
                this.ssoFailoverEnabled = ssoFailoverEnabled;
                this.setSingleSignOnForChildren(sso);
                this.addValve((GlassFishValve)sso);
            }
            if ((idle = this.vsBean.getProperty(SSO_MAX_IDLE)) != null && idle.getValue() != null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "AS-WEB-GLUE-00155", new Object[]{idle.getValue(), this.getID()});
                }
                sso.setMaxInactive(Integer.parseInt(idle.getValue()));
            }
            if ((expireTime = this.vsBean.getProperty(SSO_REAP_INTERVAL)) != null && expireTime.getValue() != null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "AS-WEB-GLUE-00156");
                }
                sso.setReapInterval(Integer.parseInt(expireTime.getValue()));
            }
            this.configureSingleSignOnCookieSecure();
            this.configureSingleSignOnCookieHttpOnly();
        }
    }

    void configureState() {
        String stateValue = this.vsBean.getState();
        if (!stateValue.equalsIgnoreCase(ON) && this.getName().equalsIgnoreCase("__asadmin")) {
            throw new IllegalArgumentException("virtual-server __asadmin state property cannot be modified");
        }
        if (stateValue.equalsIgnoreCase(DISABLED)) {
            this.setIsDisabled(true);
        } else if (!ConfigBeansUtilities.toBoolean((String)stateValue)) {
            this.setIsOff(true);
        } else {
            this.setIsActive(true);
        }
    }

    void configureRemoteAddressFilterValve() {
        Property allow = this.vsBean.getProperty("allowRemoteAddress");
        Property deny = this.vsBean.getProperty("denyRemoteAddress");
        String allowStr = null;
        String denyStr = null;
        if (allow != null) {
            allowStr = allow.getValue();
        }
        if (deny != null) {
            denyStr = deny.getValue();
        }
        this.configureRemoteAddressFilterValve(allowStr, denyStr);
    }

    protected void configureRemoteAddressFilterValve(String allow, String deny) {
        RemoteAddrValve remoteAddrValve = null;
        if (allow != null || deny != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "AS-WEB-GLUE-00157", new Object[]{this.getID(), allow});
            }
            remoteAddrValve.setAllow(allow);
        }
        if (deny != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "AS-WEB-GLUE-00158", new Object[]{this.getID(), deny});
            }
            remoteAddrValve.setDeny(deny);
        }
        if (remoteAddrValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteAddrValve);
        }
    }

    void configureRemoteHostFilterValve() {
        Property allow = this.vsBean.getProperty("allowRemoteHost");
        Property deny = this.vsBean.getProperty("denyRemoteHost");
        String allowStr = null;
        String denyStr = null;
        if (allow != null) {
            allowStr = allow.getValue();
        }
        if (deny != null) {
            denyStr = deny.getValue();
        }
        this.configureRemoteHostFilterValve(allowStr, denyStr);
    }

    void configureRemoteHostFilterValve(String allow, String deny) {
        RemoteHostValve remoteHostValve = null;
        if (allow != null || deny != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "AS-WEB-GLUE-00157", new Object[]{this.getID(), allow});
            }
            remoteHostValve.setAllow(allow);
        }
        if (deny != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "AS-WEB-GLUE-00158", new Object[]{this.getID(), deny});
            }
            remoteHostValve.setDeny(deny);
        }
        if (remoteHostValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteHostValve);
        }
    }

    void addProbes(boolean globalAccessLoggingEnabled) {
        for (NetworkListener listener : this.getGrizzlyNetworkListeners()) {
            try {
                GrizzlyProxy proxy = (GrizzlyProxy)this.grizzlyService.lookupNetworkProxy(listener);
                if (proxy != null) {
                    GenericGrizzlyListener grizzlyListener = (GenericGrizzlyListener)proxy.getUnderlyingListener();
                    List codecFilters = grizzlyListener.getFilters(HttpCodecFilter.class);
                    if (codecFilters == null || codecFilters.isEmpty()) {
                        if (grizzlyListener.isAjpEnabled()) continue;
                        this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00151", new Object[]{listener.getName(), codecFilters});
                    } else {
                        for (HttpCodecFilter codecFilter : codecFilters) {
                            if (((HttpProbe[])codecFilter.getMonitoringConfig().getProbes()).length != 0) continue;
                            HttpProbeImpl httpProbe = new HttpProbeImpl(listener, this.isAccessLoggingEnabled(globalAccessLoggingEnabled));
                            codecFilter.getMonitoringConfig().addProbes((Object[])new HttpProbe[]{httpProbe});
                        }
                    }
                    grizzlyListener.getTransport().getConnectionMonitoringConfig().addProbes((Object[])new ConnectionProbe[]{new ConnectionProbe.Adapter(){
                        RequestProbeProvider requestProbeProvider;
                        {
                            this.requestProbeProvider = VirtualServer.this.webContainer.getRequestProbeProvider();
                        }

                        public void onReadEvent(Connection connection, Buffer data, int size) {
                            if (this.requestProbeProvider != null) {
                                this.requestProbeProvider.dataReceivedEvent(size, VirtualServer.this._id);
                            }
                        }

                        public void onWriteEvent(Connection connection, Buffer data, long size) {
                            if (this.requestProbeProvider != null) {
                                this.requestProbeProvider.dataSentEvent(size, VirtualServer.this._id);
                            }
                        }
                    }});
                    continue;
                }
                this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00167", new Object[]{listener.getName()});
            }
            catch (Exception ex) {
                this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00152", ex);
            }
        }
    }

    void reconfigureAccessLog(String globalAccessLogBufferSize, String globalAccessLogWriteInterval, ServiceLocator services, Domain domain, boolean globalAccessLoggingEnabled) {
        try {
            boolean start;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
            }
            if ((start = this.accessLogValve.updateVirtualServerProperties(this.vsBean.getId(), this.vsBean, domain, services, globalAccessLogBufferSize, globalAccessLogWriteInterval)) && this.isAccessLoggingEnabled(globalAccessLoggingEnabled)) {
                this.enableAccessLogging();
            } else {
                this.disableAccessLogging();
            }
        }
        catch (LifecycleException le) {
            this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00161", le);
        }
    }

    void reconfigureAccessLog(HttpService httpService, WebContainerFeatureFactory webcontainerFeatureFactory) {
        try {
            boolean restart = false;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
                restart = true;
            }
            this.accessLogValve.updateAccessLogAttributes(httpService, webcontainerFeatureFactory);
            if (restart) {
                this.accessLogValve.start();
                for (HttpProbeImpl p : this.getHttpProbeImpl()) {
                    p.enableAccessLogging();
                }
            }
        }
        catch (LifecycleException le) {
            this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00161", le);
        }
    }

    PEAccessLogValve getAccessLogValve() {
        return this.accessLogValve;
    }

    void enableAccessLogging() {
        if (!this.isAccessLogValveActivated()) {
            this.addValve((GlassFishValve)this.accessLogValve);
        } else {
            try {
                if (this.accessLogValve.isStarted()) {
                    this.accessLogValve.stop();
                }
                this.accessLogValve.start();
                for (HttpProbeImpl p : this.getHttpProbeImpl()) {
                    p.enableAccessLogging();
                }
            }
            catch (LifecycleException le) {
                this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00161", le);
            }
        }
    }

    void disableAccessLogging() {
        this.removeValve((GlassFishValve)this.accessLogValve);
        for (HttpProbeImpl httpProbe : this.getHttpProbeImpl()) {
            httpProbe.disableAccessLogging();
        }
    }

    private boolean isAccessLogValveActivated() {
        GlassFishValve[] valves;
        Pipeline pipeline = this.getPipeline();
        if (pipeline != null && (valves = pipeline.getValves()) != null) {
            for (GlassFishValve element : valves) {
                if (!(element instanceof PEAccessLogValve)) continue;
                return true;
            }
        }
        return false;
    }

    void configureCacheControl(String cacheControl) {
        List values;
        if (cacheControl != null && (values = StringUtils.parseStringList((String)cacheControl, (String)",")) != null && !values.isEmpty()) {
            this.setCacheControls(values.toArray(new String[values.size()]));
        }
    }

    private boolean isSSOEnabled(boolean globalSSOEnabled) {
        String ssoEnabled = "inherit";
        if (this.vsBean != null) {
            ssoEnabled = this.vsBean.getSsoEnabled();
        }
        return "inherit".equals(ssoEnabled) && globalSSOEnabled || ConfigBeansUtilities.toBoolean((String)ssoEnabled);
    }

    private void setSingleSignOnForChildren(SingleSignOn sso) {
        block0: for (Container container : this.findChildren()) {
            if (!(container instanceof StandardContext)) continue;
            StandardContext context = (StandardContext)container;
            for (GlassFishValve valve : context.getValves()) {
                if (!(valve instanceof AuthenticatorBase)) continue;
                ((AuthenticatorBase)valve).setSingleSignOn(sso);
                continue block0;
            }
        }
    }

    boolean isAccessLoggingEnabled(boolean globalAccessLoggingEnabled) {
        String enabled = this.vsBean.getAccessLoggingEnabled();
        return "inherit".equals(enabled) && globalAccessLoggingEnabled || ConfigBeansUtilities.toBoolean((String)enabled);
    }

    public void setRealm(Realm realm) {
        if (realm != null && !(realm instanceof RealmAdapter)) {
            this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00140", new Object[]{realm.getClass().getName(), RealmAdapter.class.getName()});
        } else {
            super.setRealm(realm);
        }
    }

    private void configureSingleSignOnCookieSecure() {
        String cookieSecure = this.vsBean.getSsoCookieSecure();
        if (!("true".equalsIgnoreCase(cookieSecure) || "false".equalsIgnoreCase(cookieSecure) || cookieSecure.equalsIgnoreCase("dynamic"))) {
            this._logger.log(Level.WARNING, "AS-WEB-GLUE-00139", new Object[]{cookieSecure, this.getID()});
        } else {
            this.ssoCookieSecure = cookieSecure;
        }
    }

    private void configureSingleSignOnCookieHttpOnly() {
        this.ssoCookieHttpOnly = Boolean.parseBoolean(this.vsBean.getSsoCookieHttpOnly());
    }

    void configureErrorReportValve() {
        Property prop = this.vsBean.getProperty("errorReportValve");
        if (prop != null) {
            this.setErrorReportValveClass(prop.getValue());
        }
    }

    void setServerContext(ServerContext serverContext) {
        this.serverContext = serverContext;
    }

    void setServerConfig(Config serverConfig) {
        this.serverConfig = serverConfig;
    }

    void setGrizzlyService(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
    }

    void setWebContainer(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    public void setDocRoot(File docRoot) {
        this.setAppBase(docRoot.getPath());
    }

    public File getDocRoot() {
        return new File(this.getAppBase());
    }

    public void setWebListeners(WebListener ... webListeners) {
        if (webListeners != null) {
            this.listeners = Arrays.asList(webListeners);
        }
    }

    public Collection<WebListener> getWebListeners() {
        return this.listeners;
    }

    public void addContext(Context context, String contextRoot) throws ConfigException, GlassFishException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "AS-WEB-GLUE-00162");
        }
        if (!(context instanceof ContextFacade)) {
            return;
        }
        if (!((String)contextRoot).startsWith("/")) {
            contextRoot = "/" + (String)contextRoot;
        }
        ExtendedDeploymentContext deploymentContext = null;
        try {
            WebModule wm;
            ArchiveHandler archiveHandler;
            if (this.factory == null) {
                this.factory = (ArchiveFactory)this.services.getService(ArchiveFactory.class, new Annotation[0]);
            }
            ContextFacade facade = (ContextFacade)context;
            File docRoot = facade.getDocRoot();
            ClassLoader classLoader = facade.getClassLoader();
            ReadableArchive archive = this.factory.openArchive(docRoot);
            if (this.report == null) {
                this.report = new PlainTextActionReporter();
            }
            ServerEnvironment env = (ServerEnvironment)this.services.getService(ServerEnvironment.class, new Annotation[0]);
            DeployCommandParameters params = new DeployCommandParameters();
            params.contextroot = contextRoot;
            params.enabled = Boolean.FALSE;
            params.origin = OpsParams.Origin.deploy;
            params.virtualservers = this.getName();
            params.target = "server";
            DeploymentContextImpl initialContext = new DeploymentContextImpl(this.report, archive, (OpsParams)params, env);
            if (this.deployment == null) {
                this.deployment = (Deployment)this.services.getService(Deployment.class, new Annotation[0]);
            }
            if ((archiveHandler = this.deployment.getArchiveHandler(archive)) == null) {
                throw new RuntimeException("Cannot find archive handler for source archive");
            }
            initialContext.setArchiveHandler(archiveHandler);
            params.name = archiveHandler.getDefaultApplicationName(archive, (DeploymentContext)initialContext);
            Applications apps = this.domain.getApplications();
            ApplicationInfo appInfo = this.deployment.get(params.name);
            ApplicationRef appRef = this.domain.getApplicationRefInServer(params.target, params.name);
            if (appInfo != null && appRef != null) {
                if (appRef.getVirtualServers().contains(this.getName())) {
                    throw new ConfigException("Context with name " + params.name + " is already registered on virtual server " + this.getName());
                }
                Object virtualServers = appRef.getVirtualServers();
                params.virtualservers = virtualServers = (String)virtualServers + "," + this.getName();
                params.force = Boolean.TRUE;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Virtual server " + this.getName() + " added to context " + params.name);
                }
                return;
            }
            deploymentContext = this.deployment.getBuilder(this._logger, (OpsParams)params, this.report).source(archive).archiveHandler(archiveHandler).build((ExtendedDeploymentContext)initialContext);
            Properties properties = new Properties();
            deploymentContext.getAppProps().putAll((Map<?, ?>)properties);
            if (classLoader != null) {
                ClassLoader parentCL = this.classLoaderHierarchy.createApplicationParentCL(classLoader, (DeploymentContext)deploymentContext);
                ClassLoader cl = archiveHandler.getClassLoader(parentCL, (DeploymentContext)deploymentContext);
                deploymentContext.setClassLoader(cl);
            }
            ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo((com.sun.enterprise.config.serverbeans.Application)apps.getModule(com.sun.enterprise.config.serverbeans.Application.class, params.name));
            Properties appProps = deploymentContext.getAppProps();
            String appLocation = DeploymentUtils.relativizeWithinDomainIfPossible((URI)deploymentContext.getSource().getURI());
            appProps.setProperty("location", appLocation);
            appProps.setProperty("object-type", "user");
            appProps.setProperty("context-root", (String)contextRoot);
            savedAppConfig.store(appProps);
            Transaction t = this.deployment.prepareAppConfigChanges((DeploymentContext)deploymentContext);
            appInfo = this.deployment.deploy(deploymentContext);
            if (appInfo != null) {
                facade.setAppName(appInfo.getName());
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "AS-WEB-GLUE-00162", new Object[]{this.getName(), appInfo.getName()});
                }
                this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)deploymentContext, t);
            } else if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                throw new ConfigException(this.report.getMessage());
            }
            File file = null;
            boolean delete = true;
            com.sun.enterprise.config.serverbeans.Application appBean = apps.getApplication(params.name);
            if (appBean != null) {
                file = new File(deploymentContext.getSource().getURI().getPath(), "/WEB-INF/web.xml");
                if (file.exists()) {
                    delete = false;
                }
                this.updateWebXml(facade, file);
            } else {
                this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00163");
            }
            ReadableArchive source = appInfo.getSource();
            UndeployCommandParameters undeployParams = new UndeployCommandParameters(params.name);
            undeployParams.origin = OpsParams.Origin.undeploy;
            undeployParams.target = "server";
            ExtendedDeploymentContext undeploymentContext = this.deployment.getBuilder(this._logger, (OpsParams)undeployParams, this.report).source(source).build();
            this.deployment.undeploy(params.name, undeploymentContext);
            params.origin = OpsParams.Origin.load;
            params.enabled = Boolean.TRUE;
            archive = this.factory.openArchive(docRoot);
            deploymentContext = this.deployment.getBuilder(this._logger, (OpsParams)params, this.report).source(archive).build();
            if (classLoader != null) {
                ClassLoader parentCL = this.classLoaderHierarchy.createApplicationParentCL(classLoader, (DeploymentContext)deploymentContext);
                archiveHandler = this.deployment.getArchiveHandler(archive);
                ClassLoader cl = archiveHandler.getClassLoader(parentCL, (DeploymentContext)deploymentContext);
                deploymentContext.setClassLoader(cl);
            }
            this.deployment.deploy(deploymentContext);
            this.deployment.updateAppEnabledAttributeInDomainXML(params.name, params.target, true);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "AS-WEB-GLUE-00159", new Object[]{this.getName(), params.name()});
            }
            if (delete && file != null && file.exists() && !file.delete()) {
                String path = file.toString();
                this._logger.log(Level.WARNING, "AS-WEB-GLUE-00160", path);
            }
            if (((String)contextRoot).equals("/")) {
                contextRoot = "";
            }
            if ((wm = (WebModule)this.findChild((String)contextRoot)) != null) {
                facade.setUnwrappedContext(wm);
                wm.setEmbedded(true);
                if (this.config != null) {
                    wm.setDefaultWebXml(this.config.getDefaultWebXml());
                }
            } else {
                throw new ConfigException("Deployed app not found " + (String)contextRoot);
            }
            if (deploymentContext != null) {
                deploymentContext.postDeployClean(true);
            }
        }
        catch (Exception ex) {
            if (this.deployment != null && deploymentContext != null) {
                deploymentContext.clean();
            }
            throw new GlassFishException((Throwable)ex);
        }
    }

    public void removeContext(Context context) throws GlassFishException {
        String name;
        ActionReport report = (ActionReport)this.services.getService(ActionReport.class, "plain", new Annotation[0]);
        Deployment deployment = (Deployment)this.services.getService(Deployment.class, new Annotation[0]);
        ApplicationInfo appInfo = deployment.get(name = context instanceof ContextFacade ? ((ContextFacade)context).getAppName() : context.getPath());
        if (appInfo == null) {
            report.setMessage("Cannot find deployed application of name " + name);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new GlassFishException("Cannot find deployed application of name " + name);
        }
        ReadableArchive source = appInfo.getSource();
        if (source == null) {
            report.setMessage("Cannot get source archive for undeployment");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new GlassFishException("Cannot get source archive for undeployment");
        }
        UndeployCommandParameters params = new UndeployCommandParameters(name);
        params.origin = OpsParams.Origin.undeploy;
        params.target = "server";
        ExtendedDeploymentContext deploymentContext = null;
        try {
            deploymentContext = deployment.getBuilder(this._logger, (OpsParams)params, report).source(source).build();
            deployment.undeploy(name, deploymentContext);
            deployment.unregisterAppFromDomainXML(name, "server");
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00164", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new GlassFishException("Cannot create context for undeployment ", (Throwable)e);
        }
        catch (TransactionFailure e) {
            throw new GlassFishException((Throwable)e);
        }
        finally {
            if (deploymentContext != null) {
                deploymentContext.clean();
            }
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "AS-WEB-GLUE-00165", name);
        }
    }

    public Context getContext(String contextRoot) {
        if (!((String)contextRoot).startsWith("/")) {
            contextRoot = "/" + (String)contextRoot;
        }
        return (Context)this.findChild((String)contextRoot);
    }

    public Collection<Context> getContexts() {
        ArrayList<Context> ctxs = new ArrayList<Context>();
        for (Container container : this.findChildren()) {
            if (!(container instanceof Context)) continue;
            ctxs.add((Context)container);
        }
        return ctxs;
    }

    public void setConfig(VirtualServerConfig config) throws ConfigException {
        this.config = config;
        this.configureSingleSignOn(config.isSsoEnabled(), (WebContainerFeatureFactory)Globals.getDefaultHabitat().getService(PEWebContainerFeatureFactoryImpl.class, new Annotation[0]), false);
        if (config.isAccessLoggingEnabled()) {
            this.enableAccessLogging();
        } else {
            this.disableAccessLogging();
        }
        this.setDefaultWebXmlLocation(config.getDefaultWebXml());
        this.setDefaultContextXmlLocation(config.getContextXmlDefault());
        this.setAllowLinking(config.isAllowLinking());
        this.configureRemoteAddressFilterValve(config.getAllowRemoteAddress(), config.getDenyRemoteAddress());
        this.configureRemoteHostFilterValve(config.getAllowRemoteHost(), config.getAllowRemoteHost());
        this.configureAliases(config.getHostNames());
    }

    public VirtualServerConfig getConfig() {
        return this.config;
    }

    public synchronized void stop() throws LifecycleException {
        if (this.fileLoggerHandler != null) {
            this._logger.removeHandler(this.fileLoggerHandler);
            this.close(this.fileLoggerHandler);
            this.fileLoggerHandler = null;
        }
        this.setLogger(this._logger, "INFO");
        super.stop();
    }

    public void updateWebXml(ContextFacade facade, File file) throws Exception {
        Map<String, String> servlets = facade.getAddedServlets();
        Map<String, String[]> mappings = facade.getServletMappings();
        List<String> listeners = facade.getListeners();
        Map<String, String> filters = facade.getAddedFilters();
        Map<String, String> servletNameFilterMappings = facade.getServletNameFilterMappings();
        Map<String, String> urlPatternFilterMappings = facade.getUrlPatternFilterMappings();
        if (!(filters.isEmpty() && listeners.isEmpty() && servlets.isEmpty())) {
            Node servletNode;
            NodeList servletList;
            Element servletName;
            Element filterMapping;
            Element paramValue;
            Element paramName;
            Element initParam;
            NodeList children;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "AS-WEB-GLUE-00166", file.getAbsolutePath());
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(true);
            dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = null;
            Element webapp = null;
            if (file != null && file.exists()) {
                doc = dBuilder.parse(file);
                webapp = doc.getDocumentElement();
            } else {
                doc = dBuilder.newDocument();
                webapp = doc.createElement("web-app");
                webapp.setAttribute("xmln", "http://java.sun.com/xml/ns/j2ee");
                webapp.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                webapp.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd");
                webapp.setAttribute("version", "2.4");
                doc.appendChild(webapp);
            }
            boolean entryFound = false;
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                NodeList filterList = doc.getElementsByTagName("filter-name");
                block1: for (int i = 0; i < filterList.getLength(); ++i) {
                    Node filterNode = filterList.item(i);
                    if (!entry.getKey().equals(filterNode.getTextContent()) || !filterNode.getParentNode().getNodeName().equals("filter")) continue;
                    children = filterNode.getParentNode().getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node filterClass = children.item(j);
                        if (!filterClass.getNodeName().equals("filter-class")) continue;
                        filterClass.setTextContent(entry.getValue().toString());
                        entryFound = true;
                        continue block1;
                    }
                }
                if (entryFound) continue;
                Element filter = doc.createElement("filter");
                Element filterName = doc.createElement("filter-name");
                filterName.setTextContent(entry.getKey().toString());
                filter.appendChild(filterName);
                Element filterClass = doc.createElement("filter-class");
                filterClass.setTextContent(entry.getValue().toString());
                filter.appendChild(filterClass);
                Map<String, String> initParams = facade.getFilterRegistration(entry.getKey().toString()).getInitParameters();
                if (initParams != null && !initParams.isEmpty()) {
                    initParam = doc.createElement("init-param");
                    for (Map.Entry<String, String> param : initParams.entrySet()) {
                        paramName = doc.createElement("param-name");
                        paramName.setTextContent(param.getKey().toString());
                        initParam.appendChild(paramName);
                        paramValue = doc.createElement("param-value");
                        paramValue.setTextContent(param.getValue().toString());
                        initParam.appendChild(paramValue);
                    }
                    filter.appendChild(initParam);
                }
                webapp.appendChild(filter);
            }
            for (Map.Entry<String, String> entry : servletNameFilterMappings.entrySet()) {
                filterMapping = doc.createElement("filter-mapping");
                Element filterName = doc.createElement("filter-name");
                filterName.setTextContent(entry.getKey().toString());
                filterMapping.appendChild(filterName);
                servletName = doc.createElement("servlet-name");
                servletName.setTextContent(entry.getValue().toString());
                filterMapping.appendChild(servletName);
                webapp.appendChild(filterMapping);
            }
            for (Map.Entry<String, String> entry : urlPatternFilterMappings.entrySet()) {
                filterMapping = doc.createElement("filter-mapping");
                Element filterName = doc.createElement("filter-name");
                filterName.setTextContent(entry.getKey().toString());
                filterMapping.appendChild(filterName);
                Element urlPattern = doc.createElement("url-pattern");
                urlPattern.setTextContent(entry.getValue().toString());
                filterMapping.appendChild(urlPattern);
                webapp.appendChild(filterMapping);
            }
            entryFound = false;
            for (Map.Entry<String, String> entry : servlets.entrySet()) {
                servletList = doc.getElementsByTagName("servlet-name");
                block7: for (int i = 0; i < servletList.getLength(); ++i) {
                    servletNode = servletList.item(i);
                    if (!entry.getKey().equals(servletNode.getTextContent()) || !servletNode.getParentNode().getNodeName().equals("servlet")) continue;
                    children = servletNode.getParentNode().getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node servletClass = children.item(j);
                        if (!servletClass.getNodeName().equals("servlet-class")) continue;
                        servletClass.setTextContent(entry.getValue().toString());
                        entryFound = true;
                        continue block7;
                    }
                }
                if (entryFound) continue;
                Element servlet = doc.createElement("servlet");
                servletName = doc.createElement("servlet-name");
                servletName.setTextContent(entry.getKey().toString());
                servlet.appendChild(servletName);
                Element servletClass = doc.createElement("servlet-class");
                servletClass.setTextContent(entry.getValue().toString());
                servlet.appendChild(servletClass);
                Map<String, String> initParams = facade.getServletRegistration(entry.getKey().toString()).getInitParameters();
                if (initParams != null && !initParams.isEmpty()) {
                    initParam = doc.createElement("init-param");
                    for (Map.Entry<String, String> param : initParams.entrySet()) {
                        paramName = doc.createElement("param-name");
                        paramName.setTextContent(param.getKey().toString());
                        initParam.appendChild(paramName);
                        paramValue = doc.createElement("param-value");
                        paramValue.setTextContent(param.getValue().toString());
                        initParam.appendChild(paramValue);
                    }
                    servlet.appendChild(initParam);
                }
                webapp.appendChild(servlet);
            }
            entryFound = false;
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                servletList = doc.getElementsByTagName("servlet-name");
                block11: for (int i = 0; i < servletList.getLength(); ++i) {
                    servletNode = servletList.item(i);
                    if (!entry.getKey().equals(servletNode.getTextContent()) || !servletNode.getParentNode().getNodeName().equals("servlet-mapping")) continue;
                    NodeList children2 = servletNode.getParentNode().getChildNodes();
                    for (int j = 0; j < children2.getLength(); ++j) {
                        Node urlPattern = children2.item(j);
                        if (!urlPattern.getNodeName().equals("url-pattern")) continue;
                        entryFound = true;
                        continue block11;
                    }
                }
                if (entryFound) continue;
                Element servletMapping = doc.createElement("servlet-mapping");
                for (String pattern : mappings.get(entry.getKey())) {
                    Element servletName2 = doc.createElement("servlet-name");
                    servletName2.setTextContent(entry.getKey().toString());
                    servletMapping.appendChild(servletName2);
                    Element urlPattern = doc.createElement("url-pattern");
                    urlPattern.setTextContent(pattern);
                    servletMapping.appendChild(urlPattern);
                }
                webapp.appendChild(servletMapping);
            }
            for (String string : listeners) {
                Element listener = doc.createElement("listener");
                Element listenerClass = doc.createElement("listener-class");
                listenerClass.setTextContent(string);
                listener.appendChild(listenerClass);
                webapp.appendChild(listener);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            if (file != null) {
                DOMSource dOMSource = new DOMSource(doc);
                StreamResult result = new StreamResult(file);
                transformer.transform(dOMSource, result);
            }
        }
    }

    private List<NetworkListener> getGrizzlyNetworkListeners() {
        List listenerList = StringUtils.parseStringList((String)this.vsBean.getNetworkListeners(), (String)",");
        String[] listeners = listenerList != null ? listenerList.toArray(new String[listenerList.size()]) : new String[]{};
        ArrayList<NetworkListener> networkListeners = new ArrayList<NetworkListener>();
        for (String listener : listeners) {
            for (NetworkListener networkListener : this.serverConfig.getNetworkConfig().getNetworkListeners().getNetworkListener()) {
                if (!networkListener.getName().equals(listener)) continue;
                networkListeners.add(networkListener);
            }
        }
        return networkListeners;
    }

    private List<HttpProbeImpl> getHttpProbeImpl() {
        ArrayList<HttpProbeImpl> httpProbes = new ArrayList<HttpProbeImpl>();
        for (NetworkListener listener : this.getGrizzlyNetworkListeners()) {
            GenericGrizzlyListener grizzlyListener;
            List codecFilters;
            GrizzlyProxy proxy = (GrizzlyProxy)this.grizzlyService.lookupNetworkProxy(listener);
            if (proxy == null || (codecFilters = (grizzlyListener = (GenericGrizzlyListener)proxy.getUnderlyingListener()).getFilters(HttpCodecFilter.class)) == null || codecFilters.isEmpty()) continue;
            for (HttpCodecFilter codecFilter : codecFilters) {
                HttpProbe[] probes = (HttpProbe[])codecFilter.getMonitoringConfig().getProbes();
                if (probes == null) continue;
                for (HttpProbe probe : probes) {
                    if (!(probe instanceof HttpProbeImpl)) continue;
                    httpProbes.add((HttpProbeImpl)probe);
                }
            }
        }
        return httpProbes;
    }

    private final class HttpProbeImpl
    extends HttpProbe.Adapter {
        boolean accessLoggingEnabled;
        NetworkListener listener;

        public HttpProbeImpl(NetworkListener listener, boolean accessLoggingEnabled) {
            this.listener = listener;
            this.accessLoggingEnabled = accessLoggingEnabled;
        }

        public void enableAccessLogging() {
            this.accessLoggingEnabled = true;
        }

        public void disableAccessLogging() {
            this.accessLoggingEnabled = false;
        }

        public void onErrorEvent(Connection connection, HttpPacket packet, Throwable error) {
            if (this.accessLoggingEnabled) {
                if (packet instanceof HttpRequestPacket) {
                    HttpRequestPacket requestPacket = (HttpRequestPacket)packet;
                    HttpResponsePacket responsePacket = requestPacket.getResponse();
                    responsePacket.setStatus(HttpStatus.BAD_REQUEST_400);
                    org.glassfish.grizzly.http.server.Request grizzlyRequest = org.glassfish.grizzly.http.server.Request.create();
                    org.glassfish.grizzly.http.server.Response grizzlyResponse = grizzlyRequest.getResponse();
                    grizzlyRequest.initialize(requestPacket, FilterChainContext.create((Connection)connection), null);
                    grizzlyResponse.initialize(grizzlyRequest, responsePacket, FilterChainContext.create((Connection)connection), null, null);
                    Response catalinaResponse = new Response();
                    catalinaResponse.setCoyoteResponse(grizzlyResponse);
                    WebConnector connector = VirtualServer.this.webContainer.getConnectorMap().get(this.listener.getName());
                    if (connector != null) {
                        org.apache.catalina.connector.Request catalinaRequest = new org.apache.catalina.connector.Request();
                        catalinaRequest.setGrizzlyRequest(grizzlyRequest);
                        catalinaRequest.setConnector((Connector)connector);
                        try {
                            VirtualServer.this.accessLogValve.postInvoke((Request)catalinaRequest, (org.apache.catalina.Response)catalinaResponse);
                        }
                        catch (IOException ex) {
                            VirtualServer.this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00161", ex);
                        }
                    } else {
                        VirtualServer.this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00161");
                    }
                } else {
                    VirtualServer.this._logger.log(Level.SEVERE, "AS-WEB-GLUE-00161");
                }
            }
        }
    }
}

