/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.Pool;
import com.sun.ejb.containers.util.pool.PoolException;
import com.sun.ejb.monitoring.probes.EjbPoolProbeProvider;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import com.sun.enterprise.util.Utility;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPool
implements Pool {
    protected static final Logger _logger = EjbContainerUtilImpl.getLogger();
    protected List<Object> pooledObjects;
    protected ObjectFactory pooledObjectFactory;
    protected int waitCount;
    protected int createdCount;
    protected int steadyPoolSize;
    protected int resizeQuantity = 1;
    protected int maxPoolSize = Integer.MAX_VALUE;
    protected long maxWaitTimeInMillis;
    protected int idleTimeoutInSeconds;
    private AbstractPoolTimerTask poolTimerTask;
    protected ClassLoader containerClassLoader;
    protected int destroyedCount;
    protected int poolSuccess;
    protected String poolName;
    protected int poolReturned;
    protected String configData;
    protected EjbPoolProbeProvider poolProbeNotifier;
    protected String appName;
    protected String modName;
    protected String ejbName;
    protected long beanId;

    protected AbstractPool() {
    }

    protected AbstractPool(ObjectFactory factory, long beanId, int steadyPoolSize, int resizeQuantity, int maxPoolsize, long maxWaitTimeInMillis, int idleTimeoutInSeconds, ClassLoader loader) {
        this.initializePool(factory, beanId, steadyPoolSize, resizeQuantity, maxPoolsize, maxWaitTimeInMillis, idleTimeoutInSeconds, loader);
    }

    protected void initializePool(ObjectFactory factory, long beanId, int steadyPoolSize, int resizeQuantity, int maxPoolsize, long maxWaitTimeInMillis, int idleTimeoutInSeconds, ClassLoader loader) {
        this.pooledObjects = new ArrayList<Object>();
        this.pooledObjectFactory = factory;
        this.steadyPoolSize = steadyPoolSize;
        this.resizeQuantity = resizeQuantity;
        this.maxPoolSize = maxPoolsize;
        this.maxWaitTimeInMillis = maxWaitTimeInMillis;
        this.idleTimeoutInSeconds = idleTimeoutInSeconds;
        this.beanId = beanId;
        if (steadyPoolSize > 0) {
            for (int i = 0; i < steadyPoolSize; ++i) {
                this.pooledObjects.add(factory.create(null));
                this.poolProbeNotifier.ejbObjectAddedEvent(beanId, this.appName, this.modName, this.ejbName);
                ++this.createdCount;
            }
        }
        this.containerClassLoader = loader;
        if (this.idleTimeoutInSeconds > 0) {
            try {
                this.poolTimerTask = new AbstractPoolTimerTask();
                EjbContainerUtilImpl.getInstance().getTimer().scheduleAtFixedRate((TimerTask)this.poolTimerTask, (long)idleTimeoutInSeconds * 1000L, (long)idleTimeoutInSeconds * 1000L);
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "[AbstractPool]: Could not add AbstractPoolTimerTask ... Continuing anyway...");
            }
        }
    }

    public void setContainerClassLoader(ClassLoader loader) {
        this.containerClassLoader = loader;
    }

    public void setInfo(String appName, String modName, String ejbName) {
        this.appName = appName;
        this.modName = modName;
        this.ejbName = ejbName;
        try {
            this.poolProbeNotifier = (EjbPoolProbeProvider)EjbContainerUtilImpl.getInstance().getProbeProviderFactory().getProbeProvider(EjbPoolProbeProvider.class, EjbMonitoringUtils.getInvokerId(appName, modName, ejbName));
            _logger.log(Level.FINE, () -> "Got poolProbeNotifier: " + this.poolProbeNotifier.getClass().getName());
        }
        catch (Exception ex) {
            this.poolProbeNotifier = new EjbPoolProbeProvider();
            _logger.log(Level.FINE, "Error getting the EjbPoolProbeProvider");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(Object param) throws PoolException {
        long t1 = 0L;
        long totalWaitTime = 0L;
        List<Object> list = this.pooledObjects;
        synchronized (list) {
            block13: {
                block14: {
                    do {
                        int size;
                        if ((size = this.pooledObjects.size()) > 0) {
                            ++this.poolSuccess;
                            return this.pooledObjects.remove(size - 1);
                        }
                        if (this.createdCount - this.destroyedCount < this.maxPoolSize) {
                            this.poolProbeNotifier.ejbObjectAddedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                            ++this.createdCount;
                            break block13;
                        }
                        if (this.maxWaitTimeInMillis < 0L) break block14;
                        ++this.waitCount;
                        t1 = System.currentTimeMillis();
                        try {
                            _logger.log(Level.FINE, "[AbstractPool]: Waiting on the pool to get a bean instance...");
                            this.pooledObjects.wait(this.maxWaitTimeInMillis);
                        }
                        catch (InterruptedException inEx) {
                            throw new PoolException("Thread interrupted.", inEx);
                        }
                        --this.waitCount;
                        totalWaitTime += System.currentTimeMillis() - t1;
                        size = this.pooledObjects.size();
                        if (size <= 0) continue;
                        ++this.poolSuccess;
                        return this.pooledObjects.remove(size - 1);
                    } while (this.maxWaitTimeInMillis == 0L || totalWaitTime < this.maxWaitTimeInMillis);
                    throw new PoolException("Pool Instance not obtained within given time interval.");
                }
                throw new PoolException("Pool Instance not obtained within given time interval.");
            }
        }
        try {
            return this.pooledObjectFactory.create(param);
        }
        catch (Exception poolEx) {
            List<Object> list2 = this.pooledObjects;
            synchronized (list2) {
                this.poolProbeNotifier.ejbObjectAddFailedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                --this.createdCount;
            }
            throw new RuntimeException("Caught Exception when trying to create pool Object ", poolEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(Object object) {
        List<Object> list = this.pooledObjects;
        synchronized (list) {
            this.pooledObjects.add(object);
            ++this.poolReturned;
            if (this.waitCount > 0) {
                this.pooledObjects.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyObject(Object object) {
        List<Object> list = this.pooledObjects;
        synchronized (list) {
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
            if (this.waitCount > 0) {
                this.pooledObjects.notify();
            }
        }
        try {
            this.pooledObjectFactory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception in destroyObject()", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload(int count) {
        List<Object> list = this.pooledObjects;
        synchronized (list) {
            for (int i = 0; i < count; ++i) {
                try {
                    this.pooledObjects.add(this.pooledObjectFactory.create(null));
                    this.poolProbeNotifier.ejbObjectAddedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    ++this.createdCount;
                    continue;
                }
                catch (PoolException poolEx) {
                    _logger.log(Level.FINE, "Exception in preload()", poolEx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<Object> list = this.pooledObjects;
        synchronized (list) {
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    _logger.log(Level.WARNING, "[AbstractPool]: Cancelled pool timer task  at: " + new Date());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            _logger.log(Level.FINE, "[AbstractPool]: Destroying " + this.pooledObjects.size() + " beans from the pool...");
            ClassLoader originalClassLoader = Utility.setContextClassLoader((ClassLoader)this.containerClassLoader);
            for (Object pooledObject : this.pooledObjects) {
                try {
                    this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    ++this.destroyedCount;
                    try {
                        this.pooledObjectFactory.destroy(pooledObject);
                    }
                    catch (Throwable th) {
                        _logger.log(Level.FINE, "Exception in destroy()", th);
                    }
                }
                catch (Throwable th) {
                    _logger.log(Level.WARNING, "[AbstractPool]: Error while destroying: " + th);
                }
            }
            _logger.log(Level.FINE, "[AbstractPool]: Pool closed....");
            this.unregisterProbeProvider();
            Utility.setContextClassLoader((ClassLoader)originalClassLoader);
        }
        this.pooledObjects = null;
        this.pooledObjectFactory = null;
        this.poolTimerTask = null;
        this.containerClassLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int count) {
        ArrayList<Object> removeList = new ArrayList<Object>();
        List<Object> list = this.pooledObjects;
        synchronized (list) {
            int size = this.pooledObjects.size();
            for (int i = 0; i < count && size > 0; ++i) {
                removeList.add(this.pooledObjects.remove(--size));
                this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                ++this.destroyedCount;
            }
            this.pooledObjects.notifyAll();
        }
        for (int i = removeList.size() - 1; i >= 0; --i) {
            this.pooledObjectFactory.destroy(removeList.remove(i));
            try {
                this.pooledObjectFactory.destroy(removeList.remove(i));
                continue;
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "Exception in destroy()", th);
            }
        }
    }

    protected abstract void removeIdleObjects();

    public int getCreatedCount() {
        return this.createdCount;
    }

    public int getDestroyedCount() {
        return this.destroyedCount;
    }

    public int getPoolSuccess() {
        return this.poolSuccess;
    }

    public int getSize() {
        return this.pooledObjects.size();
    }

    public int getWaitCount() {
        return this.waitCount;
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    public int getResizeQuantity() {
        return this.resizeQuantity;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public void setConfigData(String configData) {
        this.configData = configData;
    }

    public void appendStats(StringBuffer sbuf) {
        sbuf.append("[Pool: ").append("SZ=").append(this.pooledObjects.size()).append("; ").append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("WC=").append(this.waitCount).append("; ").append("MSG=0");
        if (this.configData != null) {
            sbuf.append(this.configData);
        }
        sbuf.append("]");
    }

    public int getJmsMaxMessagesLoad() {
        return 0;
    }

    public int getNumBeansInPool() {
        return this.pooledObjects.size();
    }

    public int getNumThreadsWaiting() {
        return this.waitCount;
    }

    public int getTotalBeansCreated() {
        return this.createdCount;
    }

    public int getTotalBeansDestroyed() {
        return this.destroyedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllMonitoredAttrbuteValues() {
        StringBuffer sbuf = new StringBuffer();
        List<Object> list = this.pooledObjects;
        synchronized (list) {
            sbuf.append("createdCount=").append(this.createdCount).append(";").append("destroyedCount=").append(this.destroyedCount).append(";").append("waitCount=").append(this.waitCount).append(";").append("size=").append(this.pooledObjects.size()).append(";");
        }
        sbuf.append("maxPoolSize=").append(this.maxPoolSize).append(";");
        return sbuf.toString();
    }

    public String getAllAttrValues() {
        StringBuffer sbuf = new StringBuffer();
        if (null != this.poolName) {
            sbuf.append(":").append(this.poolName);
        } else {
            sbuf.append(":POOL");
        }
        sbuf.append("[FP=").append(this.poolSuccess).append(",").append("TC=").append(this.createdCount).append(",").append("TD=").append(this.destroyedCount).append(",").append("PR=").append(this.poolReturned).append(",").append("TW=").append(this.waitCount).append(",").append("CS=").append(this.pooledObjects.size()).append(",").append("MS=").append(this.maxPoolSize);
        return sbuf.toString();
    }

    protected void unregisterProbeProvider() {
        try {
            EjbContainerUtilImpl.getInstance().getProbeProviderFactory().unregisterProbeProvider((Object)this.poolProbeNotifier);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Error getting the EjbPoolProbeProvider");
        }
    }

    private class AbstractPoolTimerTask
    extends TimerTask {
        AbstractPoolTimerTask() {
        }

        @Override
        public void run() {
            final Thread currentThread = Thread.currentThread();
            final ClassLoader previousClassLoader = currentThread.getContextClassLoader();
            try {
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(AbstractPool.this.containerClassLoader);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            currentThread.setContextClassLoader(AbstractPool.this.containerClassLoader);
                            return null;
                        }
                    });
                }
                try {
                    if (AbstractPool.this.pooledObjects.size() > AbstractPool.this.steadyPoolSize) {
                        _logger.log(Level.FINE, "[AbstractPool]: Removing idle  objects from pool. Current Size: " + AbstractPool.this.pooledObjects.size() + "/" + AbstractPool.this.steadyPoolSize + ". Time: " + new Date());
                        AbstractPool.this.removeIdleObjects();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            currentThread.setContextClassLoader(previousClassLoader);
                            return null;
                        }
                    });
                }
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "Exception in run()", th);
            }
        }
    }
}

