/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.adapter.LocatorBridge;
import org.glassfish.admin.rest.generator.TextResourcesGenerator;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Path(value="/generator/")
public class GeneratorResource {
    @Inject
    private ServiceLocator serviceLocator;

    @GET
    @Produces(value={"text/plain"})
    public String get(@QueryParam(value="outputDir") String outputDir) {
        if (outputDir == null) {
            return "Please provide the outputDir query parameter.";
        }
        try {
            LocatorBridge locatorBridge = this.serviceLocator.getService(LocatorBridge.class, new Annotation[0]);
            Dom dom = Dom.unwrap((ConfigBeanProxy)((ConfigBeanProxy)locatorBridge.getRemoteLocator().getService(Domain.class, new Annotation[0])));
            DomDocument document = dom.document;
            ConfigModel rootModel = dom.document.getRoot().model;
            TextResourcesGenerator resourcesGenerator = new TextResourcesGenerator(outputDir, this.serviceLocator);
            resourcesGenerator.generateSingle(rootModel, document);
            resourcesGenerator.endGeneration();
            return "Code Generation done at: " + outputDir;
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
            return "Exception encountered during generation process: " + ex + "\nPlease look at server.log for more information.";
        }
    }
}

