/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import com.sun.jdo.api.persistence.enhancer.classfile.VMOp;
import java.io.PrintStream;

public class InsnTargetOp
extends Insn {
    InsnTarget targetOp;

    @Override
    public int nStackArgs() {
        return VMOp.ops[this.opcode()].nStackArgs();
    }

    @Override
    public int nStackResults() {
        return VMOp.ops[this.opcode()].nStackResults();
    }

    @Override
    public String argTypes() {
        return VMOp.ops[this.opcode()].argTypes();
    }

    @Override
    public String resultTypes() {
        return VMOp.ops[this.opcode()].resultTypes();
    }

    @Override
    public boolean branches() {
        return true;
    }

    @Override
    public void markTargets() {
        this.targetOp.setBranchTarget();
    }

    public InsnTarget target() {
        return this.targetOp;
    }

    @Override
    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println(this.offset() + "  " + InsnTargetOp.opName(this.opcode()) + "  " + this.targetOp.offset());
    }

    @Override
    int store(byte[] buf, int index) {
        buf[index++] = (byte)this.opcode();
        int off = this.targetOp.offset() - this.offset();
        if (this.opcode() == 200 || this.opcode() == 201) {
            return InsnTargetOp.storeInt(buf, index, off);
        }
        return InsnTargetOp.storeShort(buf, index, (short)off);
    }

    @Override
    int size() {
        if (this.opcode() == 200 || this.opcode() == 201) {
            return 5;
        }
        return 3;
    }

    InsnTargetOp(int theOpcode, InsnTarget theOperand, int pc) {
        super(theOpcode, pc);
        this.targetOp = theOperand;
    }

    InsnTargetOp(int theOpcode, InsnTarget theOperand) {
        super(theOpcode, -1);
        this.targetOp = theOperand;
        switch (theOpcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                if (theOperand != null) break;
                throw new InsnError("attempt to create an " + InsnTargetOp.opName(theOpcode) + " with a null Target operand");
            }
            default: {
                throw new InsnError("attempt to create an " + InsnTargetOp.opName(theOpcode) + " with an InsnTarget operand");
            }
        }
    }
}

