/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="delete-lifecycle-module")
@I18n(value="delete.lifecycle.module")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.DELETE, path="delete-lifecycle-module", description="Delete Lifecycle Module", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.DELETE, path="delete-lifecycle-module", description="Delete Lifecycle Module", params={@RestParam(name="target", value="$parent")})})
public class DeleteLifecycleModuleCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    public String target = "server";
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    ServiceLocator habitat;
    private List<String> targets = null;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteLifecycleModuleCommand.class);

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        if (this.env.isDas() && DeploymentUtils.isDomainTarget((String)this.target)) {
            this.targets = this.domain.getAllReferencedTargetsForApplication(this.name);
            for (String t : this.targets) {
                String resourceName = DeploymentCommandUtils.getTargetResourceNameForExistingAppRef(this.domain, t, this.name);
                if (resourceName == null) continue;
                accessChecks.add(new AccessRequired.AccessCheck(resourceName, "delete"));
            }
        } else {
            String resourceName = DeploymentCommandUtils.getTargetResourceNameForExistingAppRef(this.domain, this.target, this.name);
            if (resourceName != null) {
                accessChecks.add(new AccessRequired.AccessCheck(resourceName, "delete"));
            }
        }
        return accessChecks;
    }

    public void execute(AdminCommandContext context) {
        ApplicationRef ref;
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        if (!this.deployment.isRegistered(this.name)) {
            report.setMessage(localStrings.getLocalString("lifecycle.notreg", "Lifecycle module {0} not registered", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!DeploymentUtils.isDomainTarget((String)this.target) && (ref = this.domain.getApplicationRefInTarget(this.name, this.target)) == null) {
            report.setMessage(localStrings.getLocalString("lifecycle.not.referenced.target", "Lifecycle module {0} is not referenced by target {1}", new Object[]{this.name, this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.deployment.validateUndeploymentTarget(this.target, this.name);
        if (this.env.isDas() && DeploymentUtils.isDomainTarget((String)this.target)) {
            try {
                ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{this});
                ParameterMap paramMap = extractor.extract((Collection)Collections.EMPTY_LIST);
                paramMap.set((Object)"DEFAULT", (Object)this.name);
                ClusterOperationUtil.replicateCommand((String)"delete-lifecycle-module", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Ignore, (FailurePolicy)FailurePolicy.Warn, this.targets, (AdminCommandContext)context, (ParameterMap)paramMap, (ServiceLocator)this.habitat);
            }
            catch (Exception e) {
                report.failure(logger, e.getMessage());
                return;
            }
        }
        try {
            this.deployment.unregisterAppFromDomainXML(this.name, this.target);
        }
        catch (Exception e) {
            report.setMessage("Failed to delete lifecycle module: " + e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

