/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.plugin.spi;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class ProducerSpi {
    protected static boolean DEBUG = false;
    protected transient Logger logger = Globals.getLogger();
    protected static final CacheHashMap cache = new CacheHashMap(20);
    private boolean valid = true;
    protected static final Map<ProducerUID, ProducerSpi> allProducers = Collections.synchronizedMap(new HashMap());
    protected static final Set wildcardProducers = Collections.synchronizedSet(new HashSet());
    protected transient Map lastResumeFlowSizes = Collections.synchronizedMap(new HashMap());
    private ConnectionUID connection_uid;
    protected DestinationUID destination_uid;
    protected ProducerUID uid = new ProducerUID();
    private int pauseCnt = 0;
    private int resumeCnt = 0;
    private int msgCnt = 0;
    protected transient String creator = null;

    public String toString() {
        return "Producer[" + this.uid + "," + this.destination_uid + "," + this.connection_uid + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllDebugState() {
        Object itr;
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TABLE", "AllProducers");
        Vector<String> v = new Vector<String>();
        CacheHashMap cacheHashMap = cache;
        synchronized (cacheHashMap) {
            itr = cache.keySet().iterator();
            while (itr.hasNext()) {
                v.add(String.valueOf(((ProducerUID)((Object)itr.next())).longValue()));
            }
        }
        ht.put("cache", v);
        HashMap<ProducerUID, ProducerSpi> tmp = null;
        itr = allProducers;
        synchronized (itr) {
            tmp = new HashMap<ProducerUID, ProducerSpi>(allProducers);
        }
        Hashtable<String, Hashtable> producers = new Hashtable<String, Hashtable>();
        Iterator<Map.Entry<ProducerUID, ProducerSpi>> itr2 = tmp.entrySet().iterator();
        Map.Entry<ProducerUID, ProducerSpi> pair = null;
        while (itr2.hasNext()) {
            pair = itr2.next();
            ProducerUID p = pair.getKey();
            ProducerSpi producer = pair.getValue();
            producers.put(String.valueOf(p.longValue()), producer.getDebugState());
        }
        ht.put("producersCnt", allProducers.size());
        ht.put("producers", producers);
        return ht;
    }

    public synchronized void pause() {
        ++this.pauseCnt;
    }

    public synchronized void addMsg() {
        ++this.msgCnt;
    }

    public synchronized int getMsgCnt() {
        return this.msgCnt;
    }

    public synchronized boolean isPaused() {
        return this.pauseCnt > this.resumeCnt;
    }

    public synchronized void resume() {
        ++this.resumeCnt;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TABLE", "Producer[" + this.uid.longValue() + "]");
        ht.put("uid", String.valueOf(this.uid.longValue()));
        ht.put("valid", String.valueOf(this.valid));
        ht.put("pauseCnt", String.valueOf(this.pauseCnt));
        ht.put("resumeCnt", String.valueOf(this.resumeCnt));
        if (this.connection_uid != null) {
            ht.put("connectionUID", String.valueOf(this.connection_uid.longValue()));
        }
        if (this.destination_uid != null) {
            ht.put("destination", this.destination_uid.toString());
        }
        return ht;
    }

    protected ProducerSpi(ConnectionUID cuid, DestinationUID duid, String id) {
        this.connection_uid = cuid;
        this.destination_uid = duid;
        this.creator = id;
        this.logger.log(4, "Creating new Producer " + this.uid + " on " + duid + " for connection " + cuid);
    }

    public ProducerUID getProducerUID() {
        return this.uid;
    }

    public ConnectionUID getConnectionUID() {
        return this.connection_uid;
    }

    public DestinationUID getDestinationUID() {
        return this.destination_uid;
    }

    public static void clearProducers() {
        cache.clear();
        allProducers.clear();
        wildcardProducers.clear();
    }

    public abstract boolean isWildcard();

    public static Iterator getWildcardProducers() {
        return new ArrayList(wildcardProducers).iterator();
    }

    public static int getNumWildcardProducers() {
        return wildcardProducers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkProducer(ProducerUID uid) {
        String str = null;
        CacheHashMap cacheHashMap = cache;
        synchronized (cacheHashMap) {
            str = (String)cache.get((Object)uid);
        }
        if (str == null) {
            return " pid " + uid + " not of of last 20 removed";
        }
        return "Producer[" + uid + "]:" + str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProducerInfo(ProducerUID uid, String str) {
        CacheHashMap cacheHashMap = cache;
        synchronized (cacheHashMap) {
            cache.put((Object)uid, (Object)(System.currentTimeMillis() + ":" + str));
        }
    }

    public static Iterator getAllProducers() {
        return new ArrayList<ProducerSpi>(allProducers.values()).iterator();
    }

    public static int getNumProducers() {
        return allProducers.size();
    }

    public static ProducerSpi getProducer(ProducerUID uid) {
        return allProducers.get((Object)uid);
    }

    public static ProducerSpi destroyProducer(ProducerUID uid, String info) {
        ProducerSpi p = allProducers.remove((Object)uid);
        ProducerSpi.updateProducerInfo(uid, info);
        if (p == null) {
            return p;
        }
        p.destroyProducer();
        return p;
    }

    protected abstract void destroyProducer();

    public synchronized void destroy() {
        this.valid = false;
    }

    public synchronized boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProducerSpi getProducer(String creator) {
        if (creator == null) {
            return null;
        }
        Map<ProducerUID, ProducerSpi> map = allProducers;
        synchronized (map) {
            for (ProducerSpi c : allProducers.values()) {
                if (!creator.equals(c.creator)) continue;
                return c;
            }
        }
        return null;
    }

    public abstract Set getDestinations();

    public void sendResumeFlow(DestinationUID duid, int maxbatch) {
        this.resume();
        this.sendResumeFlow(duid, 0, 0L, 0L, "Resuming " + this, true, maxbatch);
        this.logger.log(1, "Producer.sendResumeFlow(" + duid + ") resumed: " + this);
    }

    public void sendResumeFlow(DestinationUID duid, int size, long bytes, long mbytes, String reason, boolean uselast, int maxbatch) {
        ConnectionUID cuid;
        ResumeFlowSizes rfs = null;
        if (uselast) {
            rfs = (ResumeFlowSizes)this.lastResumeFlowSizes.get(duid);
            if (rfs == null) {
                rfs = new ResumeFlowSizes(maxbatch, -1L, -1L);
                this.lastResumeFlowSizes.put(duid, rfs);
            }
        } else {
            rfs = new ResumeFlowSizes(size, bytes, mbytes);
            this.lastResumeFlowSizes.put(duid, rfs);
        }
        if ((cuid = this.getConnectionUID()) == null) {
            this.logger.log(4, "cant resume flow[no con_uid] " + this);
            return;
        }
        IMQConnection con = (IMQConnection)Globals.getConnectionManager().getConnection(cuid);
        if (reason == null) {
            reason = "Resuming " + this;
        }
        Hashtable<String, Object> hm = new Hashtable<String, Object>();
        hm.put("JMQSize", rfs.size);
        hm.put("JMQBytes", rfs.bytes);
        hm.put("JMQMaxMsgBytes", rfs.mbytes);
        if (con != null) {
            Packet pkt = new Packet(con.useDirectBuffers());
            pkt.setPacketType(52);
            hm.put("JMQProducerID", this.getProducerUID().longValue());
            hm.put("JMQDestinationID", duid.toString());
            hm.put("Reason", reason);
            pkt.setProperties(hm);
            con.sendControlMessage(pkt);
        }
    }

    static class ResumeFlowSizes {
        int size = 0;
        long bytes = 0L;
        long mbytes = 0L;

        public ResumeFlowSizes(int s, long b, long mb) {
            this.size = s;
            this.bytes = b;
            this.mbytes = mb;
        }
    }
}

