/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.api;

import com.sun.messaging.bridge.api.DupKeyException;
import com.sun.messaging.bridge.api.JMSBridgeStore;
import com.sun.messaging.bridge.api.KeyNotFoundException;
import com.sun.messaging.bridge.api.UpdateOpaqueDataCallback;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionListener;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreManager;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreSessionReaperListener;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.sharecc.ShareConfigChangeStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jvnet.hk2.annotations.Contract;

@Contract
@Singleton
public abstract class Store
implements JMSBridgeStore {
    public static final String STORE_PROP_PREFIX = "imq.persist.store";
    public static final String CREATE_STORE_PROP = "imq.persist.storecreate.all";
    public static final String REMOVE_STORE_PROP = "imq.persist.storeremove.all";
    public static final String RESET_STORE_PROP = "imq.persist.storereset.all";
    public static final String RESET_MESSAGE_PROP = "imq.persist.storereset.messages";
    public static final String RESET_INTEREST_PROP = "imq.persist.storereset.durables";
    public static final String UPGRADE_NOBACKUP_PROP = "imq.persist.storeupgrade.nobackup";
    public static final boolean CREATE_STORE_PROP_DEFAULT = false;
    public static final String FILE_STORE_TYPE = "file";
    public static final String JDBC_STORE_TYPE = "jdbc";
    public static final String INMEMORY_STORE_TYPE = "inmemory";
    public static final String COHERENCE_STORE_TYPE = "coherence";
    public static final String BDB_STORE_TYPE = "bdb";
    private static boolean DEBUG = false;
    private static boolean DEBUG_SYNC = Globals.getConfig().getBooleanProperty("imq.persist.store.debug.sync") || DEBUG;
    public static final Logger logger = Globals.getLogger();
    public static final BrokerResources br = Globals.getBrokerResources();
    public static final BrokerConfig config = Globals.getConfig();
    protected boolean closed = false;
    protected Object closedLock = new Object();
    protected int inprogressCount = 0;
    protected Object inprogressLock = new Object();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    public Lock txnLogSharedLock = this.lock.readLock();
    public Lock txnLogExclusiveLock = this.lock.writeLock();
    protected boolean createStore = false;
    protected boolean resetStore = false;
    protected boolean resetMessage = false;
    protected boolean resetInterest = false;
    protected boolean removeStore = false;
    protected boolean upgradeNoBackup = false;
    protected boolean partitionsReady = false;

    protected Store() throws BrokerException {
        this.checkPartitionMode();
        this.createStore = config.getBooleanProperty(CREATE_STORE_PROP, false);
        this.removeStore = config.getBooleanProperty(REMOVE_STORE_PROP, false);
        this.resetStore = config.getBooleanProperty(RESET_STORE_PROP, false);
        this.resetMessage = config.getBooleanProperty(RESET_MESSAGE_PROP, false);
        this.resetInterest = config.getBooleanProperty(RESET_INTEREST_PROP, false);
        this.upgradeNoBackup = config.getBooleanProperty(UPGRADE_NOBACKUP_PROP, false);
        if (this.removeStore) {
            logger.logToAll(8, "B1095");
        } else {
            if (this.resetStore) {
                logger.logToAll(8, "B1059");
            } else {
                if (this.resetMessage) {
                    logger.logToAll(8, "B1083");
                }
                if (this.resetInterest) {
                    logger.logToAll(8, "B1084");
                }
            }
            if (!this.resetStore && (this.resetMessage || this.resetInterest)) {
                logger.logToAll(8, "B1085");
            } else if (!this.resetStore) {
                logger.logToAll(8, "B1060");
            }
        }
    }

    public void checkPartitionMode() throws BrokerException {
        if (StoreManager.isConfiguredPartitionMode(false)) {
            throw new BrokerException(br.getKString("B4400", this.getStoreType()));
        }
    }

    public Map<String, String> getClusterMatchProperties() throws BrokerException {
        return new LinkedHashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partitionsReady() throws BrokerException {
        Object object = this.closedLock;
        synchronized (object) {
            this.partitionsReady = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PartitionedStore> getAllStorePartitions() throws BrokerException {
        Object object = this.closedLock;
        synchronized (object) {
            if (!this.partitionsReady) {
                throw new BrokerException("IllegalState: store partitions not ready");
            }
            if (this.closed) {
                logger.log(16, "B3102");
                throw new BrokerException(br.getString("B3102"), 405);
            }
        }
        return null;
    }

    public boolean getPartitionModeEnabled() {
        return false;
    }

    public boolean isPartitionMigratable() {
        return false;
    }

    public abstract PartitionedStore getPrimaryPartition() throws BrokerException;

    public void partitionDeparture(UID partitionID, String targetBrokerID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public List<PartitionedStore> partitionArrived(UID id) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public PartitionedStore getStorePartition(UID id) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void addPartitionListener(PartitionListener listener) throws BrokerException {
    }

    public void removePartitionListener(PartitionListener listener) throws BrokerException {
    }

    public void repairCorruptedSysMessageID(SysMessageID realSysId, String badSysIdStr, String duidStr, boolean sync) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void removeMessage(DestinationUID duid, String sysid, boolean sync) throws IOException, BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void addStoreSessionReaperListener(StoreSessionReaperListener listener) throws BrokerException {
    }

    public void removeStoreSessionReaperListener(StoreSessionReaperListener listener) throws BrokerException {
    }

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public static boolean getDEBUG_SYNC() {
        return DEBUG_SYNC;
    }

    public abstract int getStoreVersion();

    public ShareConfigChangeStore getShareConfigChangeStore() throws BrokerException {
        if (!Globals.useSharedConfigRecord()) {
            UnsupportedOperationException ex = new UnsupportedOperationException(br.getKString("B3100", "Unexpected call"));
            logger.logStack(32, ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return StoreManager.getShareConfigChangeStore();
    }

    public int getMessageCount(String brokerID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract void storeInterest(Consumer var1, boolean var2) throws IOException, BrokerException;

    public abstract void removeInterest(Consumer var1, boolean var2) throws IOException, BrokerException;

    public abstract Consumer[] getAllInterests() throws IOException, BrokerException;

    public abstract void removeAllMessages(Destination var1, boolean var2) throws IOException, BrokerException;

    public LoadException getLoadConsumerException() {
        return null;
    }

    public void close() {
        this.close(true);
    }

    public abstract void close(boolean var1);

    public abstract void updateProperty(String var1, Object var2, boolean var3) throws BrokerException;

    public abstract Object getProperty(String var1) throws BrokerException;

    public abstract String[] getPropertyNames() throws BrokerException;

    public abstract Properties getAllProperties() throws BrokerException;

    public abstract void storeConfigChangeRecord(long var1, byte[] var3, boolean var4) throws BrokerException;

    public abstract List<ChangeRecordInfo> getConfigChangeRecordsSince(long var1) throws BrokerException;

    public abstract List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException;

    public abstract void clearAllConfigChangeRecords(boolean var1) throws BrokerException;

    public abstract void clearAll(boolean var1) throws BrokerException;

    public abstract HashMap getStorageInfo(Destination var1) throws BrokerException;

    public abstract String getStoreType();

    public boolean isJDBCStore() {
        return true;
    }

    public boolean isBDBStore() {
        return false;
    }

    public boolean isHADBStore() {
        return false;
    }

    public void resetConnectionPool() throws BrokerException {
        throw new UnsupportedOperationException("resetConnectionPool: operation not supported by the " + this.getStoreType() + " store");
    }

    public abstract Hashtable getDebugState() throws BrokerException;

    public long getBrokerHeartbeat(String brokerID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HashMap getAllBrokerHeartbeats() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public Long updateBrokerHeartbeat(String brokerID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public Long updateBrokerHeartbeat(String brokerID, long lastHeartbeat) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void addBrokerInfo(String brokerID, String URL2, BrokerState state, int version, long sessionID, long heartbeat) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void addBrokerInfo(String brokerID, String takeOverBkrID, String URL2, BrokerState state, int version, long sessionID, long heartbeat) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public UID updateBrokerInfo(String brokerID, int updateType, Object oldValue, Object newValue) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void removeInactiveStoreSession() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HashMap getAllBrokerInfos() throws BrokerException {
        return this.getAllBrokerInfos(false);
    }

    public HashMap getAllBrokerInfos(boolean loadSession) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HABrokerInfo getBrokerInfo(String brokerID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public HashMap getAllBrokerInfoByState(BrokerState state) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public String getStoreSessionOwner(long sessionID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public boolean ifOwnStoreSession(long sessionID, String brokerID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public String getStoreSessionCreator(long sessionID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public boolean updateBrokerState(String brokerID, BrokerState newState, BrokerState expectedState, boolean local) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public BrokerState getBrokerState(String brokerID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public Object[] getAllBrokerStates() throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void getTakeOverLock(String brokerID, String targetBrokerID, long lastHeartbeat, BrokerState expectedState, long newHeartbeat, BrokerState newState, boolean force, TakingoverTracker tracker) throws TakeoverLockException, BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public TakeoverStoreInfo takeOverBrokerStore(String brokerID, String targetBrokerID, TakingoverTracker tracker) throws TakeoverLockException, BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public TakeoverStoreInfo takeoverBrokerStore(String targetInstanceName, UID targetStoreSession, String targetHostPort, TakingoverTracker tracker) throws TakeoverLockException, BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public LoadException getLoadPropertyException() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClosedAndWait() {
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
        }
        this.beforeWaitOnClose();
        object = this.inprogressLock;
        synchronized (object) {
            while (this.inprogressCount > 0) {
                try {
                    this.inprogressLock.wait();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void beforeWaitOnClose() {
    }

    protected void checkClosedAndSetInProgress() throws BrokerException {
        this.checkClosedAndSetInProgress(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkClosedAndSetInProgress(int loglevel) throws BrokerException {
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                logger.log(loglevel, "B3102");
                throw new BrokerException(br.getString("B3102"), 405);
            }
            this.setInProgress(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInProgress(boolean flag) {
        Object object = this.inprogressLock;
        synchronized (object) {
            this.inprogressCount = flag ? ++this.inprogressCount : --this.inprogressCount;
            if (this.inprogressCount == 0) {
                this.inprogressLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closedLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean upgradeNoBackup() {
        return this.upgradeNoBackup;
    }

    protected boolean getConfirmation() throws BrokerException {
        try {
            String yes = br.getString("B0029");
            String yes_s = br.getString("B0026");
            String no_s = br.getString("B0027");
            Object[] objs = new String[]{yes_s, no_s};
            System.out.print(br.getString("B0040", objs));
            System.out.flush();
            String val = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (!yes_s.equalsIgnoreCase(val) && !yes.equalsIgnoreCase(val)) {
                System.err.println(br.getString("B1108"));
                Broker.getBroker().exit(1, br.getString("B1108"), BrokerEvent.Type.FATAL_ERROR);
            }
            return true;
        }
        catch (IOException ex) {
            logger.log(32, ex.toString());
            throw new BrokerException(ex.toString(), ex);
        }
    }

    @Override
    public void storeTMLogRecord(String xid, byte[] logRecord, String name, boolean sync, java.util.logging.Logger logger_) throws DupKeyException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void updateTMLogRecord(String xid, byte[] logRecord, String name, UpdateOpaqueDataCallback callback, boolean addIfNotExist, boolean sync, java.util.logging.Logger logger_) throws DupKeyException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void removeTMLogRecord(String xid, String name, boolean sync, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public byte[] getTMLogRecord(String xid, String name, java.util.logging.Logger logger_) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getTMLogRecordUpdatedTime(String xid, String name, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getTMLogRecordCreatedTime(String xid, String name, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public List getTMLogRecordsByName(String name, java.util.logging.Logger logger_) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public List getTMLogRecordsByNameByBroker(String name, String brokerID, java.util.logging.Logger logger_) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public List getNamesByBroker(String brokerID, java.util.logging.Logger logger_) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public List getTMLogRecordKeysByName(String name, java.util.logging.Logger logger_) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void addJMSBridge(String name, boolean sync, java.util.logging.Logger logger_) throws DupKeyException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public List getJMSBridges(java.util.logging.Logger logger_) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public List getJMSBridgesByBroker(String brokerID, java.util.logging.Logger logger_) throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getJMSBridgeUpdatedTime(String name, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getJMSBridgeCreatedTime(String name, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void closeJMSBridgeStore() throws Exception {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }
}

