/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.util.Hashtable;

public class AuthHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Packet pkt;
        String username;
        int status;
        block29: {
            Hashtable<String, Object> hash;
            byte[] req;
            block34: {
                block33: {
                    AccessController ac;
                    block30: {
                        block32: {
                            block31: {
                                block28: {
                                    byte[] resp = null;
                                    ByteBuffer bbuf = msg.getMessageBodyByteBuffer();
                                    int size = bbuf.remaining();
                                    resp = new byte[size];
                                    bbuf.get(resp);
                                    String reason = null;
                                    ac = con.getAccessController();
                                    boolean isIndemp = msg.getIndempotent();
                                    req = null;
                                    status = 500;
                                    username = null;
                                    if (con.isAuthenticated()) {
                                        if (!isIndemp) {
                                            reason = "already authenticated";
                                            this.logger.log(16, "Received unexpected authentication " + con.getRemoteConnectionString() + ":" + con.getConnectionUID());
                                            status = 500;
                                        } else {
                                            status = 200;
                                        }
                                        resp = null;
                                    } else if (!con.setConnectionState(3)) {
                                        reason = "bad connection state";
                                        status = 503;
                                        resp = null;
                                    }
                                    if (resp != null) {
                                        try {
                                            req = ac.handleResponse(resp, msg.getSequence());
                                            status = 200;
                                            Globals.getAuditSession().authentication(con.getUserName(), con.remoteHostString(), true);
                                            if (req == null) {
                                                IMQService s = (IMQService)con.getService();
                                                String stype = ServiceType.getServiceTypeString((int)s.getServiceType());
                                                try {
                                                    AuthCacheData acd = s.getAuthCacheData();
                                                    acd.setCacheData(ac.getCacheData());
                                                    ac.checkConnectionPermission(s.getName(), stype);
                                                    Globals.getAuditSession().connectionAuth(con.getUserName(), con.remoteHostString(), stype, s.getName(), true);
                                                }
                                                catch (AccessControlException e) {
                                                    reason = "Forbidden";
                                                    status = 403;
                                                    ac.logout();
                                                    this.logger.log(16, Globals.getBrokerResources().getKString("B2040", s.getName(), stype) + " - " + e.getMessage(), (Throwable)e);
                                                    Globals.getAuditSession().connectionAuth(con.getUserName(), con.remoteHostString(), stype, s.getName(), false);
                                                    username = con.getUserName();
                                                }
                                            }
                                        }
                                        catch (FailedLoginException e) {
                                            Globals.getAuditSession().authentication(e.getUser(), con.remoteHostString(), false);
                                            username = e.getUser();
                                            status = 413;
                                            reason = e.getMessage();
                                            this.logger.log(16, "B2130", (Throwable)e);
                                        }
                                        catch (OutOfMemoryError err) {
                                            throw err;
                                        }
                                        catch (Throwable w) {
                                            status = 403;
                                            reason = w.getMessage();
                                            this.logger.log(32, w.getMessage(), w);
                                        }
                                    }
                                    pkt = new Packet(con.useDirectBuffers());
                                    pkt.setConsumerID(msg.getConsumerID());
                                    hash = new Hashtable<String, Object>();
                                    if (reason != null) {
                                        hash.put("JMQReason", reason);
                                    }
                                    if (resp != null) break block28;
                                    pkt.setPacketType(13);
                                    hash.put("JMQStatus", status);
                                    pkt.setProperties(hash);
                                    break block29;
                                }
                                if (req != null && !con.setConnectionState(2)) {
                                    status = 503;
                                    req = null;
                                }
                                if (req != null) break block30;
                                if (status == 200 && !con.setConnectionState(4)) {
                                    status = 503;
                                }
                                pkt.setPacketType(13);
                                hash.put("JMQStatus", status);
                                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                                if (IMQBasicConnection.getDumpPacket()) break block31;
                                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                                if (!IMQBasicConnection.getDumpOutPacket()) break block32;
                            }
                            hash.put("JMQReqID", msg.getSysMessageID().toString());
                        }
                        pkt.setProperties(hash);
                        break block29;
                    }
                    pkt.setPacketType(38);
                    hash.put("JMQAuthType", ac.getAuthType());
                    hash.put("JMQChallenge", Boolean.FALSE);
                    IMQBasicConnection cfr_ignored_2 = (IMQBasicConnection)con;
                    if (IMQBasicConnection.getDumpPacket()) break block33;
                    IMQBasicConnection cfr_ignored_3 = (IMQBasicConnection)con;
                    if (!IMQBasicConnection.getDumpOutPacket()) break block34;
                }
                hash.put("JMQReqID", msg.getSysMessageID().toString());
            }
            pkt.setProperties(hash);
            pkt.setMessageBody(req);
        }
        con.sendControlMessage(pkt);
        if (status != 200) {
            IMQService s = (IMQService)con.getService();
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.notifyConnectionReject(s.getName(), username, con.remoteHostString());
            }
            con.closeConnection(true, 4, Globals.getBrokerResources().getKString("B0064"));
        } else {
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.registerConnection(con.getConnectionUID().longValue());
                agent.notifyConnectionOpen(con.getConnectionUID().longValue());
            }
        }
        return true;
    }
}

