/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.StompConnection;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompNotConnectedException;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.bridge.api.StompSession;
import com.sun.messaging.bridge.api.StompSubscriber;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandlerImpl;
import com.sun.messaging.bridge.service.stomp.StompSenderSession;
import com.sun.messaging.bridge.service.stomp.StompSubscriberSession;
import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import jakarta.jms.Connection;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StompConnectionImpl
implements StompConnection,
ExceptionListener {
    private Logger _logger = null;
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;
    private Connection _connection = null;
    private String _connectionUID = "";
    private boolean _connectionException = false;
    private StompSenderSession _pubSession = null;
    private String _clientid = null;
    private StompBridgeResources _sbr = null;
    private Map<String, StompSubscriberSession> _subSessions = Collections.synchronizedMap(new HashMap());
    private StompTransactedSession _txSession = null;
    private StompProtocolHandlerImpl _sph = null;

    public StompConnectionImpl(StompProtocolHandlerImpl sph) {
        this._logger = sph.getLogger();
        this._bc = sph.getBridgeContext();
        this._jmsprop = sph.getJMSConfig();
        this._sph = sph;
        this._sbr = sph.getStompBridgeResources();
    }

    protected StompProtocolHandlerImpl getProtocolHandler() {
        return this._sph;
    }

    @Override
    public synchronized String connect(String login, String passcode, String clientid) throws Exception {
        if (this._connection != null) {
            throw new StompProtocolException("already connected");
        }
        if (clientid == null) {
            this._logger.log(Level.INFO, this._sbr.getString("BSS1000", login));
        } else {
            this._logger.log(Level.INFO, this._sbr.getString("BSS1001", login, clientid));
        }
        this._connection = login != null ? this._bc.getConnectionFactory(this._jmsprop).createConnection(login, passcode) : this._bc.getConnectionFactory(this._jmsprop).createConnection();
        if (clientid != null) {
            this._clientid = clientid;
            this._connection.setClientID(clientid);
        }
        ((ConnectionImpl)this._connection)._setAppTransactedAck();
        this._connectionUID = ((ConnectionImpl)this._connection)._getConnectionID() + "[" + this._connection.getClientID() + "]";
        this._connection.start();
        this._logger.log(Level.INFO, this._sbr.getString("BSS1002", this._connectionUID, login));
        return this._connectionUID;
    }

    public synchronized Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        String s = this._connectionUID;
        return s == null ? "" : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disconnect(boolean check) throws Exception {
        if (check) {
            this.checkConnection();
        }
        if (this._connection != null) {
            try {
                if (this._pubSession != null) {
                    this._pubSession.close();
                    this._pubSession = null;
                }
                if (this._txSession != null) {
                    this._txSession.close();
                    this._txSession = null;
                }
                Map<String, StompSubscriberSession> map = this._subSessions;
                synchronized (map) {
                    for (String subid : this._subSessions.keySet()) {
                        StompSubscriberSession ss = this._subSessions.get(subid);
                        ss.close();
                    }
                    this._subSessions.clear();
                }
                this._connection.close();
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this._connection = null;
                this._connectionException = false;
            }
            this._logger.log(Level.INFO, this._sbr.getString("BSS1003", this._connectionUID));
        } else {
            this._logger.log(Level.FINE, this._sbr.getString("BSS1004", this._connectionUID));
        }
    }

    @Override
    public synchronized void beginTransactedSession(String tid) throws Exception {
        String currtid;
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            this._txSession = new StompTransactedSession(this);
        }
        if ((currtid = this._txSession.getStompTransactionId()) != null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4002", currtid, tid));
        }
        this._txSession.setStompTransactionId(tid);
    }

    @Override
    public synchronized void commitTransactedSession(String tid) throws Exception {
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4003", tid));
        }
        String currtid = this._txSession.getStompTransactionId();
        if (currtid == null || !currtid.equals(tid)) {
            throw new StompProtocolException(this._sbr.getKString("BSS4004", tid) + (String)(currtid == null ? "" : " " + this._sbr.getString("BSS1005", currtid)));
        }
        this._txSession.commit();
    }

    @Override
    public synchronized void abortTransactedSession(String tid) throws Exception {
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4003", tid));
        }
        String currtid = this._txSession.getStompTransactionId();
        String lastrb = this._txSession.getLastRolledbackStompTransactionId();
        if (currtid == null && lastrb != null && lastrb.equals(tid)) {
            this._logger.log(Level.INFO, this._sbr.getString("BSS1006", tid));
            return;
        }
        if (currtid == null || !currtid.equals(tid)) {
            throw new StompProtocolException(this._sbr.getKString("BSS4004", tid) + (String)(currtid == null ? "" : " " + this._sbr.getString("BSS1005", currtid)));
        }
        this._txSession.rollback();
    }

    @Override
    public void sendMessage(StompFrameMessage message, String tid) throws Exception {
        StompSenderSession ss = null;
        if (tid != null) {
            ss = (StompSenderSession)this.getTransactedSession(tid);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Sending message on transacted session: " + ss + " for transaction " + tid);
            }
        } else {
            ss = this.getSenderSession();
        }
        ss.sendStompMessage(message);
    }

    @Override
    public void ack10(String subidPrefix, String msgid, String tid) throws Exception {
        this.checkConnection();
        if (tid == null) {
            StompSubscriberSession ss = null;
            for (String subid : this._subSessions.keySet()) {
                if (!subid.startsWith(subidPrefix)) continue;
                ss = this._subSessions.get(subid);
                ss.ack(msgid);
                return;
            }
            throw new StompProtocolException(this._sbr.getKString("BSS4008", msgid, "subscription"));
        }
        StompTransactedSession ts = (StompTransactedSession)this.getTransactedSession(tid);
        ts.ack10(subidPrefix, msgid);
    }

    @Override
    public void ack(String id, String tid, String subid, String msgid, boolean nack) throws Exception {
        if (id == null && subid == null) {
            throw new IllegalArgumentException("ack(): null subid");
        }
        if (nack) {
            throw new StompProtocolException("NACK (non-WebSocket) not implemented");
        }
        if (tid != null) {
            StompTransactedSession ts = (StompTransactedSession)this.getTransactedSession(tid);
            ts.ack(subid, msgid);
        } else {
            StompSubscriberSession ss = this.getSubscriberSession(subid);
            if (ss != null) {
                ss.ack(msgid);
            } else {
                StompTransactedSession ts = this.getTransactedSession();
                if (ts == null) {
                    throw new StompProtocolException(this._sbr.getKString("BSS4021", subid));
                }
                ts.ack(subid, msgid);
            }
        }
    }

    private synchronized StompSession getTransactedSession(String tid) throws Exception {
        this.checkConnection();
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4003", tid));
        }
        String currtid = this._txSession.getStompTransactionId();
        if (currtid == null || !currtid.equals(tid)) {
            throw new StompProtocolException(this._sbr.getKString("BSS4004", tid) + (String)(currtid == null ? "" : " " + this._sbr.getString("BSS1005", currtid)));
        }
        return this._txSession;
    }

    private synchronized StompTransactedSession getTransactedSession() throws Exception {
        this.checkConnection();
        if (this._txSession == null) {
            return null;
        }
        if (this._txSession.getStompTransactionId() == null) {
            return null;
        }
        return this._txSession;
    }

    private synchronized StompSenderSession getSenderSession() throws Exception {
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (this._pubSession == null) {
            this._pubSession = new StompSenderSession(this);
        }
        return this._pubSession;
    }

    private synchronized StompSubscriberSession createSubscriberSession(String subid, StompProtocolHandler.StompAckMode ackMode) throws Exception {
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (subid == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession ss = this._subSessions.get(subid);
        if (ss != null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4005", subid));
        }
        ss = new StompSubscriberSession(subid, ackMode, this);
        this._subSessions.put(subid, ss);
        return ss;
    }

    @Override
    public StompSubscriber createSubscriber(String subid, String stompdest, StompProtocolHandler.StompAckMode ackMode, String selector, String duraname, boolean nolocal, String tid, StompOutputHandler aout) throws Exception {
        StompSubscriber sub = null;
        if (tid == null) {
            StompSubscriberSession ss = this.createSubscriberSession(subid, ackMode);
            sub = ss.createSubscriber(this._sph.toStompDestination(stompdest, ss, true), selector, duraname, nolocal, aout);
        } else {
            StompTransactedSession ts = (StompTransactedSession)this.getTransactedSession(tid);
            sub = ts.createSubscriber(subid, this._sph.toStompDestination(stompdest, ts, true), selector, duraname, nolocal, aout);
        }
        return sub;
    }

    private synchronized StompSubscriberSession getSubscriberSession(String subid) throws Exception {
        this.checkConnection();
        if (subid == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession ss = this._subSessions.get(subid);
        return ss;
    }

    @Override
    public synchronized String closeSubscriber(String subid, String duraname) throws Exception {
        this.checkConnection();
        StompSubscriberSession ss = null;
        if (duraname == null) {
            ss = this._subSessions.get(subid);
            if (ss != null) {
                ss.close();
                this._subSessions.remove(subid);
                return null;
            }
        } else {
            if (this._clientid == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4006", duraname));
            }
            String dn = null;
            for (String sid : this._subSessions.keySet()) {
                ss = this._subSessions.get(sid);
                dn = ss.getDurableName();
                if (dn == null || !dn.equals(duraname)) continue;
                ss.closeSubscriber();
                ss.getJMSSession().unsubscribe(duraname);
                ss.close();
                this._subSessions.remove(sid);
                return sid;
            }
        }
        if (this._txSession != null) {
            String sid = this._txSession.closeSubscriber(subid, duraname);
            if (duraname != null) {
                return sid;
            }
            if (sid != null) {
                return sid;
            }
        } else if (duraname != null) {
            this.getSenderSession().getJMSSession().unsubscribe(duraname);
            return null;
        }
        throw new StompProtocolException(this._sbr.getKString("BSS4007", subid));
    }

    private synchronized void checkConnection() throws Exception {
        this.checkConnection(this._connection);
        if (this._connectionException) {
            this.disconnect(false);
            this._connectionException = false;
        }
    }

    private synchronized void checkConnection(Connection conn) throws Exception {
        if (conn == null) {
            throw new StompNotConnectedException(this._sbr.getKString("BSS4009"));
        }
    }

    public void onException(JMSException e) {
        this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3000", this._connectionUID, e.getMessage()), (Throwable)e);
        this._connectionException = true;
    }
}

