/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ValueConvert;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.MessageFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MapMessageImpl
extends MessageImpl
implements MapMessage {
    private Map mapMessage = new HashMap();
    private byte[] messageBody = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;

    protected MapMessageImpl() throws JMSException {
        this.setPacketType(3);
    }

    @Override
    protected void setMessageBodyToPacket() throws JMSException {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
            this.objectOutputStream.writeObject(this.mapMessage);
            this.objectOutputStream.flush();
            this.messageBody = this.byteArrayOutputStream.toByteArray();
            this.objectOutputStream.close();
            this.byteArrayOutputStream.close();
            this.setMessageBody(this.messageBody);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4014");
        }
    }

    @Override
    protected void getMessageBodyFromPacket() throws JMSException {
        try {
            this.messageBody = this.getMessageBody();
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
            this.objectInputStream = new FilteringObjectInputStream(this.byteArrayInputStream);
            this.mapMessage = (Map)this.objectInputStream.readObject();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4015");
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.mapMessage.clear();
        this.setMessageReadMode(false);
    }

    @Override
    public boolean getBoolean(String name) throws JMSException {
        return ValueConvert.toBoolean(this.mapMessage.get(name));
    }

    @Override
    public byte getByte(String name) throws JMSException {
        return ValueConvert.toByte(this.mapMessage.get(name));
    }

    @Override
    public short getShort(String name) throws JMSException {
        return ValueConvert.toShort(this.mapMessage.get(name));
    }

    @Override
    public char getChar(String name) throws JMSException {
        return ValueConvert.toChar(this.mapMessage.get(name));
    }

    @Override
    public int getInt(String name) throws JMSException {
        return ValueConvert.toInt(this.mapMessage.get(name));
    }

    @Override
    public long getLong(String name) throws JMSException {
        return ValueConvert.toLong(this.mapMessage.get(name));
    }

    @Override
    public float getFloat(String name) throws JMSException {
        return ValueConvert.toFloat(this.mapMessage.get(name));
    }

    @Override
    public double getDouble(String name) throws JMSException {
        return ValueConvert.toDouble(this.mapMessage.get(name));
    }

    @Override
    public String getString(String name) throws JMSException {
        return ValueConvert.toString(this.mapMessage.get(name));
    }

    @Override
    public byte[] getBytes(String name) throws JMSException {
        Object obj = this.mapMessage.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        String errorString = AdministeredObject.cr.getKString("C4017");
        MessageFormatException jmse = new MessageFormatException(errorString, "C4017");
        ExceptionHandler.throwJMSException(jmse);
        return null;
    }

    @Override
    public Object getObject(String name) throws JMSException {
        return this.mapMessage.get(name);
    }

    @Override
    public Enumeration getMapNames() throws JMSException {
        Set names = this.mapMessage.keySet();
        return new Vector(names).elements();
    }

    @Override
    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, value);
    }

    @Override
    public void setByte(String name, byte value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, value);
    }

    @Override
    public void setShort(String name, short value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, value);
    }

    @Override
    public void setChar(String name, char value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, Character.valueOf(value));
    }

    @Override
    public void setInt(String name, int value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, value);
    }

    @Override
    public void setLong(String name, long value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, value);
    }

    @Override
    public void setFloat(String name, float value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, Float.valueOf(value));
    }

    @Override
    public void setDouble(String name, double value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, value);
    }

    @Override
    public void setString(String name, String value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, value);
    }

    @Override
    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.mapMessage.put(name, value);
    }

    @Override
    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        byte[] dest = new byte[length];
        System.arraycopy(value, offset, dest, 0, length);
        this.mapMessage.put(name, dest);
    }

    @Override
    public void setObject(String name, Object value) throws JMSException {
        this.checkMessageAccess();
        this.checkName(name);
        this.checkValidObjectType(value);
        this.mapMessage.put(name, value);
    }

    private void checkValidObjectType(Object value) throws MessageFormatException {
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[])) {
            String errorString = AdministeredObject.cr.getKString("C4017");
            throw new MessageFormatException(errorString, "C4017");
        }
    }

    private void checkName(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name MUST NOT be null or empty.");
        }
    }

    @Override
    public boolean itemExists(String name) throws JMSException {
        return this.mapMessage.containsKey(name);
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ MapMessageImpl dump ------");
        super.dump(ps);
    }
}

