/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.LogHandler;
import com.sun.messaging.jmq.util.log.RollingFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class FileLogHandler
extends LogHandler {
    private RollingFileOutputStream rfos = null;
    private String logFile = null;
    private long roll_bytes = 0L;
    private long roll_secs = 0L;

    @Override
    public void configure(Properties props, String prefix) throws IllegalArgumentException {
        Object dir;
        String value = null;
        String property = null;
        Object error_msg = null;
        long bytes = 0L;
        long secs = 0L;
        property = (String)(prefix = (String)prefix + ".") + "rolloverbytes";
        value = props.getProperty(property);
        if (value != null) {
            try {
                bytes = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                error_msg = rb.getString("S2000", property, value);
            }
        }
        if ((value = props.getProperty(property = (String)prefix + "rolloversecs")) != null) {
            try {
                secs = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                error_msg = (String)(error_msg != null ? (String)error_msg + "\n" : "") + rb.getString("S2000", property, value);
            }
        }
        if (bytes == -1L) {
            bytes = 0L;
        }
        if (secs == -1L) {
            secs = 0L;
        }
        this.setRolloverLimits(bytes, secs);
        property = (String)prefix + "dirpath";
        value = props.getProperty(property);
        if (value != null) {
            value = StringUtil.expandVariables(value, props);
            dir = value;
        } else {
            dir = "log";
        }
        if (!new File((String)dir).isAbsolute()) {
            dir = this.logger.logHome + File.separator + (String)dir;
        }
        String file = (value = props.getProperty(property = (String)prefix + "filename")) != null ? value : "logfile";
        try {
            this.setLogFile((String)dir, file);
        }
        catch (IOException e) {
            error_msg = (String)(error_msg != null ? (String)error_msg + "\n" : "") + rb.getString("S3000", (String)dir + File.separator + file, e);
        }
        property = (String)prefix + "output";
        value = props.getProperty(property);
        if (value != null) {
            try {
                this.setLevels(value);
            }
            catch (IllegalArgumentException e) {
                error_msg = (String)(error_msg != null ? (String)error_msg + "\n" : "") + property + ": " + e.getMessage();
            }
        }
        if (error_msg != null) {
            throw new IllegalArgumentException((String)error_msg);
        }
    }

    public void setLogFile(String logDir, String logFile) throws IOException {
        boolean rcode;
        this.close();
        this.logFile = logDir + File.separator + logFile;
        File d = new File(logDir);
        if (!d.exists() && !(rcode = d.mkdirs())) {
            throw new IOException(rb.getString("S4000", logDir));
        }
        File f = new File(this.logFile);
        f.createNewFile();
        if (!f.canWrite()) {
            throw new IOException(rb.getString("S4001", this.logFile));
        }
    }

    public void setRolloverLimits(long roll_bytes, long roll_secs) {
        if (roll_bytes >= 0L) {
            this.roll_bytes = roll_bytes;
            if (this.rfos != null) {
                this.rfos.setRolloverBytes(this.roll_bytes);
            }
        }
        if (roll_secs >= 0L) {
            this.roll_secs = roll_secs;
            if (this.rfos != null) {
                this.rfos.setRolloverSecs(this.roll_secs);
            }
        }
    }

    @Override
    public void publish(int level, String message) throws IOException {
        if (level == 64 && !this.isAllowForceMessage()) {
            return;
        }
        if (this.rfos != null) {
            this.rfos.write(message.getBytes());
        }
    }

    @Override
    public void open() throws IOException {
        if (this.rfos != null) {
            return;
        }
        this.rfos = new RollingFileOutputStream(new File(this.logFile), this.roll_bytes, this.roll_secs);
    }

    @Override
    public void close() {
        if (this.rfos != null) {
            try {
                this.rfos.flush();
                this.rfos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.rfos = null;
    }

    @Override
    public void flush() {
        if (this.rfos != null) {
            try {
                this.rfos.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.logFile;
    }
}

