/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import com.sun.messaging.jmq.util.timer.TimerEventHandler;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class TransactionReaper
implements TimerEventHandler {
    private TxLog _txlog = null;
    private Logger _logger = null;
    private Vector removes = new Vector();
    private WakeupableTimer reapTimer = null;
    private int _reapLimit = 1;
    private long _reapInterval = 1000L;

    public TransactionReaper(TxLog txlog, int reapLimit, int reapInterval) {
        this._txlog = txlog;
        this._logger = this._txlog.getLogger();
        this._reapLimit = reapLimit;
        if (this._reapInterval <= 0L) {
            this._reapInterval = 60L;
        }
        this._reapInterval = (long)reapInterval * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(GlobalXid gxid) {
        if (this._reapLimit == 0 || this.removes.size() > 2 * this._reapLimit) {
            try {
                this._txlog.reap(gxid.toString());
                return;
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Failed to cleanup global transaction " + gxid + ":" + e + ", will retry later", e);
            }
        }
        this.removes.add(gxid);
        this.createTimer();
        if (this.removes.size() > this._reapLimit) {
            TransactionReaper transactionReaper = this;
            synchronized (transactionReaper) {
                if (this.reapTimer != null) {
                    this.reapTimer.wakeup();
                }
            }
        }
    }

    private synchronized void createTimer() {
        if (this.reapTimer == null) {
            try {
                String startString = "Transaction reaper thread has started for TM " + this._txlog.getTMName();
                String exitString = "Transaction reaper thread for TM " + this._txlog.getTMName() + " is exiting";
                this.reapTimer = new WakeupableTimer("JMSBridgeTMTransactionReaper-" + this._txlog.getTMName(), (TimerEventHandler)this, this._reapInterval, this._reapInterval, startString, exitString);
            }
            catch (Throwable ex) {
                this._logger.log(Level.WARNING, "Unable to start transaction reaper thread for TM " + this._txlog.getTMName(), ex);
                try {
                    this._txlog.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void handleOOMError(Throwable e) {
    }

    public void handleLogInfo(String msg) {
        if (this._logger == null) {
            return;
        }
        this._logger.log(Level.INFO, msg);
    }

    public void handleLogWarn(String msg, Throwable e) {
        if (this._logger == null) {
            return;
        }
        this._logger.log(Level.WARNING, msg, e);
    }

    public void handleLogError(String msg, Throwable e) {
        if (this._logger == null) {
            return;
        }
        this._logger.log(Level.SEVERE, msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTimerExit(Throwable e) {
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            if (this.reapTimer == null) {
                return;
            }
        }
        if (this._txlog.isClosed()) {
            return;
        }
        this._logger.log(Level.SEVERE, "[" + this._txlog.getTMName() + "]Unexpected transaction log reaper thread exit", e);
        try {
            this._txlog.close();
        }
        catch (Exception ex) {
            this._logger.log(Level.WARNING, "[" + this._txlog.getTMName() + "]" + e.getMessage(), e);
        }
    }

    public synchronized void destroy() {
        if (this.reapTimer != null) {
            this.reapTimer.cancel();
            this.reapTimer = null;
        }
        this.removes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runTask() {
        GlobalXid[] gxids = null;
        Vector vector = this.removes;
        synchronized (vector) {
            gxids = this.removes.toArray(new GlobalXid[this.removes.size()]);
        }
        int cnt = gxids.length - this._reapLimit;
        for (int i = 0; i < cnt; ++i) {
            String key = gxids[i].toString();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Cleaning up global transaction " + key);
            }
            try {
                this._txlog.reap(key);
                this.removes.remove((Object)gxids[i]);
                continue;
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Failed to cleanup global transaction " + key, e);
            }
        }
        return 0L;
    }
}

