/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.PooledConnection;
import com.sun.messaging.bridge.service.jms.PooledConnectionImpl;
import com.sun.messaging.bridge.service.jms.PooledXAConnectionImpl;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.XAConnection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PooledConnectionFactory
implements Runnable {
    public static final String POOL_IDLE_TIMEOUT = "pool-idle-timeout";
    private Logger _logger = null;
    private Object _cf = null;
    private int _maxRetries = 0;
    private int _retryInterval = 0;
    private ScheduledExecutorService _scheduler = null;
    private ScheduledFuture _future = null;
    private int _idleTimeout = 0;
    private ConcurrentLinkedQueue<PooledConnection> _idleConns = null;
    private ConcurrentLinkedQueue<PooledConnection> _outConns = null;
    private final EventNotifier _notifier = new EventNotifier();
    private boolean _closed = false;
    private String _username = null;
    private String _password = null;
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    public PooledConnectionFactory(Object cf, Properties attrs, Logger logger) throws Exception {
        this._logger = logger;
        this._cf = cf;
        String val = attrs.getProperty("username");
        if (val != null) {
            this._username = val.trim();
            this._password = attrs.getProperty("password");
        }
        if ((val = attrs.getProperty("idle-timeout-in-seconds", "1800")) != null) {
            this._idleTimeout = Integer.parseInt(val);
        }
        if (this._idleTimeout < 0) {
            this._idleTimeout = 0;
        }
        if ((val = attrs.getProperty("connect-attempts", "-1")) != null) {
            this._maxRetries = Integer.parseInt(val);
        }
        if ((val = attrs.getProperty("connect-attempt-interval-in-seconds", "5")) != null) {
            this._retryInterval = Integer.parseInt(val);
        }
        if (this._retryInterval < 0) {
            this._retryInterval = 0;
        }
        this._idleConns = new ConcurrentLinkedQueue();
        this._outConns = new ConcurrentLinkedQueue();
        this._scheduler = Executors.newSingleThreadScheduledExecutor();
        if (this._idleTimeout > 0) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1044", this._idleTimeout, this.toString()));
            this._future = this._scheduler.scheduleAtFixedRate(this, this._idleTimeout, this._idleTimeout, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection obtainConnection(Connection c, String logstr, Object caller, boolean doReconnect) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Obtaining pooled connection from pooled connection factory " + this);
        }
        if (this._closed) {
            if (c == null) {
                throw new JMSException(_jbr.getKString("BSJ4027", this.toString()));
            }
            try {
                c.close();
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Unable to close connection in pooled connection factory " + this);
            }
            throw new JMSException(_jbr.getKString("BSJ4027", this.toString()));
        }
        PooledConnection pconn = null;
        if (c != null) {
            pconn = c instanceof XAConnection ? new PooledXAConnectionImpl((XAConnection)c) : new PooledConnectionImpl(c);
            this._idleConns.offer(pconn);
        }
        while (true) {
            if ((pconn = this._idleConns.poll()) == null) {
                if (this._closed) {
                    throw new JMSException(_jbr.getKString("BSJ4027", this.toString()));
                }
                Connection cn = null;
                EventListener l = new EventListener(this);
                try {
                    this._notifier.addEventListener(EventListener.EventType.CONN_CLOSE, l);
                    cn = JMSBridge.openConnection(this._cf, this._maxRetries, this._retryInterval, this._username, this._password, logstr, caller, l, this._logger, doReconnect);
                }
                finally {
                    this._notifier.removeEventListener(l);
                }
                pconn = cn instanceof XAConnection ? new PooledXAConnectionImpl((XAConnection)cn) : new PooledConnectionImpl(cn);
            }
            if (!this._closed && pconn.isValid()) {
                pconn.idleEnd();
                this._outConns.offer(pconn);
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Obtained pooled connection " + pconn + " from pooled connection factory " + this);
                }
                return (Connection)pconn;
            }
            try {
                if (this._closed) {
                    this._logger.log(Level.INFO, "Closing connection " + pconn + " for pooled connection factory " + this + " is closed");
                } else if (!pconn.isValid()) {
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1045", pconn.toString(), this.toString()));
                }
                ((Connection)pconn).close();
                continue;
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Unable to close connection " + pconn + " in pooled connection factory " + this + ": " + e.getMessage());
                continue;
            }
            break;
        }
    }

    public void returnConnection(Connection conn) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Returning pooled connection " + conn + " to pooled connection factory " + this);
        }
        if (!(conn instanceof PooledConnection)) {
            throw new IllegalArgumentException("Connection " + conn + " is not a pooled connection, can't return to pooled connection factory " + this);
        }
        if (!this._outConns.contains(conn)) {
            throw new IllegalStateException("Connection " + conn + " is not a in-use in pooled connection factory " + this);
        }
        this._outConns.remove(conn);
        ((PooledConnection)conn).idleStart();
        this._idleConns.offer((PooledConnection)conn);
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Returned pooled connection " + conn + " to pooled connection factory " + this);
        }
    }

    public void close() {
        this._closed = true;
        this._logger.log(Level.INFO, _jbr.getString("BSJ1046", this.toString()));
        this._notifier.notifyEvent(EventListener.EventType.CONN_CLOSE, this);
        if (this._outConns.size() > 0) {
            this._logger.log(Level.WARNING, _jbr.getString("BSJ2018", this.toString()));
        }
        if (this._future != null) {
            this._scheduler.shutdownNow();
            try {
                this._scheduler.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.run();
    }

    @Override
    public void run() {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Check idle timeout in pooled connection factory " + this);
        }
        ArrayList<PooledConnection> list = new ArrayList<PooledConnection>();
        PooledConnection c = this._idleConns.peek();
        list.add(c);
        while (c != null) {
            long idlestime = c.getIdleStartTime();
            if (idlestime <= 0L && c.isValid() && !this._closed) continue;
            c = this._idleConns.poll();
            if (c == null) {
                return;
            }
            if (!c.isValid() || System.currentTimeMillis() - idlestime > (long)this._idleTimeout || this._closed) {
                this._logger.log(Level.INFO, c.isValid() ? _jbr.getString("BSJ1047", c.toString(), this.toString()) : _jbr.getString("BSJ1045", c.toString(), this.toString()));
                try {
                    ((Connection)c).close();
                }
                catch (Exception e) {
                    this._logger.log(Level.WARNING, "Failed to close " + (this._closed ? "" : (c.isValid() ? "idle timed out connection " : "invalid connection ")) + c + " in pooled connection factory " + this);
                    c.invalid();
                    this._idleConns.offer(c);
                }
            } else {
                this._idleConns.offer(c);
            }
            c = this._idleConns.peek();
            if (list.contains(c)) break;
            list.add(c);
        }
    }

    public Object getCF() {
        return this._cf;
    }

    public int getIdleTimeout() {
        return this._idleTimeout;
    }

    public int getMaxRetries() {
        return this._maxRetries;
    }

    public int getRetryInterval() {
        return this._retryInterval;
    }

    public int getNumIdleConns() {
        return this._idleConns.size();
    }

    public int getNumInUseConns() {
        return this._outConns.size();
    }

    public String toString() {
        return this._cf + "[" + this._outConns.size() + ", " + this._idleConns.size() + "]";
    }
}

