/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.tools.ws.util.xml.XmlUtil;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.glassfish.web.deployment.util.WebServerInfo;
import org.glassfish.webservices.Import;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WSServletContextListener;
import org.glassfish.webservices.WebServiceDeploymentNotifier;
import org.glassfish.webservices.WebServiceDeploymentNotifierImpl;
import org.glassfish.webservices.WebServicesApplication;
import org.glassfish.webservices.WebServicesContainer;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.deployment.WebServicesDeploymentMBean;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Service
public class WebServicesDeployer
extends JavaEEDeployer<WebServicesContainer, WebServicesApplication> {
    public static final WebServiceDeploymentNotifier deploymentNotifier = new WebServiceDeploymentNotifierImpl();
    private static final Logger logger = LogUtils.getLogger();
    private ResourceBundle rb = logger.getResourceBundle();
    @Inject
    private RequestDispatcher dispatcher;
    @Inject
    private ArchiveFactory archiveFactory;

    public static WebServiceDeploymentNotifier getDeploymentNotifier() {
        return deploymentNotifier;
    }

    protected void cleanArtifacts(DeploymentContext deploymentContext) throws DeploymentException {
    }

    public boolean prepare(DeploymentContext dc) {
        try {
            Application app = (Application)dc.getModuleMetaData(Application.class);
            if (app == null) {
                logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00001");
                return false;
            }
            BundleDescriptor bundle = DOLUtils.getCurrentBundleForContext((DeploymentContext)dc);
            String moduleCP = this.getModuleClassPath(dc);
            final List moduleCPUrls = ASClassLoaderUtil.getURLsFromClasspath((String)moduleCP, (String)File.pathSeparator, null);
            final ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            URLClassLoader newCl = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    return new URLClassLoader(ASClassLoaderUtil.convertURLListToArray((List)moduleCPUrls), oldCl);
                }
            });
            Thread.currentThread().setContextClassLoader(newCl);
            WebServicesDescriptor wsDesc = bundle.getWebServices();
            for (WebService ws : wsDesc.getWebServices()) {
                this.setupJaxWSServiceForDeployment(dc, ws);
            }
            this.doWebServicesDeployment(app, dc);
            Thread.currentThread().setContextClassLoader(oldCl);
            WebServicesContainer container = (WebServicesContainer)((Object)this.habitat.getService(WebServicesContainer.class, new Annotation[0]));
            WebServicesDeploymentMBean bean = container.getDeploymentBean();
            WebServiceDeploymentNotifier notifier = WebServicesDeployer.getDeploymentNotifier();
            bean.deploy(wsDesc, notifier);
            return true;
        }
        catch (Exception ex) {
            RuntimeException re = new RuntimeException(ex.getMessage());
            re.initCause(ex);
            throw re;
        }
    }

    protected void setupJaxWSServiceForDeployment(DeploymentContext dc, WebService ws) throws DeploymentException {
        BundleDescriptor bundle = (BundleDescriptor)dc.getModuleMetaData(BundleDescriptor.class);
        File moduleDir = dc.getSourceDir();
        File wsdlDir = dc.getScratchDir("xml");
        WebServicesDeployer.mkDirs(wsdlDir);
        File stubsDir = dc.getScratchDir("ejb");
        WebServicesDeployer.mkDirs(stubsDir);
        if (!DOLUtils.warType().equals((Object)bundle.getModuleType()) && !DOLUtils.ejbType().equals((Object)bundle.getModuleType())) {
            return;
        }
        wsdlDir = new File(wsdlDir, bundle.getWsdlDir().replaceAll("/", "\\" + File.separator));
        try {
            this.checkCatalog(bundle, ws, moduleDir);
        }
        catch (DeploymentException e) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00089");
        }
        if (ws.hasWsdlFile()) {
            File wsdlFile;
            if (ws.getWsdlFileUri().startsWith("http")) {
                String wsdlFileUri;
                try {
                    wsdlFileUri = this.downloadWsdlsAndSchemas(new URL(ws.getWsdlFileUri()), wsdlDir);
                }
                catch (Exception e) {
                    throw new DeploymentException(e.toString(), (Throwable)e);
                }
                wsdlFile = new File(wsdlDir, wsdlFileUri);
            } else {
                String wsdlFileUri = ws.getWsdlFileUri();
                File wsdlFileAbs = new File(wsdlFileUri);
                File file = wsdlFile = wsdlFileAbs.isAbsolute() ? wsdlFileAbs : new File(moduleDir, wsdlFileUri);
            }
            if (!wsdlFile.exists()) {
                String errorMessage = this.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00002"), ws.getWsdlFileUri(), bundle.getModuleDescriptor().getArchiveUri());
                logger.log(Level.SEVERE, errorMessage);
                throw new DeploymentException(errorMessage);
            }
        }
    }

    public Object loadMetaData(Class type, DeploymentContext dc) {
        return true;
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    private String downloadWsdlsAndSchemas(URL httpUrl, File wsdlDir) throws Exception {
        WebServicesDeployer.mkDirs(wsdlDir);
        String fileName = httpUrl.toString().substring(httpUrl.toString().lastIndexOf("/") + 1);
        File toFile = new File(wsdlDir.getAbsolutePath() + File.separator + fileName);
        this.downloadFile(httpUrl, toFile);
        HashSet wsdlRelativeImports = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaIncludes = new HashSet();
        this.parseRelativeImports(httpUrl, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        String urlWithoutFileName = httpUrl.toString().substring(0, httpUrl.toString().lastIndexOf("/"));
        for (Import next : schemaRelativeImports) {
            String location = next.getLocation();
            if ((location = location.replaceAll("/", "\\" + File.separator)).lastIndexOf(File.separator) != -1) {
                File newDir = new File(wsdlDir.getAbsolutePath() + File.separator + location.substring(0, location.lastIndexOf(File.separator)));
                WebServicesDeployer.mkDirs(newDir);
            }
            this.downloadFile(new URL(urlWithoutFileName + "/" + next.getLocation()), new File(wsdlDir.getAbsolutePath() + File.separator + location));
        }
        for (Import next : wsdlRelativeImports) {
            String newWsdlLocation = next.getLocation();
            File newWsdlDir = (newWsdlLocation = newWsdlLocation.replaceAll("/", "\\" + File.separator)).lastIndexOf(File.separator) != -1 ? new File(wsdlDir.getAbsolutePath() + File.separator + newWsdlLocation.substring(0, newWsdlLocation.lastIndexOf(File.separator))) : wsdlDir;
            this.downloadWsdlsAndSchemas(new URL(urlWithoutFileName + "/" + next.getLocation()), newWsdlDir);
        }
        return fileName;
    }

    private void checkCatalog(BundleDescriptor bundle, WebService ws, File moduleDir) throws DeploymentException {
        File catalogFile = new File(moduleDir, bundle.getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
        if (!catalogFile.exists()) {
            return;
        }
        this.resolveCatalog(catalogFile, ws.getWsdlFileUri(), ws);
    }

    public URL resolveCatalog(File catalogFile, String wsdlFile, WebService ws) throws DeploymentException {
        try {
            URL retVal = null;
            EntityResolver resolver = XmlUtil.createEntityResolver((URL)catalogFile.toURL());
            InputSource source = resolver.resolveEntity(null, wsdlFile);
            if (source != null) {
                String mappedEntry = source.getSystemId();
                if (mappedEntry.startsWith("file:")) {
                    File f = new File(mappedEntry.substring(mappedEntry.indexOf(":") + 1));
                    if (!f.exists()) {
                        throw new DeploymentException(this.format(this.rb.getString("AS-WSJSR109IMPL-00020"), mappedEntry));
                    }
                    retVal = f.toURI().toURL();
                    if (ws != null) {
                        ws.setWsdlFileUri(f.getAbsolutePath());
                        ws.setWsdlFileUrl(retVal);
                    }
                } else if (mappedEntry.startsWith("http")) {
                    retVal = new URL(mappedEntry);
                    if (ws != null) {
                        ws.setWsdlFileUrl(retVal);
                    }
                }
            }
            return retVal;
        }
        catch (Throwable t) {
            throw new DeploymentException(this.format(this.rb.getString("AS-WSJSR109IMPL-00003"), catalogFile.getAbsolutePath(), t.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File src, File dest) throws IOException {
        if (!dest.exists()) {
            WebServicesDeployer.mkDirs(dest.getParentFile());
            WebServicesDeployer.mkFile(dest);
        }
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            srcChannel = new FileInputStream(src).getChannel();
            destChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)destChannel).transferFrom(srcChannel, 0L, srcChannel.size());
        }
        finally {
            if (srcChannel != null) {
                srcChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(URL httpUrl, File toFile) throws Exception {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            int readCount;
            if (!toFile.createNewFile()) {
                throw new Exception(this.format(this.rb.getString("AS-WSJSR109IMPL-00004"), toFile.getAbsolutePath()));
            }
            is = httpUrl.openStream();
            os = new FileOutputStream(toFile, true);
            byte[] buffer = new byte[10240];
            while ((readCount = is.read(buffer, 0, 10240)) != -1) {
                os.write(buffer, 0, readCount);
            }
            os.flush();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRelativeImports(URL wsdlFileUrl, Collection wsdlRelativeImports, Collection wsdlIncludes, Collection schemaRelativeImports, Collection schemaIncludes) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        InputStream is = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = wsdlFileUrl.openStream();
            Document document = builder.parse(is);
            this.procesSchemaImports(document, schemaRelativeImports);
            this.procesWsdlImports(document, wsdlRelativeImports);
            this.procesSchemaIncludes(document, schemaIncludes);
            this.procesWsdlIncludes(document, wsdlIncludes);
        }
        catch (SAXParseException spe) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00013", new Object[]{spe.getLineNumber(), spe.getSystemId()});
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00079", x);
        }
        catch (Exception sxe) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00014", sxe.getMessage());
        }
        finally {
            block18: {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException io) {
                    if (!logger.isLoggable(Level.FINE)) break block18;
                    logger.log(Level.FINE, "AS-WSJSR109IMPL-00050", io.getMessage());
                }
            }
        }
    }

    private void procesSchemaImports(Document document, Collection schemaImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaImports = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        this.addImportsAndIncludes(schemaImports, schemaImportCollection, "namespace", "schemaLocation");
    }

    private void procesWsdlImports(Document document, Collection wsdlImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlImports = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        this.addImportsAndIncludes(wsdlImports, wsdlImportCollection, "namespace", "location");
    }

    private void procesSchemaIncludes(Document document, Collection schemaIncludeCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaIncludes = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        this.addImportsAndIncludes(schemaIncludes, schemaIncludeCollection, null, "schemaLocation");
    }

    private void procesWsdlIncludes(Document document, Collection wsdlIncludesCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlIncludes = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "include");
        this.addImportsAndIncludes(wsdlIncludes, wsdlIncludesCollection, null, "location");
    }

    private void addImportsAndIncludes(NodeList list, Collection result, String namespace, String location) throws SAXException, ParserConfigurationException, IOException {
        for (int i = 0; i < list.getLength(); ++i) {
            String givenLocation = null;
            Node element = list.item(i);
            NamedNodeMap attrs = element.getAttributes();
            Node n = attrs.getNamedItem(location);
            if (n != null) {
                givenLocation = n.getNodeValue();
            }
            if (givenLocation == null || givenLocation.startsWith("http")) continue;
            Import imp = new Import();
            imp.setLocation(givenLocation);
            if (namespace != null && (n = attrs.getNamedItem(namespace)) != null) {
                imp.setNamespace(n.getNodeValue());
            }
            result.add(imp);
        }
    }

    private void doWebServicesDeployment(Application app, DeploymentContext dc) throws Exception {
        WebBundleDescriptor webBundleDesc;
        HashSet webServices = new HashSet();
        WebServicesDescriptor wsDesc = (WebServicesDescriptor)dc.getModuleMetaData(WebServicesDescriptor.class);
        if (wsDesc != null && wsDesc.getWebServices().size() > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "AS-WSJSR109IMPL-00090", new Object[]{wsDesc.getWebServices().size(), this.getWebServiceDescriptors(app).size()});
            }
            webServices.addAll(wsDesc.getWebServices());
        }
        if ((webBundleDesc = (WebBundleDescriptor)dc.getModuleMetaData(WebBundleDescriptor.class)) != null) {
            Collection ejbBundleDescriptors = webBundleDesc.getExtensionsDescriptors(EjbBundleDescriptor.class);
            for (EjbBundleDescriptor ejbBundleDescriptor : ejbBundleDescriptors) {
                Collection wsInExtnDesc = ejbBundleDescriptor.getWebServices().getWebServices();
                webServices.addAll(wsInExtnDesc);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "AS-WSJSR109IMPL-00091", wsInExtnDesc);
            }
        }
        if (webBundleDesc != null && webBundleDesc.getExtensionsDescriptors(EjbBundleDescriptor.class).size() == 0 && dc.getAppProps().get("context-root") != null && app.isVirtual()) {
            String contextRoot = (String)dc.getAppProps().get("context-root");
            webBundleDesc.setContextRoot(contextRoot);
        }
        for (WebService next : webServices) {
            WsUtil wsUtil = new WsUtil();
            if (!next.hasFilePublishing()) {
                for (WebServiceEndpoint wsep : next.getEndpoints()) {
                    URL finalWsdlURL = wsep.composeFinalWsdlUrl(wsUtil.getWebServerInfoForDAS().getWebServerRootURL(wsep.isSecure()));
                    Set serviceRefs = new HashSet();
                    if (webBundleDesc != null) {
                        serviceRefs = webBundleDesc.getServiceReferenceDescriptors();
                    } else {
                        EjbBundleDescriptor ejbBundleDesc = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
                        if (ejbBundleDesc != null) {
                            serviceRefs = ejbBundleDesc.getEjbServiceReferenceDescriptors();
                        } else {
                            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00121", DOLUtils.getCurrentBundleForContext((DeploymentContext)dc).getModuleType());
                        }
                    }
                    for (ServiceReferenceDescriptor srd : serviceRefs) {
                        if (!srd.getServiceName().equals(wsep.getServiceName()) || !srd.getServiceNamespaceUri().equals(wsep.getWsdlService().getNamespaceURI())) continue;
                        srd.setWsdlFileUri(finalWsdlURL.toExternalForm() + "?WSDL");
                    }
                }
                continue;
            }
            URL url = next.getWsdlFileUrl();
            if (url == null) {
                File f = new File(dc.getSourceDir(), next.getWsdlFileUri());
                url = f.toURL();
            }
            File genXmlDir = dc.getScratchDir("xml");
            String wsdlFileDir = next.getWsdlFileUri().substring(0, next.getWsdlFileUri().lastIndexOf(47));
            WebServicesDeployer.mkDirs(new File(genXmlDir, wsdlFileDir));
            File genWsdlFile = new File(genXmlDir, next.getWsdlFileUri());
            wsUtil.generateFinalWsdl(url, next, wsUtil.getWebServerInfoForDAS(), genWsdlFile);
        }
        if (webBundleDesc != null) {
            this.doWebServiceDeployment(webBundleDesc);
        }
    }

    private void doWebServiceDeployment(WebBundleDescriptor webBunDesc) throws DeploymentException, MalformedURLException {
        Collection endpoints = webBunDesc.getWebServices().getEndpoints();
        ClassLoader cl = webBunDesc.getClassLoader();
        WsUtil wsutil = new WsUtil();
        for (WebServiceEndpoint nextEndpoint : endpoints) {
            WebComponentDescriptor webComp = nextEndpoint.getWebComponentImpl();
            if (!nextEndpoint.hasServletImplClass()) {
                throw new DeploymentException(this.format(this.rb.getString("AS-WSJSR109IMPL-00011"), nextEndpoint.getEndpointName()));
            }
            if (nextEndpoint.hasEndpointAddressUri()) {
                webComp.getUrlPatternsSet().clear();
                webComp.addUrlPattern(nextEndpoint.getEndpointAddressUri());
            }
            if (!nextEndpoint.getWebService().hasFilePublishing()) {
                String publishingUri = nextEndpoint.getPublishingUri();
                Object publishingUrlPattern = publishingUri.charAt(0) == '/' ? publishingUri : "/" + publishingUri + "/*";
                webComp.addUrlPattern((String)publishingUrlPattern);
            }
            String containerServlet = "org.glassfish.webservices.JAXWSServlet";
            this.addWSServletContextListener(webBunDesc);
            webComp.setWebComponentImplementation(containerServlet);
            WebServerInfo wsi = new WsUtil().getWebServerInfoForDAS();
            URL rootURL = wsi.getWebServerRootURL(nextEndpoint.isSecure());
            String contextRoot = webBunDesc.getContextRoot();
            URL actualAddress = nextEndpoint.composeEndpointAddress(rootURL, contextRoot);
            if (wsi.getHttpVS() == null || wsi.getHttpVS().getPort() == 0) continue;
            logger.log(Level.INFO, "AS-WSJSR109IMPL-00018", new Object[]{nextEndpoint.getEndpointName(), actualAddress});
        }
    }

    private void addWSServletContextListener(WebBundleDescriptor webBunDesc) {
        for (AppListenerDescriptor appListner : webBunDesc.getAppListenerDescriptors()) {
            if (!appListner.getListener().equals(WSServletContextListener.class.getName())) continue;
            return;
        }
        webBunDesc.addAppListenerDescriptor((AppListenerDescriptor)new AppListenerDescriptorImpl(WSServletContextListener.class.getName()));
    }

    private String format(String key, String ... values) {
        return MessageFormat.format(key, values);
    }

    public static void moveFile(String sourceFile, String destFile) throws IOException {
        FileUtils.copy((String)sourceFile, (String)destFile);
        FileUtils.deleteFile((File)new File(sourceFile));
    }

    public void unload(WebServicesApplication container, DeploymentContext context) {
        WebServiceDeploymentNotifier notifier = WebServicesDeployer.getDeploymentNotifier();
        this.deletePublishedFiles(container.getPublishedFiles());
        Application app = container.getApplication();
        if (app == null) {
            app = (Application)context.getModuleMetaData(Application.class);
        }
        if (app != null) {
            for (WebService svc : this.getWebServiceDescriptors(app)) {
                for (WebServiceEndpoint endpoint : svc.getEndpoints()) {
                    if (notifier == null) continue;
                    notifier.notifyUndeployed(endpoint);
                }
            }
        }
    }

    public void clean(DeploymentContext dc) {
        super.clean(dc);
        WebServicesContainer container = (WebServicesContainer)((Object)this.habitat.getService(WebServicesContainer.class, new Annotation[0]));
        WebServicesDeploymentMBean bean = container.getDeploymentBean();
        UndeployCommandParameters params = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        if (params != null) {
            bean.undeploy(params.name);
        }
    }

    public WebServicesApplication load(WebServicesContainer container, DeploymentContext context) {
        Set<String> publishedFiles = null;
        Application app = (Application)context.getModuleMetaData(Application.class);
        try {
            publishedFiles = this.populateWsdlFilesForPublish(context, this.getWebServiceDescriptors(app));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new WebServicesApplication(context, this.dispatcher, publishedFiles);
    }

    private Set<String> populateWsdlFilesForPublish(DeploymentContext dc, Set<WebService> webservices) throws IOException {
        HashSet<String> publishedFiles = new HashSet<String>();
        for (WebService webService : webservices) {
            File parent;
            if (!webService.hasFilePublishing()) continue;
            this.copyExtraFilesToGeneratedFolder(dc);
            BundleDescriptor bundle = webService.getBundleDescriptor();
            ArchiveType moduleType = bundle.getModuleType();
            if (moduleType == null || !moduleType.equals((Object)DOLUtils.earType()) && !moduleType.equals((Object)DOLUtils.warType()) && !moduleType.equals((Object)DOLUtils.ejbType())) {
                return publishedFiles;
            }
            File sourceDir = dc.getScratchDir("xml");
            try {
                URI clientPublishURI = webService.getClientPublishUrl().toURI();
                parent = !clientPublishURI.isOpaque() ? new File(clientPublishURI) : new File(webService.getClientPublishUrl().getPath());
            }
            catch (URISyntaxException e) {
                logger.log(Level.WARNING, "AS-WSJSR109IMPL-00050", e);
                parent = new File(webService.getClientPublishUrl().getPath());
            }
            FileArchive archive = new FileArchive();
            archive.open(sourceDir.toURI());
            Enumeration entries = archive.entries(bundle.getWsdlDir());
            while (entries.hasMoreElements()) {
                String name = (String)entries.nextElement();
                String wsdlName = this.stripWsdlDir(name, bundle);
                File clientwsdl = new File(parent, wsdlName);
                File fulluriFile = new File(sourceDir, name);
                if (fulluriFile.isDirectory()) continue;
                this.publishFile(fulluriFile, clientwsdl);
                publishedFiles.add(clientwsdl.getAbsolutePath());
            }
        }
        return publishedFiles;
    }

    private void publishFile(File file, File publishLocation) throws IOException {
        WebServicesDeployer.copyFile(file, publishLocation);
    }

    private void deletePublishedFiles(Set<String> publishedFiles) {
        if (publishedFiles != null) {
            for (String path : publishedFiles) {
                File f = new File(path);
                if (!f.exists()) continue;
                FileUtils.deleteFile((File)f);
            }
        }
    }

    private void copyExtraFilesToGeneratedFolder(DeploymentContext context) throws IOException {
        Archivist archivist = (Archivist)this.habitat.getService(Archivist.class, new Annotation[0]);
        ReadableArchive archive = this.archiveFactory.openArchive(context.getSourceDir());
        WritableArchive archive2 = this.archiveFactory.createArchive(context.getScratchDir("xml"));
        archivist.copyExtraElements(archive, archive2);
    }

    private String stripWsdlDir(String entry, BundleDescriptor bundle) {
        String wsdlDir = bundle.getWsdlDir();
        return entry.substring(wsdlDir.length() + 1);
    }

    private Set<WebService> getWebServiceDescriptors(Application app) {
        HashSet<WebService> webServiceDescriptors = new HashSet<WebService>();
        for (BundleDescriptor next : app.getBundleDescriptors()) {
            WebServicesDescriptor webServicesDesc = next.getWebServices();
            webServiceDescriptors.addAll(webServicesDesc.getWebServices());
        }
        return webServiceDescriptors;
    }

    private static void mkDirs(File f) {
        if (!f.mkdirs() && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AS-WSJSR109IMPL-00093", f);
        }
    }

    private static void mkFile(File f) throws IOException {
        if (!f.createNewFile() && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AS-WSJSR109IMPL-00092", f);
        }
    }
}

