/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.connect;

import com.jcraft.jsch.JSchException;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.hk2.api.ServiceLocator;

public class NodeRunnerSsh {
    private static final String NL = System.getProperty("line.separator");
    private ServiceLocator habitat;
    private Logger logger;
    private String lastCommandRun = null;
    private int commandStatus;
    private SSHLauncher sshL = null;

    public NodeRunnerSsh(ServiceLocator habitat, Logger logger) {
        this.logger = logger;
        this.habitat = habitat;
    }

    public boolean isSshNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        if (node.getType() == null) {
            return false;
        }
        return node.getType().equals("SSH");
    }

    String getLastCommandRun() {
        return this.lastCommandRun;
    }

    public int runAdminCommandOnRemoteNode(Node node, StringBuilder output, List<String> args, List<String> stdinLines) throws SSHCommandExecutionException, IllegalArgumentException, UnsupportedOperationException {
        args.add(0, "--_auxinput");
        args.add(1, "-");
        if (!this.isSshNode(node)) {
            throw new UnsupportedOperationException("Node is not of type SSH");
        }
        String installDir = node.getInstallDirUnixStyle() + "/" + SystemPropertyConstants.getComponentName();
        if (!StringUtils.ok((String)installDir)) {
            throw new IllegalArgumentException("Node does not have an installDir");
        }
        ArrayList<String> fullcommand = new ArrayList<String>();
        fullcommand.add(installDir + "/lib/nadmin");
        fullcommand.addAll(args);
        try {
            this.lastCommandRun = this.commandListToString(fullcommand);
            this.trace("Running command on " + node.getNodeHost() + ": " + this.lastCommandRun);
            this.sshL = (SSHLauncher)this.habitat.getService(SSHLauncher.class, new Annotation[0]);
            this.sshL.init(node, this.logger);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.commandStatus = this.sshL.runCommand(fullcommand, (OutputStream)outStream, stdinLines);
            output.append(outStream.toString());
            return this.commandStatus;
        }
        catch (JSchException | IOException ex) {
            String m1 = " Command execution failed. " + ex.getMessage();
            String m2 = "";
            Throwable e2 = ex.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command execution failed for " + this.lastCommandRun);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat((String)":", (String[])new String[]{m1, m2}));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.lastCommandRun);
            throw cee;
        }
        catch (InterruptedException ei) {
            ei.printStackTrace();
            String m1 = ei.getMessage();
            String m2 = "";
            Throwable e2 = ei.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command interrupted " + this.lastCommandRun);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat((String)":", (String[])new String[]{m1, m2}));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.lastCommandRun);
            throw cee;
        }
    }

    private void trace(String s) {
        this.logger.fine(String.format("%s: %s", this.getClass().getSimpleName(), s));
    }

    private String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

