/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.utility.filter;

import org.eclipse.persistence.jpa.jpql.tools.utility.filter.CompoundFilter;
import org.eclipse.persistence.jpa.jpql.utility.filter.Filter;
import org.eclipse.persistence.jpa.jpql.utility.filter.NullFilter;

public class AndFilter<T>
extends CompoundFilter<T> {
    private static final long serialVersionUID = 1L;

    public AndFilter(Filter<T> filter1, Filter<T> filter2) {
        super(filter1, filter2);
    }

    public static <T> Filter<T> and(Filter<T> ... filters) {
        int length = filters.length;
        if (length == 0) {
            return NullFilter.instance();
        }
        if (length == 1) {
            return filters[0];
        }
        AndFilter<T> filter = new AndFilter<T>(filters[0], filters[1]);
        for (int index = 2; index < length; ++index) {
            filter = new AndFilter<T>(filter, filters[index]);
        }
        return filter;
    }

    @Override
    public boolean accept(T value) {
        return this.filter1.accept(value) && this.filter2.accept(value);
    }

    @Override
    public AndFilter<T> clone() {
        return (AndFilter)super.clone();
    }

    @Override
    protected String operatorString() {
        return "AND";
    }
}

