/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ObjStorePasswdDialog
extends AdminDialog {
    private static final long serialVersionUID = -7799138711805026864L;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private ObjStore os;
    private JTextField principalText;
    private JTextField credentialsText;
    private Vector missingInfo;

    public ObjStorePasswdDialog(Frame parent) {
        super(parent, acr.getString("A1140"), 81);
        this.setHelpId("conndis_object_store");
    }

    public ObjStorePasswdDialog(Frame parent, int whichButtons) {
        super(parent, acr.getString("A1140"), whichButtons);
        this.setHelpId("conndis_object_store");
    }

    @Override
    public JPanel createWorkPanel() {
        JPanel workPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        workPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        LabelledComponent[] items = new LabelledComponent[2];
        this.principalText = new JTextField(20);
        this.principalText.addActionListener(this);
        items[0] = new LabelledComponent("java.naming.security.principal:", this.principalText);
        this.credentialsText = new JPasswordField(20);
        this.credentialsText.addActionListener(this);
        items[1] = new LabelledComponent("java.naming.security.credentials:", this.credentialsText);
        LabelValuePanel lvp = new LabelValuePanel(items, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        gridbag.setConstraints(lvp, c);
        workPanel.add(lvp);
        return workPanel;
    }

    @Override
    public void doOK() {
        String principalValue = this.principalText.getText().trim();
        if (principalValue.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3001", "java.naming.security.principal"), acr.getString("A1140"), 0, 0, null, close, close[0]);
            this.principalText.requestFocus();
            return;
        }
        String credentialsValue = this.credentialsText.getText().trim();
        if (credentialsValue.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3001", "java.naming.security.credentials"), acr.getString("A1140"), 0, 0, null, close, close[0]);
            this.credentialsText.requestFocus();
            return;
        }
        ObjStoreAttrs osa = this.os.getObjStoreAttrs();
        if (!osa.containsKey("java.naming.security.principal")) {
            this.os.addObjStoreAttr("java.naming.security.principal", principalValue);
        }
        if (!osa.containsKey("java.naming.security.credentials")) {
            this.os.addObjStoreAttr("java.naming.security.credentials", credentialsValue);
        }
        ObjAdminEvent oae = new ObjAdminEvent(this, 8);
        oae.setObjStore(this.os);
        oae.setObjStoreAttrs(osa);
        oae.setMissingAuthInfo(this.missingInfo);
        oae.setOKAction(true);
        this.fireAdminEventDispatched(oae);
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doCancel() {
        this.setVisible(false);
    }

    @Override
    public void doClose() {
        this.setVisible(false);
    }

    @Override
    public void doClear() {
        this.principalText.setText("");
        this.credentialsText.setText("");
    }

    public void show(ObjStore os, Vector missingInfo) {
        this.os = os;
        this.missingInfo = missingInfo;
        this.doClear();
        ObjStoreAttrs osa = os.getObjStoreAttrs();
        if (osa.containsKey("java.naming.security.credentials")) {
            this.credentialsText.setText((String)osa.get("java.naming.security.credentials"));
        } else {
            this.credentialsText.requestFocus();
        }
        if (osa.containsKey("java.naming.security.principal")) {
            this.principalText.setText((String)osa.get("java.naming.security.principal"));
        } else {
            this.principalText.requestFocus();
        }
        this.setDefaultButton(1);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.principalText) {
            this.credentialsText.requestFocus();
        } else if (ev.getSource() == this.credentialsText) {
            this.doOK();
        } else {
            super.actionPerformed(ev);
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

