/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.migration.archiver.serializer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.dbschema.migration.archiver.MapClassName;

public class XMLGraphSerializer {
    private BufferedWriter outStream;
    private int indentLevel;
    private boolean indent = true;
    private HashMap ObjectMap = new HashMap();
    private static String indentChar = "  ";
    private static String startTag = "<";
    private static String endTagNL = ">\n";
    private static String endTag = ">";
    private static String endEmptyTagNL = "/>\n";
    private static String endEmptyTag = "/>";
    private static String objectTag = "OBJECT";
    private static String arrayTag = "ARRAY";
    private static String rowTag = "ROW";
    private static String classAttrib = "CLASS";
    private static String IDAttrib = "ID";
    private static String refAttrib = "REFERENCE";
    private static String rowAttrib = "ROW";
    private static String rowClassAttrib = "ROWCLASS";
    private static String sizeAttrib = "SIZE";
    private static String primitiveArray = "PRIMITIVE";
    private static String startCDATA = "<![CDATA[";
    private static String endCDATA = "]]>";
    private static final String encoding = "UTF-8";

    private XMLGraphSerializer() {
    }

    public XMLGraphSerializer(OutputStream outStream) {
        this();
        try {
            this.outStream = new BufferedWriter(new OutputStreamWriter(outStream, encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Problems creating OutputStreamWriter: " + ex);
        }
    }

    private String getObjectName(Object obj) {
        StringBuffer lNameBuffer = new StringBuffer();
        lNameBuffer.append(obj.getClass().getName());
        lNameBuffer.append(obj.hashCode());
        int fixedLength = lNameBuffer.length();
        int index = 0;
        while (true) {
            String name;
            Object mapObj;
            lNameBuffer.setLength(fixedLength);
            if (index > 0) {
                lNameBuffer.append('#');
                lNameBuffer.append(index);
            }
            if ((mapObj = this.ObjectMap.get(name = lNameBuffer.toString())) == null || mapObj == obj) {
                return name;
            }
            ++index;
        }
    }

    private void writeLevel(String value) throws IOException {
        if (this.indent) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.outStream.write(indentChar);
            }
        }
        this.outStream.write(value);
    }

    private void writeLevel(char[] value) throws IOException {
        if (this.indent) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.outStream.write(indentChar);
            }
        }
        this.outStream.write(value);
    }

    private void writeCDATA(String value) throws IOException {
        this.outStream.write(startCDATA);
        this.outStream.write(value);
        this.outStream.write(endCDATA);
    }

    private boolean recordObject(Object obj) {
        boolean lObjectRecordedAlready = false;
        String lObjectName = this.getObjectName(obj);
        if (!this.ObjectMap.containsKey(lObjectName)) {
            this.ObjectMap.put(lObjectName, obj);
        } else {
            lObjectRecordedAlready = true;
        }
        return lObjectRecordedAlready;
    }

    private void addAttribute(String attributeName, String attributeValue, StringBuffer tag) {
        if (tag.length() > 0) {
            tag.append(' ');
        }
        tag.append(attributeName);
        tag.append('=');
        tag.append('\"');
        tag.append(attributeValue);
        tag.append('\"');
    }

    private boolean needsCDATA(String value) {
        boolean lNeedsCDATA = false;
        int lStringLength = value.length();
        for (int i = 0; i < lStringLength; ++i) {
            char lChar = value.charAt(i);
            if (lChar != '<' && lChar != '>' && lChar != '&') continue;
            lNeedsCDATA = true;
            break;
        }
        return lNeedsCDATA;
    }

    public void DumpStatus() {
        System.out.println("Dumping state information for XMLGraphSerializer");
        System.out.println("Object Map contains ");
        for (Object lNext : this.ObjectMap.values()) {
            System.out.println("Object Map contains object or class " + lNext.getClass().getName());
            System.out.println("Object state is " + lNext.toString());
        }
        System.out.println("Dumping state information for XMLGraphSerializer - END");
    }

    private void putStartTag(String tag, String elements, boolean empty, boolean newLine) throws IOException {
        this.writeLevel(startTag);
        this.outStream.write(tag);
        if (elements != null) {
            this.outStream.write(32);
            this.outStream.write(elements);
        }
        if (empty) {
            if (newLine) {
                this.outStream.write(endEmptyTagNL);
            } else {
                this.outStream.write(endEmptyTag);
            }
        } else {
            if (newLine) {
                this.outStream.write(endTagNL);
            } else {
                this.outStream.write(endTag);
            }
            if (this.indent) {
                ++this.indentLevel;
            }
        }
    }

    private void putEndTag(String tag, boolean doIndent) throws IOException {
        if (this.indent) {
            --this.indentLevel;
        }
        if (this.indent && doIndent) {
            this.writeLevel("</");
        } else {
            this.outStream.write("</");
        }
        this.outStream.write(tag);
        this.outStream.write(">\n");
    }

    private void xlateObject(Object obj) throws IOException, IllegalAccessException {
        try {
            if (obj == null) {
                this.putStartTag(objectTag, null, true, true);
            } else if (obj instanceof String || obj instanceof StringBuffer) {
                this.xlateString(null, obj);
            } else if (this.recordObject(obj)) {
                this.xlateObjectReference(obj);
            } else {
                int i;
                Class<?> lClassType = obj.getClass();
                StringBuffer lClassAttributes = new StringBuffer();
                this.addAttribute(classAttrib, MapClassName.getClassNameToken(lClassType.getName()), lClassAttributes);
                this.addAttribute(IDAttrib, this.getObjectName(obj), lClassAttributes);
                this.putStartTag(objectTag, lClassAttributes.toString(), false, true);
                HashMap<String, Field> lFieldsMap = new HashMap<String, Field>();
                Field[] lTFields = null;
                for (Class<?> lClass = lClassType; lClass != null; lClass = lClass.getSuperclass()) {
                    lTFields = lClass.getDeclaredFields();
                    for (i = 0; i < lTFields.length; ++i) {
                        if (lFieldsMap.containsKey(lTFields[i].getName())) continue;
                        lFieldsMap.put(lTFields[i].getName(), lTFields[i]);
                    }
                }
                ArrayList lFields = new ArrayList(lFieldsMap.values());
                for (i = 0; i < lFields.size(); ++i) {
                    Field lCurrentField = (Field)lFields.get(i);
                    if (Modifier.isTransient(lCurrentField.getModifiers()) || Modifier.isStatic(lCurrentField.getModifiers())) continue;
                    Class<?> lCurrentFieldType = lCurrentField.getType();
                    lCurrentField.setAccessible(true);
                    Object lRealValue = lCurrentField.get(obj);
                    String lFieldName = lCurrentField.getName();
                    if (lRealValue != null) {
                        if (lCurrentFieldType.isPrimitive()) {
                            this.xlatePrimitive(lFieldName, lRealValue);
                            continue;
                        }
                        if (lRealValue instanceof String || lRealValue instanceof StringBuffer) {
                            this.xlateString(lFieldName, lRealValue);
                            continue;
                        }
                        if (lCurrentFieldType.isArray()) {
                            this.xlateArray(lFieldName, lRealValue);
                            continue;
                        }
                        if (lRealValue instanceof Collection) {
                            this.xlateCollection(lFieldName, lRealValue);
                            continue;
                        }
                        this.putStartTag(lFieldName, null, false, true);
                        this.xlateObject(lRealValue);
                        this.putEndTag(lFieldName, true);
                        continue;
                    }
                    this.putStartTag(lFieldName, null, false, true);
                    this.putStartTag(objectTag, null, true, true);
                    this.putEndTag(lFieldName, true);
                }
                this.putEndTag(objectTag, true);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.DumpStatus();
            System.out.println("IO Exception in XLateObject current object class " + obj.getClass().getName());
            System.out.println("IO Exception in XLateObject current object is " + obj);
            this.outStream.close();
            throw e1;
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
            this.DumpStatus();
            System.out.println("IO Exception in XLateObject current object class " + obj.getClass().getName());
            System.out.println("IO Exception in XLateObject current object is " + obj);
            this.outStream.close();
            throw e2;
        }
        catch (RuntimeException e3) {
            e3.printStackTrace();
            this.DumpStatus();
            System.out.println("IO Exception in XLateObject current object class " + obj.getClass().getName());
            System.out.println("IO Exception in XLateObject current object is " + obj);
            this.outStream.close();
            throw e3;
        }
    }

    private void xlateObjectReference(Object obj) throws IOException {
        StringBuffer lReferenceAttributes = new StringBuffer();
        this.addAttribute(refAttrib, this.getObjectName(obj), lReferenceAttributes);
        this.putStartTag(objectTag, lReferenceAttributes.toString(), true, true);
    }

    private void xlatePrimitive(String name, Object obj) throws IOException {
        Class<?> lType = obj.getClass();
        String lValue = obj.toString();
        this.putStartTag(name, null, false, false);
        if (lType == Character.TYPE) {
            if (this.needsCDATA(lValue)) {
                this.writeCDATA(lValue);
            } else {
                this.outStream.write(lValue);
            }
        } else {
            this.outStream.write(lValue);
        }
        this.putEndTag(name, false);
    }

    private void xlateString(String name, Object obj) throws IOException {
        String lValue;
        if (name != null) {
            this.putStartTag(name, null, false, false);
        }
        if (this.needsCDATA(lValue = obj.toString())) {
            this.writeCDATA(lValue);
        } else {
            this.outStream.write(lValue);
        }
        if (name != null) {
            this.putEndTag(name, false);
        }
    }

    private void xlateArray(String name, Object obj) throws IOException, IllegalAccessException {
        StringBuffer lArrayAttributes = new StringBuffer();
        int lArraySize = Array.getLength(obj);
        this.addAttribute(sizeAttrib, Integer.toString(lArraySize), lArrayAttributes);
        this.addAttribute(classAttrib, primitiveArray, lArrayAttributes);
        this.addAttribute(rowClassAttrib, MapClassName.getClassNameToken(obj.getClass().getComponentType().getName()), lArrayAttributes);
        this.putStartTag(name, null, false, true);
        this.putStartTag(arrayTag, lArrayAttributes.toString(), false, true);
        for (int i = 0; i < lArraySize; ++i) {
            Object lRow = Array.get(obj, i);
            if (lRow instanceof String || lRow instanceof Number || lRow instanceof Character || lRow instanceof Boolean) {
                this.xlateSimpleRow(i, lRow);
                continue;
            }
            StringBuffer lRowAttributes = new StringBuffer();
            this.addAttribute(rowAttrib, Integer.toString(i), lRowAttributes);
            this.putStartTag(rowTag, lRowAttributes.toString(), false, true);
            this.xlateObject(lRow);
            this.putEndTag(rowTag, true);
        }
        this.putEndTag(arrayTag, true);
        this.putEndTag(name, true);
    }

    private void xlateCollection(String name, Object obj) throws IOException, IllegalAccessException {
        StringBuffer lArrayAttributes = new StringBuffer();
        Collection lArray = (Collection)obj;
        int lArraySize = lArray.size();
        this.addAttribute(sizeAttrib, Integer.toString(lArraySize), lArrayAttributes);
        this.addAttribute(classAttrib, lArray.getClass().getName(), lArrayAttributes);
        this.addAttribute(rowClassAttrib, "", lArrayAttributes);
        this.putStartTag(name, null, false, true);
        this.putStartTag(arrayTag, lArrayAttributes.toString(), false, true);
        Iterator lIterator = lArray.iterator();
        int lRowCount = 0;
        while (lIterator.hasNext()) {
            Object lRow = lIterator.next();
            if (lRow instanceof String || lRow instanceof Number || lRow instanceof Character || lRow instanceof Boolean) {
                this.xlateSimpleRow(lRowCount, lRow);
            } else {
                StringBuffer lRowAttributes = new StringBuffer();
                this.addAttribute(rowAttrib, Integer.toString(lRowCount), lRowAttributes);
                this.putStartTag(rowTag, lRowAttributes.toString(), false, true);
                this.xlateObject(lRow);
                this.putEndTag(rowTag, true);
            }
            ++lRowCount;
        }
        this.putEndTag(arrayTag, true);
        this.putEndTag(name, true);
    }

    private void xlateSimpleRow(int rowNumber, Object obj) throws IOException {
        StringBuffer lRowAttributes = new StringBuffer();
        this.addAttribute(rowAttrib, Integer.toString(rowNumber), lRowAttributes);
        Class<?> lObjectClass = obj.getClass();
        if (lObjectClass.isPrimitive()) {
            if (lObjectClass == Integer.TYPE) {
                this.addAttribute("ROWCLASS", "int", lRowAttributes);
            } else if (lObjectClass == Short.TYPE) {
                this.addAttribute("ROWCLASS", "short", lRowAttributes);
            } else if (lObjectClass == Long.TYPE) {
                this.addAttribute("ROWCLASS", "long", lRowAttributes);
            } else if (lObjectClass == Float.TYPE) {
                this.addAttribute("ROWCLASS", "float", lRowAttributes);
            } else if (lObjectClass == Double.TYPE) {
                this.addAttribute("ROWCLASS", "double", lRowAttributes);
            } else if (lObjectClass == Boolean.TYPE) {
                this.addAttribute("ROWCLASS", "boolean", lRowAttributes);
            } else if (lObjectClass == Character.TYPE) {
                this.addAttribute("ROWCLASS", "char", lRowAttributes);
            } else {
                this.addAttribute("ROWCLASS", "unknown", lRowAttributes);
            }
        } else {
            this.addAttribute("ROWCLASS", MapClassName.getClassNameToken(lObjectClass.getName()), lRowAttributes);
        }
        this.addAttribute("VALUE", obj.toString(), lRowAttributes);
        this.putStartTag(rowTag, lRowAttributes.toString(), true, true);
    }

    public void writeObject(Object obj) throws IOException {
        try {
            this.outStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n\n");
            this.xlateObject(obj);
            this.outStream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.DumpStatus();
            try {
                this.outStream.close();
            }
            catch (IOException lNotClosed) {
                // empty catch block
            }
            throw e1;
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
            this.DumpStatus();
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

