/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.security.SecurityClassLoad;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.JspServletWrapper;

public final class JspRuntimeContext
implements Runnable {
    private static Logger log = Logger.getLogger(JspRuntimeContext.class.getName());
    private AtomicInteger jspReloadCount = new AtomicInteger(0);
    private ServletContext context;
    private Options options;
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;
    private String classpath;
    private Map<String, JspServletWrapper> jsps;
    private Map<String, byte[]> bytecodes;
    private Map<String, Long> bytecodeBirthTimes;
    private Map<String, Map<String, JavaFileObject>> packageMap;
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "JspRuntimeContext";

    public JspRuntimeContext(ServletContext context, Options options) {
        this.context = context;
        this.options = options;
        int hashSize = options.getInitialCapacity();
        this.jsps = new ConcurrentHashMap<String, JspServletWrapper>(hashSize);
        this.bytecodes = new ConcurrentHashMap<String, byte[]>(hashSize);
        this.bytecodeBirthTimes = new ConcurrentHashMap<String, Long>(hashSize);
        this.packageMap = new ConcurrentHashMap<String, Map<String, JavaFileObject>>();
        if (log.isLoggable(Level.FINEST)) {
            ClassLoader parentClassLoader = this.getParentClassLoader();
            if (parentClassLoader != null) {
                log.finest(Localizer.getMessage("jsp.message.parent_class_loader_is", parentClassLoader.toString()));
            } else {
                log.finest(Localizer.getMessage("jsp.message.parent_class_loader_is", "<none>"));
            }
        }
        this.initClassPath();
        if (context instanceof JspCServletContext) {
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            this.initSecurity();
        }
        String appBase = context.getRealPath("/");
        if (!options.getDevelopment() && appBase != null && options.getCheckInterval() > 0 && !options.getUsePrecompiled()) {
            if (appBase.endsWith(File.separator)) {
                appBase = appBase.substring(0, appBase.length() - 1);
            }
            String directory = appBase.substring(appBase.lastIndexOf(File.separator));
            this.threadName = this.threadName + "[" + directory + "]";
            this.threadStart();
        }
    }

    public void addWrapper(String jspUri, JspServletWrapper jsw) {
        this.jsps.remove(jspUri);
        this.jsps.put(jspUri, jsw);
    }

    public JspServletWrapper getWrapper(String jspUri) {
        return this.jsps.get(jspUri);
    }

    public void removeWrapper(String jspUri) {
        this.jsps.remove(jspUri);
    }

    public int getJspCount() {
        return this.jsps.size();
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public ClassLoader getParentClassLoader() {
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        if (parentClassLoader == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        return parentClassLoader;
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void destroy() {
        this.threadStop();
        for (JspServletWrapper jsw : this.jsps.values()) {
            jsw.destroy();
        }
    }

    public void incrementJspReloadCount() {
        this.jspReloadCount.incrementAndGet();
    }

    public void setJspReloadCount(int count) {
        this.jspReloadCount.set(count);
    }

    public int getJspReloadCount() {
        return this.jspReloadCount.get();
    }

    public void setBytecode(String name, byte[] bytecode) {
        if (bytecode == null) {
            this.bytecodes.remove(name);
            this.bytecodeBirthTimes.remove(name);
            return;
        }
        this.bytecodes.put(name, bytecode);
        this.bytecodeBirthTimes.put(name, System.currentTimeMillis());
    }

    public void adjustBytecodeTime(String name, long reference) {
        Long time = this.bytecodeBirthTimes.get(name);
        if (time == null) {
            return;
        }
        if (time < reference) {
            this.bytecodeBirthTimes.put(name, reference);
        }
    }

    public Map<String, byte[]> getBytecodes() {
        return this.bytecodes;
    }

    public byte[] getBytecode(String name) {
        return this.bytecodes.get(name);
    }

    public long getBytecodeBirthTime(String name) {
        Long time = this.bytecodeBirthTimes.get(name);
        return time != null ? time : 0L;
    }

    public Map<String, Map<String, JavaFileObject>> getPackageMap() {
        return this.packageMap;
    }

    public void saveBytecode(String className, String classFileName) {
        byte[] bytecode = this.getBytecode(className);
        if (bytecode != null) {
            try {
                FileOutputStream fos = new FileOutputStream(classFileName);
                fos.write(bytecode);
                fos.close();
            }
            catch (IOException ex) {
                this.context.log("Error in saving bytecode for " + className + " to " + classFileName, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCompile() {
        for (JspServletWrapper jsw : this.jsps.values()) {
            if (jsw.isTagFile()) continue;
            JspCompilationContext ctxt = jsw.getJspEngineContext();
            JspServletWrapper jspServletWrapper = jsw;
            synchronized (jspServletWrapper) {
                try {
                    ctxt.compile();
                }
                catch (FileNotFoundException ex) {
                    ctxt.incrementRemoved();
                }
                catch (Throwable t) {
                    jsw.getServletContext().log(Localizer.getMessage("jsp.error.background.compile"), t);
                }
            }
        }
    }

    public String getClassPath() {
        return this.classpath;
    }

    private void initClassPath() {
        block5: {
            StringBuilder cpath = new StringBuilder();
            String sep = System.getProperty("path.separator");
            cpath.append(this.options.getScratchDir() + sep);
            String cp = (String)this.context.getAttribute("org.apache.catalina.jsp_classpath");
            if (cp == null || cp.equals("")) {
                cp = this.options.getClassPath();
            }
            if (cp != null) {
                this.classpath = cpath.toString() + cp;
            }
            if (this.classpath != null) {
                try {
                    this.classpath = URLDecoder.decode(this.classpath, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (!log.isLoggable(Level.FINE)) break block5;
                    log.log(Level.FINE, "Exception decoding classpath : " + this.classpath, e);
                }
            }
        }
    }

    private void initSecurity() {
        Policy policy = Policy.getPolicy();
        if (policy != null) {
            try {
                String codeBase;
                String docBase = this.context.getRealPath("/");
                if (docBase == null) {
                    docBase = this.options.getScratchDir().toString();
                }
                if (!(codeBase = docBase).endsWith(File.separator)) {
                    codeBase = codeBase + File.separator;
                }
                File contextDir = new File(codeBase);
                URL url = contextDir.getCanonicalFile().toURL();
                this.codeSource = new CodeSource(url, (Certificate[])null);
                this.permissionCollection = policy.getPermissions(this.codeSource);
                if (!docBase.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(docBase, "read"));
                    docBase = docBase + File.separator;
                } else {
                    this.permissionCollection.add(new FilePermission(docBase.substring(0, docBase.length() - 1), "read"));
                }
                docBase = docBase + "-";
                this.permissionCollection.add(new FilePermission(docBase, "read"));
                String workDir = this.options.getScratchDir().toString();
                if (!workDir.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(workDir, "read"));
                    workDir = workDir + File.separator;
                }
                workDir = workDir + "-";
                this.permissionCollection.add(new FilePermission(workDir, "read"));
                this.permissionCollection.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                ClassLoader parentClassLoader = this.getParentClassLoader();
                if (parentClassLoader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)parentClassLoader).getURLs();
                    String jarUrl = null;
                    String jndiUrl = null;
                    for (int i = 0; i < urls.length; ++i) {
                        if (jndiUrl == null && urls[i].toString().startsWith("jndi:")) {
                            jndiUrl = urls[i].toString() + "-";
                        }
                        if (jarUrl != null || !urls[i].toString().startsWith("jar:jndi:")) continue;
                        jarUrl = urls[i].toString();
                        jarUrl = jarUrl.substring(0, jarUrl.length() - 2);
                        jarUrl = jarUrl.substring(0, jarUrl.lastIndexOf(47)) + "/-";
                    }
                    if (jarUrl != null) {
                        this.permissionCollection.add(new FilePermission(jarUrl, "read"));
                        this.permissionCollection.add(new FilePermission(jarUrl.substring(4), "read"));
                    }
                    if (jndiUrl != null) {
                        this.permissionCollection.add(new FilePermission(jndiUrl, "read"));
                    }
                }
            }
            catch (Exception e) {
                this.context.log("Security Init for context failed", (Throwable)e);
            }
        }
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.options.getCheckInterval() * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            try {
                this.checkCompile();
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.log(Level.SEVERE, Localizer.getMessage("jsp.error.recompile"), t);
            }
        }
    }

    static {
        JspFactoryImpl factory = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(((Object)((Object)factory)).getClass().getClassLoader());
        if (System.getSecurityManager() != null) {
            String basePackage = "org.apache.jasper.";
            try {
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "servlet.JspServletWrapper");
            }
            catch (ClassNotFoundException ex) {
                log.log(Level.SEVERE, "Jasper JspRuntimeContext preload of class failed: " + ex.getMessage(), ex);
            }
        }
        JspFactory.setDefaultFactory((JspFactory)factory);
    }
}

