/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.auth.handlers;

import com.sun.messaging.jmq.auth.api.client.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.util.MD5;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.security.auth.login.LoginException;

public class DigestAuthenticationHandler
implements AuthenticationProtocolHandler {
    private String username = null;
    private String password = null;

    @Override
    public String getType() {
        return "digest";
    }

    @Override
    public void init(String username, String password, Hashtable authProperties) throws LoginException {
        this.username = username;
        this.password = password;
    }

    @Override
    public byte[] handleRequest(byte[] authRequest, int sequence) throws LoginException {
        if (this.username == null || this.password == null) {
            throw new LoginException("null");
        }
        try {
            byte[] nonce = authRequest;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(this.username);
            String userpwd = MD5.getHashString(this.username + ":" + this.password);
            try {
                String credential = MD5.getHashString(userpwd + ":" + new String(nonce, "UTF8"));
                dos.writeUTF(credential);
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException(e.getMessage());
            }
            dos.flush();
            byte[] response = bos.toByteArray();
            dos.close();
            return response;
        }
        catch (IOException e) {
            throw new LoginException("IOException: " + e.getMessage());
        }
    }
}

