/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FelixPrettyPrinter {
    private static Pattern BUNDLE_PATTERN = Pattern.compile("\\[(\\d+)\\]", 8);

    public static String prettyPrintExceptionMessage(String message) {
        StringBuilder messageBuilder = new StringBuilder();
        int index = message.indexOf("Unable to resolve");
        int indent = 0;
        while (index >= 0) {
            FelixPrettyPrinter.printLn(messageBuilder, indent, "Unable to resolve");
            int index2 = message.indexOf("missing requirement", index += "Unable to resolve".length());
            if (index2 >= 0) {
                ++indent;
                String module = message.substring(index, index2);
                if (module.contains("(R")) {
                    module = module.substring(0, module.indexOf("(R"));
                }
                FelixPrettyPrinter.printLn(messageBuilder, indent, module);
                FelixPrettyPrinter.printLn(messageBuilder, indent, "missing requirement");
                index = index2 + "missing requirement".length();
                index = message.indexOf("osgi.wiring.package; ", index);
                if (index >= 0) {
                    ++indent;
                    index2 = message.indexOf(" ", index += "osgi.wiring.package; ".length());
                    String packageAndVersion = message.substring(index, index2);
                    packageAndVersion = packageAndVersion.replace("osgi.wiring.package", "package");
                    packageAndVersion = packageAndVersion.replace(")(", ") (");
                    packageAndVersion = packageAndVersion.replace("=", " = ");
                    packageAndVersion = packageAndVersion.replace("> =", " >=");
                    if ((packageAndVersion = packageAndVersion.replace("< =", " <=")).startsWith("(")) {
                        packageAndVersion = packageAndVersion.substring(1);
                    }
                    if (packageAndVersion.endsWith(")")) {
                        packageAndVersion = packageAndVersion.substring(0, packageAndVersion.length() - 1);
                    }
                    FelixPrettyPrinter.printLn(messageBuilder, indent, packageAndVersion);
                    index = message.indexOf("caused by: ", index2);
                    if (index >= 0) {
                        FelixPrettyPrinter.printLn(messageBuilder, indent, "caused by:");
                        ++indent;
                        index += "caused by: ".length();
                    }
                }
            }
            index = index2;
            index = message.indexOf("Unable to resolve", index);
        }
        return messageBuilder.toString();
    }

    public static List<Integer> findBundleIds(String message) {
        if (message == null || message.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<Integer> bundleIds = new LinkedHashSet<Integer>();
        Matcher bundlePattern = BUNDLE_PATTERN.matcher(message);
        while (bundlePattern.find()) {
            String number = bundlePattern.group(1);
            bundleIds.add(Integer.valueOf(number));
        }
        return new ArrayList<Integer>(bundleIds);
    }

    private static void printLn(StringBuilder messageBuilder, int indent, String message) {
        for (int i = 0; i < indent * 4; ++i) {
            messageBuilder.append(" ");
        }
        messageBuilder.append(message.trim()).append("\n");
    }

    public static void main(String[] args) {
        String test = "Caused by: org.osgi.framework.BundleException: Unable to resolve org.glassfish.server.internal.batch.glassfish-batch-connector [103](R 103.0): missing requirement [org.glassfish.server.internal.batch.glassfish-batch-connector [103](R 103.0)] osgi.wiring.package; (osgi.wiring.package=com.ibm.jbatch.spi) [caused by: Unable to resolve org.glassfish.server.internal.batch.payara-jbatch [325](R 325.0): missing requirement [org.glassfish.server.internal.batch.payara-jbatch [325](R 325.0)] osgi.wiring.package; (osgi.wiring.package=org.glassfish.weld) [caused by: Unable to resolve org.glassfish.server.internal.web.weld-integration [395](R 395.0): missing requirement [org.glassfish.server.internal.web.weld-integration [395](R 395.0)] osgi.wiring.package; (&(osgi.wiring.package=com.sun.faces.spi)(version>=2.3.0)(!(version>=3.0.0)))]] Unresolved requirements: [[org.glassfish.server.internal.batch.glassfish-batch-connector [103](R 103.0)] osgi.wiring.package; (osgi.wiring.package=com.ibm.jbatch.spi)]";
        String test1 = FelixPrettyPrinter.prettyPrintExceptionMessage(test);
        List<Integer> ids = FelixPrettyPrinter.findBundleIds(test1);
        String test2 = FelixPrettyPrinter.prettyPrintExceptionMessage(" (java.lang.String) Unable to resolve org.glassfish.jersey.containers.jersey-container-grizzly2-http [142](R 142.0): missing requirement [org.glassfish.jersey.containers.jersey-container-grizzly2-http [142](R 142.0)] osgi.wiring.package; (&(osgi.wiring.package=org.glassfish.grizzly)(version>=2.4.0)(!(version>=3.0.0))) Unresolved requirements: [[org.glassfish.jersey.containers.jersey-container-grizzly2-http [142](R 142.0)] osgi.wiring.package; (&(osgi.wiring.package=org.glassfish.grizzly)(version>=2.4.0)(!(version>=3.0.0)))]");
        System.out.println(test1);
        System.out.println(ids.toString());
        System.out.println("\n\n");
        System.out.println(test2);
    }
}

