/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.logging;

import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.resources.spi.ClassFileInfoException;

public class CommonLogger_$logger
extends DelegatingBasicLogger
implements CommonLogger,
WeldEnvironmentLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = CommonLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public CommonLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void couldNotReadResource(Object param1, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.couldNotReadResource$str(), param1);
    }

    protected String couldNotReadResource$str() {
        return "WELD-ENV-000002: Could not read resource with name: {0}";
    }

    @Override
    public final void unexpectedClassLoader(Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.unexpectedClassLoader$str(), new Object[0]);
    }

    protected String unexpectedClassLoader$str() {
        return "WELD-ENV-000004: Could not invoke JNLPClassLoader#getJarFile(URL) on context class loader, expecting Web Start class loader";
    }

    @Override
    public final void jnlpClassLoaderInternalException(Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.jnlpClassLoaderInternalException$str(), new Object[0]);
    }

    protected String jnlpClassLoaderInternalException$str() {
        return "WELD-ENV-000005: JNLPClassLoader#getJarFile(URL) threw exception";
    }

    @Override
    public final void jnlpClassLoaderInvocationException(Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.jnlpClassLoaderInvocationException$str(), new Object[0]);
    }

    protected String jnlpClassLoaderInvocationException$str() {
        return "WELD-ENV-000006: Could not invoke JNLPClassLoader#getJarFile(URL) on context class loader";
    }

    @Override
    public final void cannotHandleFilePath(Object file, Object path, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.cannotHandleFilePath$str(), file, path);
    }

    protected String cannotHandleFilePath$str() {
        return "WELD-ENV-000007: Error handling file path\n  File: {0}\n  Path: {1}";
    }

    @Override
    public final void couldNotOpenStreamForURL(Object param1, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.couldNotOpenStreamForURL$str(), param1);
    }

    protected String couldNotOpenStreamForURL$str() {
        return "WELD-ENV-000010: Could not open the stream on the url {0} when adding to the jandex index.";
    }

    @Override
    public final void couldNotCloseStreamForURL(Object param1, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.couldNotCloseStreamForURL$str(), param1);
    }

    protected String couldNotCloseStreamForURL$str() {
        return "WELD-ENV-000011: Could not close the stream on the url {0} when adding to the jandex index.";
    }

    protected String unableToLoadClass$str() {
        return "WELD-ENV-000012: Unable to load class {0}";
    }

    @Override
    public final ClassFileInfoException unableToLoadClass(Object param1) {
        ClassFileInfoException result = new ClassFileInfoException(this._formatMessage(this.unableToLoadClass$str(), param1));
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String undefinedBeanDiscoveryValue$str() {
        return "WELD-ENV-000013: beans.xml defines unrecognized bean-discovery-mode value: {0}";
    }

    @Override
    public final IllegalStateException undefinedBeanDiscoveryValue(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.undefinedBeanDiscoveryValue$str(), param1));
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void reflectionFallback() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.reflectionFallback$str(), new Object[0]);
    }

    protected String reflectionFallback$str() {
        return "WELD-ENV-000014: Falling back to Java Reflection for bean-discovery-mode=\"annotated\" discovery. Add org.jboss:jandex to the classpath to speed-up startup.";
    }

    protected String unableToLoadAnnotation$str() {
        return "WELD-ENV-000015: Unable to load annotation: {0}";
    }

    @Override
    public final ClassFileInfoException unableToLoadAnnotation(Object param1) {
        ClassFileInfoException result = new ClassFileInfoException(this._formatMessage(this.unableToLoadAnnotation$str(), param1));
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingBeansXml$str() {
        return "WELD-ENV-000016: Missing beans.xml file in META-INF";
    }

    @Override
    public final IllegalStateException missingBeansXml() {
        IllegalStateException result = new IllegalStateException(this.missingBeansXml$str());
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToResolveBean$str() {
        return "WELD-ENV-000018: Unable to resolve a bean for {0} with bindings {1}";
    }

    @Override
    public final UnsatisfiedResolutionException unableToResolveBean(Object param1, Object param2) {
        UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(this._formatMessage(this.unableToResolveBean$str(), param1, param2));
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jandexIndexNotCreated$str() {
        return "WELD-ENV-000019: Jandex index is null in the constructor of class: {0}";
    }

    @Override
    public final IllegalStateException jandexIndexNotCreated(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.jandexIndexNotCreated$str(), param1));
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void usingJandex() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.usingJandex$str(), new Object[0]);
    }

    protected String usingJandex$str() {
        return "WELD-ENV-000020: Using jandex for bean discovery";
    }

    @Override
    public final void archiveIsolationDisabled() {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.archiveIsolationDisabled$str(), new Object[0]);
    }

    protected String archiveIsolationDisabled$str() {
        return "WELD-ENV-000023: Archive isolation disabled - only one bean archive will be created";
    }

    @Override
    public final void archiveIsolationEnabled() {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.archiveIsolationEnabled$str(), new Object[0]);
    }

    protected String archiveIsolationEnabled$str() {
        return "WELD-ENV-000024: Archive isolation enabled - creating multiple isolated bean archives if needed";
    }

    protected String indexForNameNotFound$str() {
        return "WELD-ENV-000025: Index for name: {0} not found.";
    }

    @Override
    public final ClassFileInfoException indexForNameNotFound(Object param1) {
        ClassFileInfoException result = new ClassFileInfoException(this._formatMessage(this.indexForNameNotFound$str(), param1));
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInstantiate$str() {
        return "WELD-ENV-000026: Unable to instantiate {0} using parameters: {1}.";
    }

    @Override
    public final IllegalStateException unableToInstantiate(Object param1, Object param2, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unableToInstantiate$str(), param1, param2), cause);
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void initSkippedNoBeanArchiveFound() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.initSkippedNoBeanArchiveFound$str(), new Object[0]);
    }

    protected String initSkippedNoBeanArchiveFound$str() {
        return "WELD-ENV-000028: Weld initialization skipped - no bean archive found";
    }

    protected String cannotLoadClass$str() {
        return "WELD-ENV-000029: Cannot load class for {0}.";
    }

    @Override
    public final IllegalStateException cannotLoadClass(Object param1, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.cannotLoadClass$str(), param1), cause);
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotLoadClassUsingResourceLoader(String className) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.cannotLoadClassUsingResourceLoader$str(), (Object)className);
    }

    protected String cannotLoadClassUsingResourceLoader$str() {
        return "WELD-ENV-000030: Cannot load class using the ResourceLoader: {0}";
    }

    @Override
    public final void beanArchiveReferenceCannotBeHandled(Object beanArchiveRef, Object handlers) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.beanArchiveReferenceCannotBeHandled$str(), beanArchiveRef, handlers);
    }

    protected String beanArchiveReferenceCannotBeHandled$str() {
        return "WELD-ENV-000031: The bean archive reference {0} cannot be handled by any BeanArchiveHandler: {1}";
    }

    @Override
    public final void processingBeanArchiveReference(Object beanArchiveRef) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.processingBeanArchiveReference$str(), beanArchiveRef);
    }

    protected String processingBeanArchiveReference$str() {
        return "WELD-ENV-000032: Processing bean archive reference: {0}";
    }

    protected String invalidScanningResult$str() {
        return "WELD-ENV-000033: Invalid bean archive scanning result - found multiple results with the same reference: {0}";
    }

    @Override
    public final IllegalStateException invalidScanningResult(Object beanArchiveRef) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidScanningResult$str(), beanArchiveRef));
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotScanClassPathEntry$str() {
        return "WELD-ENV-000034: Cannot scan class path entry: {0}";
    }

    @Override
    public final IllegalStateException cannotScanClassPathEntry(Object entry, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.cannotScanClassPathEntry$str(), entry), cause);
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotReadClassPathEntry$str() {
        return "WELD-ENV-000035: Class path entry does not exist or cannot be read: {0}";
    }

    @Override
    public final IllegalStateException cannotReadClassPathEntry(Object entry) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.cannotReadClassPathEntry$str(), entry));
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotReadJavaClassPathSystemProperty$str() {
        return "WELD-ENV-000036: Weld cannot read the java class path system property!";
    }

    @Override
    public final IllegalStateException cannotReadJavaClassPathSystemProperty() {
        IllegalStateException result = new IllegalStateException(this.cannotReadJavaClassPathSystemProperty$str());
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInitializeProbeComponent$str() {
        return "WELD-ENV-000037: Unable to initialize the Probe component: {0}";
    }

    @Override
    public final IllegalStateException unableToInitializeProbeComponent(Object component, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unableToInitializeProbeComponent$str(), component), cause);
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String probeComponentNotFoundOnClasspath$str() {
        return "WELD-ENV-000038: Development mode is enabled but the following Probe component is not found on the classpath: {0}";
    }

    @Override
    public final IllegalStateException probeComponentNotFoundOnClasspath(Object component) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.probeComponentNotFoundOnClasspath$str(), component));
        CommonLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void beanArchiveReferenceHandled(Object beanArchiveRef, Object handler) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.beanArchiveReferenceHandled$str(), beanArchiveRef, handler);
    }

    protected String beanArchiveReferenceHandled$str() {
        return "WELD-ENV-000039: Bean archive reference {0} handled by {1}";
    }

    @Override
    public final void jandexDiscoveryStrategyDisabled() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.jandexDiscoveryStrategyDisabled$str(), new Object[0]);
    }

    protected String jandexDiscoveryStrategyDisabled$str() {
        return "WELD-ENV-000040: Jandex discovery strategy was disabled.";
    }

    @Override
    public final void usingServiceLoaderSourcedDiscoveryStrategy(Object discoveryStrategy) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.usingServiceLoaderSourcedDiscoveryStrategy$str(), discoveryStrategy);
    }

    protected String usingServiceLoaderSourcedDiscoveryStrategy$str() {
        return "WELD-ENV-000041: Using {0} for bean discovery";
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }

    @Override
    public final void catchingTrace(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.TRACE, throwable, this.catchingTrace$str(), new Object[0]);
    }

    protected String catchingTrace$str() {
        return "Catching";
    }
}

