/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.memory.MemoryGlobals;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class ProducerHandler
extends PacketHandler {
    private DestinationList DL = Globals.getDestinationList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Hashtable<String, Object> returnprop;
        Packet reply;
        block34: {
            block33: {
                reply = new Packet(con.useDirectBuffers());
                reply.setPacketType(msg.getPacketType() + 1);
                reply.setConsumerID(msg.getConsumerID());
                boolean isIndemp = msg.getIndempotent();
                int status = 200;
                Object reason = null;
                Hashtable props = null;
                try {
                    props = msg.getProperties();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Can not load props", ex);
                }
                returnprop = new Hashtable<String, Object>();
                Destination d = null;
                try {
                    if (msg.getPacketType() == 18) {
                        SessionUID sessionID;
                        Session session;
                        String dest = (String)props.get("JMQDestination");
                        Integer type = (Integer)props.get("JMQDestType");
                        if (!con.isAdminConnection() && MemoryGlobals.getMEM_DISALLOW_PRODUCERS()) {
                            status = 500;
                            reason = "Low memory";
                            this.logger.log(16, "B2076");
                            throw new BrokerException((String)reason, status);
                        }
                        Long lsessionid = (Long)props.get("JMQSessionID");
                        if (lsessionid != null && (session = con.getSession(sessionID = new SessionUID(lsessionid))) == null) {
                            throw new BrokerException("Internal Error: client sent invalid sessionUID w/ ADD_PRODUCER " + sessionID + " session does not exist");
                        }
                        Destination[] ds = null;
                        DestinationUID duid = null;
                        if (dest != null && !DestinationUID.isWildcard(dest) && type != null) {
                            while (true) {
                                ds = DestinationList.getDestination(con.getPartitionedStore(), dest, (int)type, true, !con.isAdminConnection());
                                d = ds[0];
                                if (d == null) break;
                                try {
                                    d.incrementRefCount();
                                }
                                catch (BrokerException ex) {
                                    continue;
                                }
                                catch (IllegalStateException ex) {
                                    throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140", ex, 500);
                                }
                                break;
                            }
                            if (d == null) {
                                this.logger.log(4, "Unable to add producer to " + dest + " :" + DestType.toString((int)type) + " destination can not be autocreated ");
                                reason = "can not create destination";
                                status = 404;
                                throw new BrokerException((String)reason, status);
                            }
                            duid = d.getDestinationUID();
                        } else {
                            if (dest == null || type == null) {
                                reason = "no destination passed [dest,type] = [" + dest + "," + type + "]";
                                status = 500;
                                throw new BrokerException((String)reason, status);
                            }
                            duid = DestinationUID.getUID(dest, DestType.isQueue((int)type));
                        }
                        String info = msg.getSysMessageID().toString();
                        Producer p = this.addProducer(duid, con, info, isIndemp);
                        ProducerUID pid = p.getProducerUID();
                        assert (pid != null);
                        boolean active = d == null ? true : d.isProducerActive(pid);
                        returnprop.put("JMQProducerID", pid.longValue());
                        returnprop.put("JMQDestinationID", duid.toString());
                        if (d == null) {
                            returnprop.put("JMQBytes", -1L);
                            returnprop.put("JMQSize", -1);
                        } else if (active) {
                            returnprop.put("JMQBytes", d.getBytesProducerFlow());
                            returnprop.put("JMQSize", d.getSizeProducerFlow());
                        } else {
                            returnprop.put("JMQBytes", 0L);
                            returnprop.put("JMQSize", 0);
                        }
                    } else {
                        assert (msg.getPacketType() == 66);
                        Long pid_l = (Long)props.get("JMQProducerID");
                        ProducerUID pid = new ProducerUID(pid_l == null ? 0L : pid_l);
                        this.removeProducer(pid, isIndemp, con, "Producer closed requested:\n\tconnection: " + con.getConnectionUID() + "\n\tproducerID: " + pid + "\n\trequest sysmsgid message: " + msg.getSysMessageID());
                    }
                }
                catch (BrokerException ex) {
                    status = ex.getStatusCode();
                    reason = ex.getMessage();
                    this.logger.log(8, (String)reason);
                }
                catch (Exception ex) {
                    this.logger.logStack(8, "B3100", (Object)"producer message ", (Throwable)ex);
                    reason = ex.getMessage();
                    status = 500;
                }
                finally {
                    if (d != null) {
                        d.decrementRefCount();
                    }
                }
                returnprop.put("JMQStatus", status);
                if (reason != null) {
                    returnprop.put("JMQReason", reason);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block33;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block34;
            }
            returnprop.put("JMQReqID", msg.getSysMessageID().toString());
        }
        reply.setProperties(returnprop);
        con.sendControlMessage(reply);
        return true;
    }

    public Producer addProducer(DestinationUID duid, IMQConnection con, String id, boolean isIndemp) throws BrokerException {
        Producer p = null;
        if (isIndemp) {
            p = (Producer)Producer.getProducer(id);
        }
        if (p == null) {
            p = Producer.createProducer(duid, con.getConnectionUID(), id, con.getPartitionedStore());
            assert (p != null);
            con.addProducer(p);
            List[] ll = DestinationList.findMatchingIDs(con.getPartitionedStore(), duid);
            List l = ll[0];
            Iterator itr = l.iterator();
            DestinationUID realuid = null;
            Destination[] ds = null;
            Destination d = null;
            while (itr.hasNext()) {
                realuid = (DestinationUID)itr.next();
                ds = DestinationList.getDestination(con.getPartitionedStore(), realuid);
                d = ds[0];
                if (duid.isWildcard() && d.isTemporary()) {
                    this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + duid + " to temporary destination " + d.getUniqueName() + " is not supported, ignoring");
                    continue;
                }
                if (duid.isWildcard() && d.isInternal()) {
                    this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + duid + " to internal destination " + d.getUniqueName() + " is not supported, ignoring");
                    continue;
                }
                if (duid.isWildcard() && d.isDMQ()) {
                    this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + duid + " to the DeadMessageQueue" + d.getUniqueName() + " is not supported, ignoring");
                    continue;
                }
                d.addProducer(p);
            }
        }
        return p;
    }

    public void removeProducer(ProducerUID pid, boolean isIndemp, IMQConnection con, String msg) throws BrokerException {
        String reason = null;
        int status = 200;
        Producer p = (Producer)Producer.getProducer(pid);
        if (p != null || !isIndemp) {
            if (p == null) {
                this.logger.log(8, "B3100", (Object)("Internal error Unable to find producer " + pid + "\n\t checking if producer was removed recently " + Producer.checkProducer(pid)));
                reason = "unknown producer";
                status = 500;
                throw new BrokerException(reason, status);
            }
            if (p.getConnectionUID() != con.getConnectionUID()) {
                this.logger.log(8, "B3100", (Object)(" error connection removing producer it doesnt own\n\tPID=" + pid + "\n\tconnectionUID of request " + con.getConnectionUID() + "\n\tconnectionUID of creator " + p.getConnectionUID() + "\n\tchecking producer state: " + Producer.checkProducer(pid)));
                reason = "unknown producer";
                status = 500;
                throw new BrokerException(reason, status);
            }
            con.removeProducer(pid, msg, this.coreLifecycle);
        }
    }
}

