/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LoopbackAddressException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;

public class BrokerMQAddress
extends MQAddress {
    static final long serialVersionUID = 9061061210446233838L;
    private transient InetAddress host = null;
    private transient String tostring = null;
    private transient String hostaddressNport = null;

    protected BrokerMQAddress() {
    }

    protected void initialize(String addr) throws MalformedURLException {
        super.initialize(addr);
        this.serviceName = "";
    }

    protected void initialize(String host, int port) throws MalformedURLException {
        super.initialize(host, port);
        this.serviceName = "";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.toString().equals(((BrokerMQAddress)((Object)obj)).toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.tostring != null) {
            return this.tostring;
        }
        if (this.getIsHTTP()) {
            return super.toString();
        }
        this.tostring = this.getSchemeName() + "://" + this.getHostAddressNPort() + "/" + this.getServiceName();
        return this.tostring;
    }

    private void initHostAddressNPort() throws MalformedURLException {
        this.hostaddressNport = MQAddress.getMQAddress((String)this.host.getHostAddress(), (int)this.port).getHostName() + ":" + this.port;
    }

    public String getHostAddressNPort() {
        return this.hostaddressNport;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public void resolveHostName() throws UnknownHostException {
        if (this.host == null) {
            String h = this.getHostName();
            this.host = h == null || h.equals("") || h.equals("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(h);
        }
    }

    public static BrokerMQAddress createAddress(String host, int port) throws MalformedURLException, UnknownHostException {
        BrokerMQAddress ret = new BrokerMQAddress();
        ret.initialize(host, port);
        ret.resolveHostName();
        ret.initHostAddressNPort();
        return ret;
    }

    public static BrokerMQAddress createAddress(String addr) throws MalformedURLException, UnknownHostException {
        BrokerMQAddress ret = new BrokerMQAddress();
        ret.initialize(addr);
        ret.resolveHostName();
        ret.initHostAddressNPort();
        return ret;
    }

    public static InetAddress resolveBindAddress(String listenHost, boolean nolocalhost) throws BrokerException, UnknownHostException {
        if (listenHost == null) {
            return null;
        }
        if (listenHost.trim().length() == 0) {
            return null;
        }
        InetAddress iaddr = null;
        iaddr = nolocalhost && listenHost.equals("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(listenHost);
        if (!nolocalhost) {
            return iaddr;
        }
        BrokerMQAddress.checkLoopbackAddress(iaddr, listenHost);
        return iaddr;
    }

    public static void checkLoopbackAddress(InetAddress iaddr, String hostname) throws BrokerException, UnknownHostException {
        if (iaddr == null) {
            return;
        }
        if (iaddr.isLoopbackAddress()) {
            BrokerResources brokerResources = Globals.getBrokerResources();
            Globals.getBrokerResources();
            throw new LoopbackAddressException(brokerResources.getString("B4214", hostname == null ? "" : hostname + "[" + iaddr + "]"));
        }
    }
}

