/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.audit.api;

import com.sun.messaging.jmq.jmsserver.audit.api.MQAuditSession;
import com.sun.messaging.jmq.jmsserver.audit.api.NoAuditSession;
import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.annotation.Annotation;

public class MQAuditService {
    static Logger logger = null;
    static BrokerResources br = null;
    public static final String AUDIT_PROP_PREFIX = "imq.audit.";
    public static final String AUDIT_ENABLED_PROP = "imq.audit.enabled";
    private static final String CLASS_PROP_SUBFIX = ".class";
    public static final String BSM_TYPE = "bsm";
    public static final String LOG_TYPE = "log";
    private static final String DEFAULT_LOG_CLASS = "com.sun.messaging.jmq.jmsserver.audit.impl.LogAuditSession";
    private static final String DEFAULT_BSM_CLASS = "com.sun.messaging.jmq.jmsserver.audit.impl.BSMAuditSession";
    private static final String MQ_AUDIT_CLASS = "com.sun.messaging.jmq.jmsserver.audit.impl.MQAuditManager";
    private static final String BSM_CLASS = "com.sun.audit.AuditSession";
    static boolean DEFAULT_BSM_DISABLED;
    static boolean bsmDisabled;
    static boolean bsmAudit;
    static boolean logAuditEnabled;
    private static MQAuditSession auditSession;

    public static boolean isBSMAudit() {
        return bsmAudit;
    }

    public static boolean logAuditEnabled() {
        return logAuditEnabled;
    }

    public static void clear() {
        logger = null;
        br = null;
        auditSession = null;
    }

    public static void init() {
        logger = CommGlobals.getLogger();
        br = CommGlobals.getBrokerResources();
        bsmDisabled = CommGlobals.getConfig().getBooleanProperty("imq.audit.bsm.disabled", DEFAULT_BSM_DISABLED);
        if (!bsmDisabled) {
            try {
                Class.forName(BSM_CLASS);
                bsmAudit = true;
            }
            catch (Throwable t) {
                logger.log(16, "BSM audit will not be available: " + t + "[com.sun.audit.AuditSession]");
            }
        }
    }

    public static synchronized MQAuditSession getAuditSession() throws BrokerException {
        if (auditSession == null) {
            logAuditEnabled = CommGlobals.getConfig().getBooleanProperty(AUDIT_ENABLED_PROP, false);
            auditSession = MQAuditService.createAuditSession();
        }
        return auditSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQAuditSession getAuditSession(String type) throws BrokerException {
        MQAuditSession asession;
        block16: {
            String classname = null;
            if (LOG_TYPE.equals(type)) {
                classname = DEFAULT_LOG_CLASS;
            } else if (BSM_TYPE.equals(type)) {
                classname = DEFAULT_BSM_CLASS;
            } else {
                throw new BrokerException("UNEXPECTED AUDIT TYPE SPECIFIED: " + type);
            }
            String prop = AUDIT_PROP_PREFIX + type + CLASS_PROP_SUBFIX;
            classname = CommGlobals.getConfig().getProperty(prop, classname);
            asession = null;
            ReflectiveOperationException exception = null;
            try {
                if (CommGlobals.isNucleusManagedBroker()) {
                    asession = (MQAuditSession)CommGlobals.getHabitat().getService(MQAuditSession.class, type, new Annotation[0]);
                    if (asession == null) {
                        throw new ClassNotFoundException(classname);
                    }
                } else {
                    asession = (MQAuditSession)Class.forName(classname).newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                if (!logAuditEnabled && !bsmAudit) {
                    asession = new NoAuditSession();
                }
                exception = e;
                return exception;
            }
            catch (IllegalAccessException | InstantiationException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block16;
                if (exception instanceof BrokerException) {
                    throw (BrokerException)((Object)exception);
                }
                throw new BrokerException(br.getString("B4204", classname), exception);
            }
        }
        return asession;
    }

    private static MQAuditSession createAuditSession() throws BrokerException {
        MQAuditSession asession;
        block12: {
            asession = null;
            ReflectiveOperationException exception = null;
            try {
                if (CommGlobals.isNucleusManagedBroker()) {
                    asession = (MQAuditSession)CommGlobals.getHabitat().getService(MQAuditSession.class, MQ_AUDIT_CLASS, new Annotation[0]);
                    if (asession == null) {
                        throw new ClassNotFoundException(MQ_AUDIT_CLASS);
                    }
                } else {
                    asession = (MQAuditSession)Class.forName(MQ_AUDIT_CLASS).newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                if (!logAuditEnabled && !bsmAudit) {
                    asession = new NoAuditSession();
                }
                exception = e;
                return exception;
            }
            catch (IllegalAccessException | InstantiationException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block12;
                if (exception instanceof BrokerException) {
                    throw (BrokerException)((Object)exception);
                }
                throw new BrokerException(br.getString("B4204", MQ_AUDIT_CLASS), exception);
            }
        }
        return asession;
    }

    static {
        bsmDisabled = DEFAULT_BSM_DISABLED = true;
        bsmAudit = false;
        logAuditEnabled = false;
        auditSession = null;
    }
}

