/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSAdminException;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="change-master-broker")
@PerLookup
@I18n(value="change.master.broker")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="change-master-broker", description="change-master-broker")})
public class ChangeMasterBrokerCommand
extends JMSDestination
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ChangeMasterBrokerCommand.class);
    @Param(primary=true)
    String newMasterBroker;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Domain domain;
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    ServerContext serverContext;
    Config config;

    public void execute(AdminCommandContext context) {
        SystemProperty sp;
        ActionReport report = context.getActionReport();
        final String newMB = this.newMasterBroker;
        Server newMBServer = this.domain.getServerNamed(this.newMasterBroker);
        if (newMBServer == null) {
            report.setMessage(localStrings.getLocalString("change.master.broker.invalidServerName", "Invalid server name specified. There is no server by this name"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Cluster cluster = newMBServer.getCluster();
        if (cluster == null) {
            report.setMessage(localStrings.getLocalString("change.master.broker.invalidClusterName", "The server specified is not associated with a cluster. The server assocaited with the master broker has to be a part of the cluster"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Nodes nodes = this.domain.getNodes();
        this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        JmsService jmsservice = (JmsService)this.config.getExtensionByType(JmsService.class);
        Server oldMBServer = null;
        if (jmsservice.getMasterBroker() != null) {
            oldMBServer = this.domain.getServerNamed(jmsservice.getMasterBroker());
        } else {
            List serverList = cluster.getInstances();
            oldMBServer = (Server)serverList.get(0);
        }
        String oldMasterBrokerPort = JmsRaUtil.getJMSPropertyValue((Server)oldMBServer);
        if (oldMasterBrokerPort == null && (sp = this.config.getSystemProperty("JMS_PROVIDER_PORT")) != null) {
            oldMasterBrokerPort = sp.getValue();
        }
        if (oldMasterBrokerPort == null) {
            oldMasterBrokerPort = this.getDefaultJmsHost(jmsservice).getPort();
        }
        String oldMasterBrokerHost = nodes.getNode(oldMBServer.getNodeRef()).getNodeHost();
        String newMasterBrokerPort = JmsRaUtil.getJMSPropertyValue((Server)newMBServer);
        if (newMasterBrokerPort == null) {
            newMasterBrokerPort = this.getDefaultJmsHost(jmsservice).getPort();
        }
        String newMasterBrokerHost = nodes.getNode(newMBServer.getNodeRef()).getNodeHost();
        String oldMasterBroker = oldMasterBrokerHost + ":" + oldMasterBrokerPort;
        String newMasterBroker = newMasterBrokerHost + ":" + newMasterBrokerPort;
        try {
            CompositeData result = this.updateMasterBroker(oldMBServer.getName(), oldMasterBroker, newMasterBroker);
            boolean success = (Boolean)result.get("Success");
            if (!success) {
                int statusCode = (Integer)result.get("StatusCode");
                String detailMessage = (String)result.get("DetailMessage");
                Object msg = " " + detailMessage;
                msg = BrokerStatusCode.BAD_REQUEST.getCode() == statusCode || BrokerStatusCode.NOT_ALLOWED.getCode() == statusCode || BrokerStatusCode.UNAVAILABLE.getCode() == statusCode || BrokerStatusCode.PRECONDITION_FAILED.getCode() == statusCode ? localStrings.getLocalString("change.master.broker.errorMsg", "{0}. But it didn't affect current master broker configuration.", new Object[]{msg}) : (String)msg + ". " + localStrings.getLocalString("change.master.broker.otherErrorMsg", "The cluster should be shutdown and configured with the new master broker then restarts.");
                report.setMessage(localStrings.getLocalString("change.master.broker.CannotChangeMB", "Unable to change master broker.{0}", new Object[]{msg}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("change.master.broker.CannotChangeMB", "Unable to change master broker because {0}", new Object[]{e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmsService>(){

                public Object run(JmsService param) throws PropertyVetoException, TransactionFailure {
                    param.setMasterBroker(newMB);
                    return param;
                }
            }, (ConfigBeanProxy)jmsservice);
        }
        catch (Exception tfe) {
            report.setMessage(localStrings.getLocalString("change.master.broker.fail", "Unable to update the domain.xml with the new master broker") + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("change.master.broker.success", "Master broker change has executed successfully for Cluster {0}.", new Object[]{cluster.getName()}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private JmsHost getDefaultJmsHost(JmsService jmsService) {
        JmsHost jmsHost = null;
        String defaultJmsHostName = jmsService.getDefaultJmsHost();
        List jmsHostsList = jmsService.getJmsHost();
        for (int i = 0; i < jmsHostsList.size(); ++i) {
            JmsHost tmpJmsHost = (JmsHost)jmsHostsList.get(i);
            if (tmpJmsHost == null || !tmpJmsHost.getName().equals(defaultJmsHostName)) continue;
            jmsHost = tmpJmsHost;
        }
        return jmsHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeData updateMasterBroker(String serverName, String oldMasterBroker, String newMasterBroker) throws Exception {
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(serverName, this.config, this.serverContext, this.domain, this.connectorRuntime);
        CompositeData result = null;
        try {
            MBeanServerConnection mbsc = null;
            try {
                mbsc = mqInfo.getMQMBeanServerConnection();
            }
            catch (Exception e) {
                String emsg = localStrings.getLocalString("change.master.broker.cannotConnectOldMasterBroker", "Unable to connect to the current master broker {0}. Likely reasons: the cluster might not be running, the server instance {0} associated with the current master broker or the current master broker might not be running.  Please check server logs.", (Object[])new String[]{mqInfo.getASInstanceName()});
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, emsg);
                }
                this.logAndHandleException(e, emsg);
            }
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=Cluster,subtype=Config");
            Object[] params = null;
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            params = new Object[]{oldMasterBroker, newMasterBroker};
            result = mbsc != null ? (CompositeData)mbsc.invoke(on, "changeMasterBroker", params, signature) : null;
        }
        catch (Exception e) {
            this.logAndHandleException(e, e.getMessage());
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return result;
    }

    @Override
    protected void logAndHandleException(Exception e, String errorMsg) throws JMSAdminException {
        StringWriter s = new StringWriter();
        e.printStackTrace(new PrintWriter(s));
        String emsg = localStrings.getLocalString(errorMsg, errorMsg);
        JMSAdminException je = new JMSAdminException(emsg);
        if (e.getCause() != null && e.getCause().getCause() != null) {
            je.initCause(e.getCause().getCause().getCause());
        }
        this.handleException(je);
    }

    private static enum BrokerStatusCode {
        BAD_REQUEST(400),
        NOT_ALLOWED(405),
        UNAVAILABLE(503),
        PRECONDITION_FAILED(412);

        private int code;

        private BrokerStatusCode(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }
    }
}

