/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee;

import com.sun.enterprise.security.ContainerSecurityLifecycle;
import com.sun.enterprise.security.ee.J2EESecurityManager;
import com.sun.enterprise.security.jmac.config.GFAuthConfigFactory;
import com.sun.logging.LogDomains;
import jakarta.inject.Singleton;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class JavaEESecurityLifecycle
implements ContainerSecurityLifecycle,
PostConstruct {
    private static final Logger _logger = LogDomains.getLogger(JavaEESecurityLifecycle.class, (String)"javax.enterprise.system.core.security");

    @Override
    public void onInitialization() {
        SecurityManager secMgr = System.getSecurityManager();
        if (secMgr != null && !J2EESecurityManager.class.equals(secMgr.getClass())) {
            J2EESecurityManager mgr = new J2EESecurityManager();
            try {
                System.setSecurityManager(mgr);
            }
            catch (SecurityException ex) {
                _logger.log(Level.WARNING, "security.secmgr.could.not.override");
            }
        }
        this.initializeJMAC();
    }

    private void initializeJMAC() {
        String defaultFactory = Security.getProperty("authconfigprovider.factory");
        if (defaultFactory == null) {
            Security.setProperty("authconfigprovider.factory", GFAuthConfigFactory.class.getName());
        }
    }

    @Override
    public void postConstruct() {
        this.onInitialization();
    }
}

