/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Globals;
import org.apache.catalina.LogFacade;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.DispatchTargetsInfo;
import org.apache.catalina.core.StandardContext;

class AsyncContextImpl
implements AsyncContext {
    private static final String WELD_LISTENER = "org.jboss.weld.module.web.servlet.WeldListener";
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static final long DEFAULT_ASYNC_TIMEOUT_MILLIS = 30000L;
    private static final ExecutorService pool = Executors.newCachedThreadPool(new AsyncPoolThreadFactory());
    private Request origRequest;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean isOriginalRequestAndResponse = false;
    private boolean isStartAsyncWithZeroArg = false;
    private AtomicBoolean isDispatchInProgress = new AtomicBoolean();
    private ThreadLocal<Boolean> isDispatchInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private volatile boolean hasDispatch = false;
    private AtomicBoolean isOkToConfigure = new AtomicBoolean(true);
    private long asyncTimeoutMillis = 30000L;
    private final Queue<AsyncListener> listenerQueue = new ConcurrentLinkedQueue<AsyncListener>();
    private final LinkedList<AsyncListenerContext> asyncListenerContexts = new LinkedList();
    private AtomicInteger startAsyncCounter = new AtomicInteger(0);
    private final AtomicBoolean isAsyncCompleteCalled = new AtomicBoolean();
    private final AtomicBoolean isAsyncCompleted = new AtomicBoolean();
    private volatile boolean delayAsyncDispatchAndComplete = true;
    private ThreadLocal<Boolean> isStartAsyncInScope = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private Handler handler = null;

    AsyncContextImpl(Request origRequest, ServletRequest servletRequest, Response origResponse, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.origRequest = origRequest;
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
    }

    @Override
    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    Request getOriginalRequest() {
        return this.origRequest;
    }

    @Override
    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    @Override
    public boolean hasOriginalRequestAndResponse() {
        return this.isOriginalRequestAndResponse;
    }

    @Override
    public void dispatch() {
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.getZeroArgDispatcher(this.origRequest, this.servletRequest, this.isStartAsyncWithZeroArg);
        this.dispatch(dispatcher, null, null);
    }

    @Override
    public void dispatch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(path);
        this.dispatch(dispatcher, null, path);
    }

    @Override
    public void dispatch(ServletContext context, String path) {
        if (path == null || context == null) {
            throw new IllegalArgumentException("Null context or path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)context.getRequestDispatcher(path);
        this.dispatch(dispatcher, context, path);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatch(ApplicationDispatcher dispatcher, ServletContext context, String path) {
        this.isDispatchInScope.set(true);
        this.hasDispatch = true;
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) {
                String msg = rb.getString("AS-WEB-CORE-00025");
                throw new IllegalStateException(msg);
            }
            if (this.delayAsyncDispatchAndComplete) {
                this.handler = new Handler(this, dispatcher);
                return;
            }
            pool.execute(new Handler(this, dispatcher));
            return;
        }
        if (context == null && path == null) {
            log.log(Level.WARNING, "AS-WEB-CORE-00021");
            return;
        }
        if (context == null && path != null) {
            log.log(Level.WARNING, "AS-WEB-CORE-00022", path);
            return;
        }
        log.log(Level.WARNING, "AS-WEB-CORE-00023", new Object[]{path, context.getContextPath()});
    }

    void invokeDelayDispatch() {
        if (this.handler != null) {
            pool.execute(this.handler);
            this.handler = null;
        }
    }

    boolean isDispatchInScope() {
        return this.isDispatchInScope.get();
    }

    boolean getAndResetDispatchInScope() {
        boolean flag = this.isDispatchInScope.get();
        this.isDispatchInScope.set(Boolean.FALSE);
        return flag;
    }

    boolean isDelayAsyncDispatchAndComplete() {
        return this.delayAsyncDispatchAndComplete;
    }

    void setDelayAsyncDispatchAndComplete(boolean delayAsync) {
        this.delayAsyncDispatchAndComplete = delayAsync;
    }

    boolean isAsyncComplete() {
        return this.isAsyncCompleteCalled.get();
    }

    @Override
    public void complete() {
        if (this.isAsyncCompleteCalled.compareAndSet(false, true)) {
            if (this.delayAsyncDispatchAndComplete) {
                return;
            }
        } else {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00070"));
        }
        this.doComplete();
    }

    private void doComplete() {
        if (this.isAsyncCompleted.compareAndSet(false, true)) {
            this.origRequest.asyncComplete();
        }
    }

    void processAsyncOperations() {
        this.processAsyncOperations(false);
    }

    private void processAsyncOperations(boolean exit) {
        if (this.isDispatchInScope() || exit && this.hasDispatch) {
            this.invokeDelayDispatch();
        } else if (this.isAsyncComplete()) {
            this.doComplete();
        }
    }

    void onExitService() {
        this.delayAsyncDispatchAndComplete = false;
        this.processAsyncOperations(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Runnable run) {
        PrivilegedAction<ClassLoader> pa;
        ClassLoader oldCL = null;
        if (Globals.IS_SECURITY_ENABLED) {
            pa = new PrivilegedGetTccl();
            oldCL = AccessController.doPrivileged(pa);
        } else {
            oldCL = Thread.currentThread().getContextClassLoader();
        }
        try {
            ClassLoader newCL = this.origRequest.getContext().getLoader().getClassLoader();
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                AccessController.doPrivileged(pa2);
            } else {
                Thread.currentThread().setContextClassLoader(newCL);
            }
            pool.execute(run);
        }
        finally {
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedSetTccl(oldCL);
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    @Override
    public void addListener(AsyncListener listener) {
        this.addListener(listener, this.servletRequest, this.servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        if (servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null request, or response");
        }
        if (!this.isOkToConfigure.get()) {
            String msg = rb.getString("AS-WEB-CORE-00026");
            throw new IllegalStateException(msg);
        }
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.add(new AsyncListenerContext(listener, servletRequest, servletResponse));
        }
    }

    @Override
    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        AsyncListener listener = null;
        StandardContext ctx = (StandardContext)this.origRequest.getContext();
        if (ctx != null) {
            try {
                listener = (AsyncListener)ctx.createListenerInstance(clazz);
                this.listenerQueue.add(listener);
            }
            catch (Throwable t) {
                throw new ServletException(t);
            }
        }
        return (T)listener;
    }

    @Override
    public void setTimeout(long timeout) {
        if (!this.isOkToConfigure.get()) {
            String msg = rb.getString("AS-WEB-CORE-00027");
            throw new IllegalStateException(msg);
        }
        this.asyncTimeoutMillis = timeout;
    }

    @Override
    public long getTimeout() {
        return this.asyncTimeoutMillis;
    }

    void reinitialize(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.init(servletRequest, servletResponse, isStartAsyncWithZeroArg);
        this.isDispatchInProgress.set(false);
        this.setOkToConfigure(true);
        this.startAsyncCounter.incrementAndGet();
        this.notifyAsyncListeners(AsyncEventType.START_ASYNC, null);
    }

    boolean isOkToConfigure() {
        return this.isOkToConfigure.get();
    }

    void setOkToConfigure(boolean value) {
        this.isOkToConfigure.set(value);
    }

    private void init(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = !(!(servletRequest instanceof RequestFacade) && !(servletRequest instanceof ApplicationHttpRequest) || !(servletResponse instanceof ResponseFacade) && !(servletResponse instanceof ApplicationHttpResponse));
        this.isStartAsyncWithZeroArg = isStartAsyncWithZeroArg;
    }

    private RequestDispatcher getZeroArgDispatcher(Request origRequest, ServletRequest servletRequest, boolean isStartAsyncWithZeroArg) {
        String dispatchTarget = null;
        boolean isNamed = false;
        if (!isStartAsyncWithZeroArg && servletRequest instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            dispatchTarget = this.getCombinedPath(req);
        } else {
            DispatchTargetsInfo dtInfo = (DispatchTargetsInfo)origRequest.getAttribute("org.apache.catalina.core.ApplicationDispatcher.lastDispatchRequestPathAttr");
            if (dtInfo != null) {
                dispatchTarget = dtInfo.getLastDispatchTarget();
                isNamed = dtInfo.isLastNamedDispatchTarget();
            }
            if (dispatchTarget == null) {
                dispatchTarget = this.getCombinedPath(origRequest);
            }
        }
        RequestDispatcher dispatcher = null;
        if (dispatchTarget != null) {
            dispatcher = isNamed ? servletRequest.getServletContext().getNamedDispatcher(dispatchTarget) : servletRequest.getRequestDispatcher(dispatchTarget);
        }
        return dispatcher;
    }

    private String getCombinedPath(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        if (servletPath == null) {
            return null;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return servletPath;
        }
        return servletPath + pathInfo;
    }

    boolean isStartAsyncInScope() {
        return this.isStartAsyncInScope.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAsyncListeners(AsyncEventType asyncEventType, Throwable t) {
        ClassLoader oldCL;
        PrivilegedAction<ClassLoader> pa;
        LinkedList<AsyncListenerContext> clone;
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            if (this.asyncListenerContexts.isEmpty()) {
                return;
            }
            clone = new LinkedList<AsyncListenerContext>(this.asyncListenerContexts);
            if (asyncEventType.equals((Object)AsyncEventType.START_ASYNC)) {
                this.asyncListenerContexts.clear();
            }
        }
        if (Globals.IS_SECURITY_ENABLED) {
            pa = new PrivilegedGetTccl();
            oldCL = AccessController.doPrivileged(pa);
        } else {
            oldCL = Thread.currentThread().getContextClassLoader();
        }
        try {
            ClassLoader newCL = this.origRequest.getContext().getLoader().getClassLoader();
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                AccessController.doPrivileged(pa2);
            } else {
                Thread.currentThread().setContextClassLoader(newCL);
            }
            ServletRequestListener weldListener = this.getWeldListener();
            if (weldListener != null) {
                ServletRequestEvent event = new ServletRequestEvent(this.origRequest.getContext().getServletContext(), this.origRequest);
                weldListener.requestInitialized(event);
            }
            boolean oldDelay = this.isDelayAsyncDispatchAndComplete();
            try {
                this.setDelayAsyncDispatchAndComplete(true);
                for (AsyncListenerContext asyncListenerContext : clone) {
                    AsyncListener asyncListener = asyncListenerContext.getAsyncListener();
                    AsyncEvent asyncEvent = new AsyncEvent(this, asyncListenerContext.getRequest(), asyncListenerContext.getResponse(), t);
                    try {
                        switch (asyncEventType) {
                            case COMPLETE: {
                                asyncListener.onComplete(asyncEvent);
                                break;
                            }
                            case TIMEOUT: {
                                asyncListener.onTimeout(asyncEvent);
                                break;
                            }
                            case ERROR: {
                                asyncListener.onError(asyncEvent);
                                break;
                            }
                            case START_ASYNC: {
                                asyncListener.onStartAsync(asyncEvent);
                                break;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        log.log(Level.WARNING, "AS-WEB-CORE-00024", throwable);
                    }
                }
            }
            finally {
                this.setDelayAsyncDispatchAndComplete(oldDelay);
                if (weldListener != null) {
                    ServletRequestEvent event = new ServletRequestEvent(this.origRequest.getContext().getServletContext(), this.origRequest);
                    weldListener.requestDestroyed(event);
                }
                this.processAsyncOperations();
            }
        }
        finally {
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedSetTccl(oldCL);
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    private ServletRequestListener getWeldListener() {
        List<EventListener> eventListeners = this.origRequest.getContext().getApplicationEventListeners();
        if (eventListeners != null) {
            for (EventListener listener : eventListeners) {
                if (!listener.getClass().getName().equals(WELD_LISTENER)) continue;
                return (ServletRequestListener)listener;
            }
        }
        return null;
    }

    static ExecutorService getExecutorService() {
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LinkedList<AsyncListenerContext> linkedList = this.asyncListenerContexts;
        synchronized (linkedList) {
            this.asyncListenerContexts.clear();
        }
        StandardContext ctx = (StandardContext)this.origRequest.getContext();
        if (ctx != null) {
            for (AsyncListener l : this.listenerQueue) {
                ctx.fireContainerEvent("predestroy", l);
            }
        }
        this.listenerQueue.clear();
        this.servletRequest = null;
        this.servletResponse = null;
        this.origRequest = null;
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }

    private static final class AsyncPoolThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final AtomicInteger counter = new AtomicInteger(0);

        private AsyncPoolThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.defaultFactory.newThread(r);
            t.setName("glassfish-web-async-thread-" + this.counter.incrementAndGet());
            return t;
        }
    }

    private static class AsyncListenerContext {
        private AsyncListener listener;
        private ServletRequest request;
        private ServletResponse response;

        public AsyncListenerContext(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this.listener = listener;
            this.request = request;
            this.response = response;
        }

        public AsyncListener getAsyncListener() {
            return this.listener;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }
    }

    static class Handler
    implements Runnable {
        private final AsyncContextImpl asyncContext;
        private final ApplicationDispatcher dispatcher;

        Handler(AsyncContextImpl asyncContext, ApplicationDispatcher dispatcher) {
            this.asyncContext = asyncContext;
            this.dispatcher = dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader oldCL;
            PrivilegedAction<ClassLoader> pa;
            this.asyncContext.isStartAsyncInScope.set(Boolean.TRUE);
            Request origRequest = this.asyncContext.getOriginalRequest();
            origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.ASYNC);
            origRequest.setAsyncStarted(false);
            int startAsyncCurrent = this.asyncContext.startAsyncCounter.get();
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedGetTccl();
                oldCL = AccessController.doPrivileged(pa);
            } else {
                oldCL = Thread.currentThread().getContextClassLoader();
            }
            try {
                ClassLoader newCL = origRequest.getContext().getLoader().getClassLoader();
                if (Globals.IS_SECURITY_ENABLED) {
                    PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                    AccessController.doPrivileged(pa2);
                } else {
                    Thread.currentThread().setContextClassLoader(newCL);
                }
                this.asyncContext.setDelayAsyncDispatchAndComplete(true);
                this.dispatcher.dispatch(this.asyncContext.getRequest(), this.asyncContext.getResponse(), DispatcherType.ASYNC);
                this.asyncContext.setDelayAsyncDispatchAndComplete(false);
                this.asyncContext.processAsyncOperations();
                if (!this.asyncContext.isAsyncComplete() && this.asyncContext.startAsyncCounter.compareAndSet(startAsyncCurrent, startAsyncCurrent)) {
                    this.asyncContext.complete();
                } else {
                    origRequest.setAsyncTimeout(this.asyncContext.getTimeout());
                }
            }
            catch (Throwable t) {
                this.asyncContext.setDelayAsyncDispatchAndComplete(false);
                this.asyncContext.notifyAsyncListeners(AsyncEventType.ERROR, t);
                origRequest.errorDispatchAndComplete(t);
            }
            finally {
                this.asyncContext.isStartAsyncInScope.set(Boolean.FALSE);
                if (Globals.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(oldCL);
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        }
    }

    static enum AsyncEventType {
        COMPLETE,
        TIMEOUT,
        ERROR,
        START_ASYNC;

    }
}

