/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.servlet;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;

public class TestClient {
    private static final String nl = System.lineSeparator();
    private static final Logger log = Logger.getLogger(TestClient.class.getCanonicalName());

    public void runTest(URL requestURL) {
        this.assertSuccessfulURLResponse(requestURL, null);
    }

    public void runTest(URL requestURL, String expected) {
        String response = this.assertSuccessfulURLResponse(requestURL, null);
        Assertions.assertTrue((boolean)response.contains(expected), (String)("The expected string [" + expected + "] was not found in the response: " + response));
    }

    public String runTestWithResponse(URL requestURL, Properties props) {
        return this.assertSuccessfulURLResponse(requestURL, props);
    }

    private String assertSuccessfulURLResponse(URL url, Properties props) {
        boolean withProps = props != null;
        boolean pass = false;
        log.info("Running test on servlet via URL: " + url.toString());
        HttpURLConnection con = null;
        try {
            String line;
            con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setConnectTimeout((int)Duration.ofMinutes(1L).toMillis());
            if (withProps) {
                con.setRequestMethod("POST");
                try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                    wr.writeBytes(TestClient.toEncodedString(props));
                }
            } else {
                con.setRequestMethod("GET");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder outputBuilder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                outputBuilder.append(line).append(nl);
                if (!line.contains("SUCCESS")) continue;
                pass = true;
            }
            Assertions.assertTrue((con.getResponseCode() < 400 ? 1 : 0) != 0, (String)"Connection returned a response code that was greater than 400");
            Assertions.assertTrue((boolean)pass, (String)"Output did not contain successful message: SUCCESS");
            String string = outputBuilder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception: " + e.getClass().getName() + " requesting URL=" + url.toString(), e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    protected static String toEncodedString(Properties args) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        Enumeration<?> names = args.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = args.getProperty(name);
            buf.append(URLEncoder.encode(name, StandardCharsets.UTF_8.name())).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
            if (!names.hasMoreElements()) continue;
            buf.append("&");
        }
        return buf.toString();
    }
}

