/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.cdo.migration.execution;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIData;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.view.AbstractCDOViewProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.ManagedContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;

public class EdaptCDOViewProvider
extends AbstractCDOViewProvider
implements CDOViewProvider {
    private static Map<String, IManagedContainer> repoContainers = new HashMap<String, IManagedContainer>();
    private static Map<String, CDOResource> rootResourceRegistry = new HashMap<String, CDOResource>();

    public EdaptCDOViewProvider() {
    }

    public EdaptCDOViewProvider(String regex) {
        super(regex);
    }

    public EdaptCDOViewProvider(String regex, int priority) {
        super(regex, priority);
    }

    public CDOView getView(URI uri, ResourceSet resourceSet) {
        CDOURIData cdouriData = new CDOURIData(uri);
        String repoName = cdouriData.getRepositoryName();
        IManagedContainer container = repoContainers.get(repoName);
        if (container == null) {
            container = new ManagedContainer();
            Net4jUtil.prepareContainer((IManagedContainer)container);
            TCPUtil.prepareContainer((IManagedContainer)container);
            container.activate();
            repoContainers.put(repoName, container);
        } else {
            Object[] objectArray = container.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object e = objectArray[n2];
                System.out.println(e);
                ++n2;
            }
        }
        String uriSchema = cdouriData.getScheme();
        System.out.println("EDAPT TODO: Schema requested is " + uriSchema + " base connector on this requested schema. ");
        if (!uriSchema.equals("cdo.net4j.tcp")) {
            uriSchema.equals("cdo.net4j.jvm");
        }
        IConnector connector = (IConnector)container.getElement("org.eclipse.net4j.connectors", "tcp", cdouriData.getAuthority());
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector(connector);
        config.setRepositoryName(repoName);
        if (cdouriData.getUserName() != null && cdouriData.getPassWord() != null) {
            PasswordCredentials passwordCredentials = new PasswordCredentials(cdouriData.getUserName(), cdouriData.getPassWord().toCharArray());
            PasswordCredentialsProvider credentialsProvider = new PasswordCredentialsProvider((IPasswordCredentials)passwordCredentials);
            config.setCredentialsProvider((IPasswordCredentialsProvider)credentialsProvider);
        }
        CDONet4jSession session = config.openNet4jSession();
        session.options().setGeneratedPackageEmulationEnabled(true);
        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        boolean packagesAdded = false;
        if (!packageRegistry.isEmpty()) {
            CDOPackageRegistry cdoPackageRegistry = session.getPackageRegistry();
            for (String nsURI : packageRegistry.keySet()) {
                EPackage packageToAdd = packageRegistry.getEPackage(nsURI);
                if (cdoPackageRegistry.containsKey((Object)nsURI)) continue;
                cdoPackageRegistry.putEPackage(packageToAdd);
                packagesAdded = true;
            }
        }
        CDOTransaction openTransaction = session.openTransaction(resourceSet);
        if (packagesAdded) {
            try {
                openTransaction.commit();
            }
            catch (ConcurrentAccessException e) {
                e.printStackTrace();
            }
            catch (CommitException e) {
                e.printStackTrace();
            }
        }
        if (rootResourceRegistry.get(repoName) == null) {
            CDOResource rootResource = openTransaction.getRootResource();
            rootResource.getURI();
            rootResourceRegistry.put(repoName, rootResource);
        }
        return openTransaction;
    }

    public CDOResource getRootResource(String repoName) {
        CDOResource cdoResource = rootResourceRegistry.get(repoName);
        if (cdoResource != null) {
            LifecycleUtil.checkActive((Object)cdoResource);
            return cdoResource;
        }
        return null;
    }
}

