/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.history.reconstruction.IReconstructor;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.Release;

public abstract class CompositeReconstructorBase
implements IReconstructor {
    private List<IReconstructor> reconstructors = new ArrayList<IReconstructor>();
    protected Mapping mapping;
    protected MetamodelExtent extent;
    protected ResourceSet resourceSet = new ResourceSetImpl();

    public void reconstruct(Release targetRelease, boolean before) {
        History originalHistory = targetRelease.getHistory();
        this.doReconstruct(targetRelease, originalHistory, before);
    }

    public void reconstruct(Change targetChange, boolean before) {
        History originalHistory = targetChange.getRelease().getHistory();
        this.doReconstruct(targetChange, originalHistory, before);
    }

    protected abstract void doReconstruct(EObject var1, History var2, boolean var3);

    public void init(Mapping mapping, MetamodelExtent extent) {
        for (IReconstructor r : this.reconstructors) {
            r.init(mapping, extent);
        }
    }

    public void addReconstructor(IReconstructor reconstructor) {
        this.reconstructors.add(reconstructor);
    }

    public void startHistory(History originalHistory) {
        for (IReconstructor r : this.reconstructors) {
            r.startHistory(originalHistory);
        }
    }

    public void endHistory(History originalHistory) {
        for (IReconstructor r : this.reconstructors) {
            r.endHistory(originalHistory);
        }
    }

    public void startChange(Change change) {
        for (IReconstructor r : this.reconstructors) {
            r.startChange(change);
        }
    }

    public void endChange(Change change) {
        for (IReconstructor r : this.reconstructors) {
            r.endChange(change);
        }
    }

    public void startRelease(Release originalRelease) {
        for (IReconstructor r : this.reconstructors) {
            r.startRelease(originalRelease);
        }
    }

    public void endRelease(Release originalRelease) {
        for (IReconstructor r : this.reconstructors) {
            r.endRelease(originalRelease);
        }
    }

    public MetamodelExtent getExtent() {
        return this.extent;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

