/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.declaration.generalization.GeneralizeReference;
import org.eclipse.emf.edapt.declaration.inheritance.ReplaceFeature;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="pullFeature", label="Pull up Feature", description="In the metamodel, a number of features are pulled up into a common super class. In the model, values are changed accordingly.")
public class PullFeature
extends OperationImplementation {
    @EdaptParameter(main=true, description="The features to be pulled up")
    public List<EStructuralFeature> features;
    @EdaptParameter(description="The super class to which the features are pulled")
    public EClass targetClass;

    @EdaptConstraint(restricts="targetClass", description="The features' classes must have a common super type")
    public boolean checkTargetClassCommonSuperType(EClass targetClass) {
        for (EStructuralFeature feature : this.features) {
            if (feature.getEContainingClass().getESuperTypes().contains((Object)targetClass)) continue;
            return false;
        }
        return true;
    }

    @EdaptConstraint(description="The features must not have opposite references")
    public boolean checkReferencesOpposite() {
        EcorePackage mmm = EcorePackage.eINSTANCE;
        if (this.features.size() > 1) {
            return !this.isOfType(this.features, mmm.getEReference()) || this.hasValue(this.features, (EStructuralFeature)mmm.getEReference_EOpposite(), null);
        }
        return true;
    }

    @EdaptConstraint(description="The features have to be all containment references or not")
    public boolean checkReferencesContainment() {
        EcorePackage mmm = EcorePackage.eINSTANCE;
        return !this.isOfType(this.features, mmm.getEReference()) || this.hasSameValue(this.features, (EStructuralFeature)mmm.getEReference_Containment());
    }

    @EdaptConstraint(description="The features' multiplicities have to be the same")
    public boolean checkFeaturesSameMultiplicity() {
        EcorePackage mmm = EcorePackage.eINSTANCE;
        return this.hasSameValue(this.features, (EStructuralFeature)mmm.getETypedElement_LowerBound()) && this.hasSameValue(this.features, (EStructuralFeature)mmm.getETypedElement_UpperBound());
    }

    @EdaptConstraint(description="The features' types have to be the same")
    public boolean checkFeaturesSameType() {
        return this.hasSameValue(this.features, (EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__ETYPE);
    }

    public void initialize(Metamodel metamodel) {
        EList superTypes;
        if (this.targetClass == null && !(superTypes = this.features.get(0).getEContainingClass().getESuperTypes()).isEmpty()) {
            this.targetClass = (EClass)superTypes.get(0);
        }
    }

    public void execute(Metamodel metamodel, Model model) throws MigrationException {
        EReference mainReference;
        EStructuralFeature mainFeature = this.features.get(0);
        this.targetClass.getEStructuralFeatures().add((Object)mainFeature);
        if (mainFeature instanceof EReference && (mainReference = (EReference)mainFeature).getEOpposite() != null) {
            GeneralizeReference operation = new GeneralizeReference();
            operation.reference = mainReference.getEOpposite();
            operation.initialize(metamodel);
            operation.type = this.targetClass;
            operation.checkAndExecute(metamodel, model);
        }
        for (EStructuralFeature feature : this.features) {
            if (feature == mainFeature) continue;
            ReplaceFeature operation = new ReplaceFeature();
            operation.toReplace = feature;
            operation.replaceBy = mainFeature;
            operation.checkAndExecute(metamodel, model);
        }
    }
}

