/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.reference.LinkControl;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.edit.spi.swt.reference.DeleteReferenceAction;
import org.eclipse.emf.ecp.view.internal.editor.controls.ECPSelectionStatusValidator;
import org.eclipse.emf.ecp.view.spi.editor.controls.AbstractFilteredReferenceAction;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class TableColumnDomainModelReferenceControl
extends LinkControl {
    protected int getNumButtons() {
        return 2;
    }

    protected Button[] createButtons(Composite composite) {
        Button[] buttons = new Button[2];
        EStructuralFeature.Setting setting = this.getFirstSetting();
        buttons[0] = this.createButtonForAction((Action)new DeleteReferenceAction(this.getEditingDomain(setting), setting, (ReferenceService)this.getService(ReferenceService.class)), composite);
        buttons[1] = this.createButtonForAction((Action)new FilteredReferenceAction(this.getEditingDomain(setting), setting, this.getItemPropertyDescriptor(setting), composite.getShell()), composite);
        return buttons;
    }

    private static class ECPViewEditorTreeSelectionDialog
    extends ElementTreeSelectionDialog {
        private TreePath treePath;

        public ECPViewEditorTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
        }

        public TreePath getTreePath() {
            TreeSelection selection;
            if (this.getTreeViewer() != null && !(selection = (TreeSelection)this.getTreeViewer().getSelection()).isEmpty()) {
                this.treePath = selection.getPaths()[0];
            }
            return this.treePath;
        }
    }

    private class FilteredReferenceAction
    extends AbstractFilteredReferenceAction {
        public FilteredReferenceAction(EditingDomain editingDomain, EStructuralFeature.Setting setting, IItemPropertyDescriptor descriptor, Shell shell) {
            super(editingDomain, setting, descriptor, shell);
        }

        public void run() {
            this.getEditingDomain().getCommandStack().execute((Command)new FilteredReferenceCommand((Notifier)this.getSetting().getEObject(), this.getShell()));
        }
    }

    private class FilteredReferenceCommand
    extends ChangeCommand {
        private final Shell shell;

        public FilteredReferenceCommand(Notifier notifier, Shell shell) {
            super(notifier);
            this.shell = shell;
        }

        protected void doExecute() {
            Object selection;
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TableColumnDomainModelReferenceControl.this.getComposedAdapterFactory());
            EReference eref = (EReference)((VFeaturePathDomainModelReference)TableColumnDomainModelReferenceControl.this.getFirstSetting().getEObject().eContainer()).getDomainModelEFeature();
            final ECPViewEditorTreeSelectionDialog dialog = new ECPViewEditorTreeSelectionDialog(this.shell, (ILabelProvider)labelProvider, this.getContentProvider(eref.getEReferenceType()));
            dialog.setValidator(new ECPSelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection.length != 0 && EStructuralFeature.class.isInstance(selection[0])) {
                        TreePath treePath = dialog.getTreePath();
                        if (!EAttribute.class.isInstance(selection[0])) {
                            return new Status(4, "org.eclipse.emf.ecp.view.editor.controls", "This is not an " + EAttribute.class.getSimpleName() + ".");
                        }
                        if (!Helper.hasFeaturePropertyDescriptor(((EStructuralFeature)EStructuralFeature.class.cast(selection[0])).getEContainingClass(), treePath)) {
                            return new Status(2, "org.eclipse.emf.ecp.view.editor.controls", "The selected " + EStructuralFeature.class.getSimpleName() + " has no PropertyDescriptor.");
                        }
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "org.eclipse.emf.ecp.view.editor.controls", "This is not an " + EStructuralFeature.class.getSimpleName() + ".");
                }
            });
            dialog.setInput(eref.getEReferenceType());
            dialog.setTitle("Select Attribute for TableColumn");
            int result = dialog.open();
            if (result == 0 && (EAttribute.class.isInstance(selection = dialog.getResult()[0]) || EReference.class.isInstance(selection) && ((EReference)EReference.class.cast(selection)).isContainment())) {
                EStructuralFeature selectedFeature = (EStructuralFeature)selection;
                VFeaturePathDomainModelReference dmr = (VFeaturePathDomainModelReference)TableColumnDomainModelReferenceControl.this.getFirstSetting().getEObject();
                dmr.setDomainModelEFeature(selectedFeature);
                ArrayList<EReference> bottomUpPath = new ArrayList<EReference>();
                TreePath path = dialog.getTreePath();
                int i = 0;
                while (i < path.getSegmentCount() - 1) {
                    Object o = path.getSegment(i);
                    if (EReference.class.isInstance(o)) {
                        bottomUpPath.add((EReference)o);
                    }
                    ++i;
                }
                dmr.getDomainModelEReferencePath().clear();
                dmr.getDomainModelEReferencePath().addAll(bottomUpPath);
            }
            labelProvider.dispose();
        }

        private ITreeContentProvider getContentProvider(EClass rootClass) {
            return new ITreeContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    if (EPackage.class.isInstance(element)) {
                        return true;
                    }
                    if (EClass.class.isInstance(element)) {
                        boolean hasAttributes;
                        EClass eClass = (EClass)element;
                        boolean hasReferences = !eClass.getEAllReferences().isEmpty();
                        boolean bl = hasAttributes = !eClass.getEAllAttributes().isEmpty();
                        return hasReferences || hasAttributes;
                    }
                    if (EReference.class.isInstance(element)) {
                        EReference eReference = (EReference)element;
                        if (!eReference.isContainment()) {
                            return false;
                        }
                        return this.hasChildren(eReference.getEReferenceType());
                    }
                    return false;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public Object[] getChildren(Object parentElement) {
                    if (EClass.class.isInstance(parentElement)) {
                        EClass eClass = (EClass)parentElement;
                        Set<Object> result = this.getElementsForEClass(eClass);
                        return result.toArray();
                    }
                    if (EReference.class.isInstance(parentElement)) {
                        EReference eReference = (EReference)parentElement;
                        Set<Object> result = this.getElementsForEClass(eReference.getEReferenceType());
                        return result.toArray();
                    }
                    if (EPackage.Registry.class.isInstance(parentElement)) {
                        return ((EPackage.Registry)EPackage.Registry.class.cast(parentElement)).values().toArray();
                    }
                    if (EPackage.class.isInstance(parentElement)) {
                        LinkedHashSet children = new LinkedHashSet();
                        children.addAll(((EPackage)EPackage.class.cast(parentElement)).getESubpackages());
                        children.addAll(((EPackage)EPackage.class.cast(parentElement)).getEClassifiers());
                        return children.toArray();
                    }
                    return null;
                }

                private Set<Object> getElementsForEClass(EClass eClass) {
                    LinkedHashSet<Object> result = new LinkedHashSet<Object>();
                    if (eClass.isAbstract() || eClass.isInterface()) {
                        for (EClassifier eClassifier : eClass.getEPackage().getEClassifiers()) {
                            if (eClass == eClassifier || !EClass.class.isInstance(eClassifier) || !eClass.isSuperTypeOf((EClass)eClassifier)) continue;
                            result.add(eClassifier);
                        }
                    } else {
                        result.addAll((Collection<Object>)eClass.getEAllReferences());
                        result.addAll((Collection<Object>)eClass.getEAllAttributes());
                    }
                    return result;
                }
            };
        }
    }
}

