/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.rule.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.rule.model.LeafCondition;

public class LeafConditionSettingIterator
implements Iterator<EStructuralFeature.Setting> {
    private final Map<Iterator<EStructuralFeature.Setting>, Iterator<EObject>> iteratorToCurrentChildrenMap;
    private int expectedStackSize;
    private final Stack<Iterator<EStructuralFeature.Setting>> iterators;
    private final boolean includeNonValueRelatedSettings;
    private final Set<VDomainModelReference> dmrs;
    private final List<EStructuralFeature.Setting> nonValueRelSettings = new LinkedList<EStructuralFeature.Setting>();
    private final LeafCondition condition;

    public LeafConditionSettingIterator(LeafCondition condition, boolean includeNonValueRelatedSettings) {
        this.condition = condition;
        this.dmrs = new LinkedHashSet<VDomainModelReference>();
        this.includeNonValueRelatedSettings = includeNonValueRelatedSettings;
        this.iteratorToCurrentChildrenMap = new LinkedHashMap<Iterator<EStructuralFeature.Setting>, Iterator<EObject>>();
        this.expectedStackSize = 1;
        if (condition.getValueDomainModelReference() != null) {
            ++this.expectedStackSize;
        }
        this.iterators = new Stack();
        this.iterators.push(condition.getDomainModelReference().getIterator());
        this.organizeStack();
    }

    private void organizeStack() {
        if (this.iterators.size() == 0) {
            return;
        }
        if (this.iterators.size() == this.expectedStackSize && this.iterators.peek().hasNext()) {
            return;
        }
        if (this.iterators.size() == this.expectedStackSize) {
            this.iterators.pop();
            this.organizeStack();
            return;
        }
        Iterator<EObject> domainIterator = this.iteratorToCurrentChildrenMap.get(this.iterators.peek());
        if (domainIterator == null) {
            if (this.iterators.peek().hasNext()) {
                EStructuralFeature.Setting setting = this.iterators.peek().next();
                if (this.includeNonValueRelatedSettings) {
                    this.nonValueRelSettings.add(setting);
                }
                Iterator<EObject> childIterator = this.getChildIterator(setting);
                this.iteratorToCurrentChildrenMap.put(this.iterators.peek(), childIterator);
                this.organizeStack();
                return;
            }
            this.iterators.pop();
            this.organizeStack();
            return;
        }
        if (domainIterator.hasNext()) {
            EObject nextDomain = domainIterator.next();
            VDomainModelReference valueDMR = (VDomainModelReference)EcoreUtil.copy((EObject)this.condition.getValueDomainModelReference());
            valueDMR.init(nextDomain);
            this.dmrs.add(valueDMR);
            this.iterators.push(valueDMR.getIterator());
            this.organizeStack();
            return;
        }
        this.iteratorToCurrentChildrenMap.remove(this.iterators.peek());
        this.organizeStack();
    }

    private Iterator<EObject> getChildIterator(EStructuralFeature.Setting setting) {
        ArrayList<EObject> children = new ArrayList<EObject>();
        if (setting.getEStructuralFeature().isMany()) {
            children.addAll((Collection)setting.get(true));
        } else {
            children.add((EObject)setting.get(true));
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        return children.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.includeNonValueRelatedSettings && !this.nonValueRelSettings.isEmpty()) {
            return true;
        }
        if (this.iterators.isEmpty()) {
            return false;
        }
        return this.iterators.peek().hasNext();
    }

    @Override
    public EStructuralFeature.Setting next() {
        if (this.includeNonValueRelatedSettings && !this.nonValueRelSettings.isEmpty()) {
            return this.nonValueRelSettings.remove(0);
        }
        EStructuralFeature.Setting result = this.iterators.peek().next();
        this.organizeStack();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Set<VDomainModelReference> getUsedValueDomainModelReferences() {
        return this.dmrs;
    }
}

