/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.ide.internal.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emfforms.bazaar.Bid;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.ide.builder.DefaultMarkerHelper;
import org.eclipse.emfforms.ide.builder.MarkerHelperProvider;
import org.osgi.service.component.annotations.Component;

public class ViewModelMarkerHelper
extends DefaultMarkerHelper {
    private final IFile file;
    public static final String MARKER_ID = "org.eclipse.emfforms.ide.builder.ViewModelProblem";

    @Override
    protected String getMarkerID() {
        return MARKER_ID;
    }

    ViewModelMarkerHelper(IFile file) {
        this.file = file;
    }

    public void createMarkers(final Diagnostic diagnostic) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int severity = diagnostic.getSeverity();
                if (severity < 2) {
                    return;
                }
                if (diagnostic.getChildren().isEmpty()) {
                    ViewModelMarkerHelper.this.createMarkers((IResource)ViewModelMarkerHelper.this.getFile(diagnostic), diagnostic, null);
                } else {
                    for (Diagnostic child : diagnostic.getChildren()) {
                        Diagnostic relevant = ViewModelMarkerHelper.this.extractRelevantDiagnostic(child);
                        ViewModelMarkerHelper.this.createMarkers((IResource)ViewModelMarkerHelper.this.getFile(diagnostic), relevant, diagnostic);
                    }
                }
            }
        }, null);
    }

    private Diagnostic extractRelevantDiagnostic(Diagnostic parentDiagnostic) {
        if (parentDiagnostic.getSeverity() == 0 || parentDiagnostic.getChildren().isEmpty()) {
            return parentDiagnostic;
        }
        Diagnostic result = (Diagnostic)parentDiagnostic.getChildren().get(0);
        int currentHighest = result.getSeverity();
        for (Diagnostic child : parentDiagnostic.getChildren()) {
            if (child.getSeverity() > currentHighest) {
                currentHighest = child.getSeverity();
                result = child;
                continue;
            }
            if (child.getSeverity() != currentHighest || "org.eclipse.emf.ecp.view.spi.model".equals(result.getSource()) || !"org.eclipse.emf.ecp.view.spi.model".equals(child.getSource())) continue;
            currentHighest = child.getSeverity();
            result = child;
        }
        return result;
    }

    @Override
    protected IFile getFile(Object datum) {
        if (this.file != null) {
            return this.file;
        }
        return super.getFile(datum);
    }

    @Component
    public static class Provider
    implements MarkerHelperProvider {
        private static final Double BID = 10.0;
        private static final String VIEW = "view";

        @Bid
        public Double bid(IFile file) {
            return Provider.isViewModelResource(file) ? BID : null;
        }

        @Create
        public MarkerHelper createMarkerHelper(IFile file) {
            return new ViewModelMarkerHelper(file);
        }

        private static boolean isViewModelResource(IFile resource) {
            return VIEW.equals(resource.getFileExtension());
        }
    }
}

