/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.LinkedHashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.internal.editor.handler.GenerateTableColumnsUtil;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTablePackage;
import org.eclipse.emf.ecp.view.spi.treemasterdetail.ui.swt.MasterDetailAction;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.ide.view.segments.ToolingModeUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateTableColumnsForSubclassesHandler
extends MasterDetailAction {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selection = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (selection == null || !(selection instanceof EObject)) {
            return null;
        }
        this.execute((EObject)selection);
        return null;
    }

    public boolean shouldShow(EObject eObject) {
        return VTableControl.class.isInstance(eObject) && !ToolingModeUtil.isSegmentToolingEnabled();
    }

    public void execute(EObject object) {
        IEMFValueProperty valueProperty;
        VTableControl tableControl = (VTableControl)VTableControl.class.cast(object);
        VDomainModelReference domainModelReference = tableControl.getDomainModelReference();
        if (domainModelReference == null || !VTableDomainModelReference.class.isInstance(domainModelReference)) {
            return;
        }
        VTableDomainModelReference tableDMR = (VTableDomainModelReference)domainModelReference;
        EClass rootEClass = Helper.getRootEClass((EObject)tableControl);
        try {
            valueProperty = Activator.getDefault().getEMFFormsDatabinding().getValueProperty((VDomainModelReference)tableDMR, rootEClass);
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return;
        }
        Object eStructuralFeature = valueProperty.getValueType();
        if (!EReference.class.isInstance(eStructuralFeature)) {
            return;
        }
        EReference eReference = (EReference)eStructuralFeature;
        LinkedHashSet<EStructuralFeature> existingFeatures = new LinkedHashSet<EStructuralFeature>();
        for (VDomainModelReference ref : tableDMR.getColumnDomainModelReferences()) {
            VFeaturePathDomainModelReference featureDMR = (VFeaturePathDomainModelReference)ref;
            existingFeatures.add(featureDMR.getDomainModelEFeature());
        }
        LinkedHashSet<VFeaturePathDomainModelReference> referencesToAdd = new LinkedHashSet<VFeaturePathDomainModelReference>();
        EClass subclass = GenerateTableColumnsUtil.selectSubClass(eReference.getEReferenceType()).orElse(null);
        if (subclass == null) {
            return;
        }
        for (EAttribute attribute : subclass.getEAllAttributes()) {
            if (existingFeatures.contains(attribute)) continue;
            VFeaturePathDomainModelReference dmr = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            dmr.setDomainModelEFeature((EStructuralFeature)attribute);
            referencesToAdd.add(dmr);
        }
        EditingDomain editingDomainFor = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        Command command = AddCommand.create((EditingDomain)editingDomainFor, (Object)tableDMR, (Object)VTablePackage.eINSTANCE.getTableDomainModelReference_ColumnDomainModelReferences(), referencesToAdd);
        editingDomainFor.getCommandStack().execute(command);
    }
}

