/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.diffmerge.swt;

import org.eclipse.emf.ecp.diffmerge.spi.context.ControlPair;
import org.eclipse.emf.ecp.diffmerge.spi.context.DiffMergeModelContext;
import org.eclipse.emf.ecp.diffmerge.swt.Activator;
import org.eclipse.emf.ecp.diffmerge.swt.DiffDialog;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class DiffDialogHelper {
    private DiffDialogHelper() {
    }

    public static void showDialog(DiffMergeModelContext diffModelContext, int diffIndex) throws IllegalArgumentException {
        VControl control = diffModelContext.getControl(diffIndex);
        String label = DiffDialogHelper.getControlLabel(control, diffModelContext);
        DiffDialogHelper.showDialog(diffModelContext, control, label);
    }

    public static void showDialog(DiffMergeModelContext diffModelContext, VControl vControl, String featureLabel) throws IllegalArgumentException {
        ControlPair pairWithDiff = diffModelContext.getPairWithDiff(vControl);
        if (pairWithDiff == null) {
            return;
        }
        DiffDialog dialog = new DiffDialog(diffModelContext, featureLabel, pairWithDiff.getLeftControl(), pairWithDiff.getRightControl(), vControl);
        Shell shell = new Shell(68656);
        int index = diffModelContext.getIndexOf(vControl);
        if (index == -1) {
            throw new IllegalArgumentException("This VControl doesn't has a difference.");
        }
        shell.setText(String.format(LocalizationServiceHelper.getString(DiffDialogHelper.class, (String)"DiffDialog_title"), featureLabel, index + 1, diffModelContext.getTotalNumberOfDiffs()));
        shell.setLayout((Layout)new FillLayout());
        Rectangle clientArea = shell.getDisplay().getBounds();
        shell.setSize(clientArea.width / 2, 500);
        dialog.create((Composite)shell);
        shell.setLocation(clientArea.width / 4, clientArea.height / 4);
        shell.open();
    }

    private static String getControlLabel(VControl control, DiffMergeModelContext diffModelContext) {
        try {
            return (String)Activator.getInstance().getEMFFormsLabelProvider().getDisplayName(control.getDomainModelReference(), diffModelContext.getDomainModel()).getValue();
        }
        catch (NoLabelFoundException e) {
            return e.getMessage();
        }
    }
}

