/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.view.migrator;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SAXUtil {
    private SAXUtil() {
    }

    public static void executeContentHandler(Reader modelReader, ContentHandler contentHandler) {
        try {
            try {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                xmlReader.setContentHandler(contentHandler);
                xmlReader.parse(new InputSource(modelReader));
            }
            catch (SAXException xmlReader) {
                try {
                    if (modelReader != null) {
                        modelReader.close();
                    }
                }
                catch (IOException e) {
                    SAXUtil.log(e);
                }
            }
            catch (IOException ex) {
                SAXUtil.log(ex);
                try {
                    if (modelReader != null) {
                        modelReader.close();
                    }
                }
                catch (IOException e) {
                    SAXUtil.log(e);
                }
            }
        }
        finally {
            try {
                if (modelReader != null) {
                    modelReader.close();
                }
            }
            catch (IOException e) {
                SAXUtil.log(e);
            }
        }
    }

    private static void log(Throwable ex) {
        Bundle bundle = FrameworkUtil.getBundle(SAXUtil.class);
        if (bundle == null) {
            return;
        }
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ReportService.class);
        if (serviceReference == null) {
            return;
        }
        ReportService reportService = (ReportService)bundleContext.getService(serviceReference);
        reportService.report(new AbstractReport(ex));
        bundleContext.ungetService(serviceReference);
    }
}

